/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.subscribe.eventengine.effect;

import com.pubnub.api.logging.LogConfig;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.internal.eventengine.Effect;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.subscribe.eventengine.effect.MessagesConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/pubnub/internal/subscribe/eventengine/effect/EmitMessagesEffect;", "Lcom/pubnub/internal/eventengine/Effect;", "messagesConsumer", "Lcom/pubnub/internal/subscribe/eventengine/effect/MessagesConsumer;", "messages", "", "Lcom/pubnub/api/models/consumer/pubsub/PNEvent;", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "<init>", "(Lcom/pubnub/internal/subscribe/eventengine/effect/MessagesConsumer;Ljava/util/List;Lcom/pubnub/api/logging/LogConfig;)V", "log", "Lcom/pubnub/internal/logging/PNLogger;", "runEffect", "", "pubnub-kotlin-impl"})
public final class EmitMessagesEffect
implements Effect {
    @NotNull
    private final MessagesConsumer messagesConsumer;
    @NotNull
    private final List<PNEvent> messages;
    @NotNull
    private final LogConfig logConfig;
    @NotNull
    private final PNLogger log;

    public EmitMessagesEffect(@NotNull MessagesConsumer messagesConsumer, @NotNull List<? extends PNEvent> messages, @NotNull LogConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)messagesConsumer, (String)"messagesConsumer");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        this.messagesConsumer = messagesConsumer;
        this.messages = messages;
        this.logConfig = logConfig;
        this.log = LoggerManager.Companion.getInstance().getLogger(this.logConfig, this.getClass());
    }

    @Override
    public void runEffect() {
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text("Running EmitMessagesEffect: Emitting " + this.messages.size() + " messages to consumers"), null, null, null, null, null, null, 126, null));
        for (PNEvent message : this.messages) {
            try {
                PNEvent pNEvent = message;
                if (pNEvent instanceof PNMessageResult) {
                    this.messagesConsumer.announce((PNMessageResult)message);
                    continue;
                }
                if (pNEvent instanceof PNPresenceEventResult) {
                    this.messagesConsumer.announce((PNPresenceEventResult)message);
                    continue;
                }
                if (pNEvent instanceof PNSignalResult) {
                    this.messagesConsumer.announce((PNSignalResult)message);
                    continue;
                }
                if (pNEvent instanceof PNMessageActionResult) {
                    this.messagesConsumer.announce((PNMessageActionResult)message);
                    continue;
                }
                if (pNEvent instanceof PNObjectEventResult) {
                    this.messagesConsumer.announce((PNObjectEventResult)message);
                    continue;
                }
                if (!(pNEvent instanceof PNFileEventResult)) continue;
                this.messagesConsumer.announce((PNFileEventResult)message);
            }
            catch (Throwable throwable) {}
        }
    }
}

