/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.pubsub;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.pubsub.Signal;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005:\u0001&B-\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0014J8\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00192\"\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u001cH\u0014J\u001c\u0010\u001d\u001a\u00020\u00042\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/SignalEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/PNPublishResult;", "Lcom/pubnub/api/endpoints/pubsub/Signal;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channel", "", "message", "customMessageType", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "getChannel", "()Ljava/lang/String;", "getMessage", "()Ljava/lang/Object;", "getCustomMessageType", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "", "getAffectedChannels", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSignalOperation;", "isPubKeyRequired", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "Companion", "pubnub-kotlin-impl"})
public final class SignalEndpoint
extends EndpointCore<List<? extends Object>, PNPublishResult>
implements Signal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String channel;
    @NotNull
    private final Object message;
    @Nullable
    private final String customMessageType;
    @NotNull
    private final PNLogger log;
    @NotNull
    private static final String CUSTOM_MESSAGE_TYPE_QUERY_PARAM = "custom_message_type";

    public SignalEndpoint(@NotNull PubNubImpl pubnub, @NotNull String channel, @NotNull Object message, @Nullable String customMessageType) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(pubnub);
        this.channel = channel;
        this.message = message;
        this.customMessageType = customMessageType;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    public /* synthetic */ SignalEndpoint(PubNubImpl pubNubImpl, String string, Object object, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(pubNubImpl, string, object, string2);
    }

    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @NotNull
    public Object getMessage() {
        return this.message;
    }

    @Nullable
    public String getCustomMessageType() {
        return this.customMessageType;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) {
        block1: {
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"channel", (Object)this.getChannel());
            pairArray[1] = TuplesKt.to((Object)"message", (Object)this.getMessage());
            String string = this.getCustomMessageType();
            if (string == null) {
                string = "";
            }
            pairArray[2] = TuplesKt.to((Object)"customMessageType", (Object)string);
            this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "Signal API call", null, null, null, null, null, 124, null));
            String string2 = this.getCustomMessageType();
            if (string2 == null) break block1;
            String customMessageTypeNotNull = string2;
            boolean bl = false;
            ((Map)queryParams).put(CUSTOM_MESSAGE_TYPE_QUERY_PARAM, customMessageTypeNotNull);
        }
        return this.getRetrofitManager().getSignalService$pubnub_kotlin_impl().signal(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.getChannel(), this.getPubnub().getMapper().toJson(this.getMessage()), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPublishResult createResponse(@NotNull Response<List<Object>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPublishResult(Long.parseLong(((List)object).get(2).toString()));
    }

    @NotNull
    public PNOperationType.PNSignalOperation operationType() {
        return PNOperationType.PNSignalOperation.INSTANCE;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUBLISH;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/SignalEndpoint$Companion;", "", "<init>", "()V", "CUSTOM_MESSAGE_TYPE_QUERY_PARAM", "", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

