/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.message_actions;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.message_actions.RemoveMessageAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.message_actions.PNRemoveMessageActionResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.services.MessageActionService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B)\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0014J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001cj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u001dH\u0014J\u0016\u0010\u001e\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pubnub/internal/endpoints/message_actions/RemoveMessageActionEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/message_actions/PNRemoveMessageActionResult;", "Lcom/pubnub/api/endpoints/message_actions/RemoveMessageAction;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channel", "", "messageTimetoken", "", "actionTimetoken", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;JJ)V", "getChannel", "()Ljava/lang/String;", "getMessageTimetoken", "()J", "getActionTimetoken", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "", "getAffectedChannels", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNDeleteMessageAction;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
public final class RemoveMessageActionEndpoint
extends EndpointCore<Void, PNRemoveMessageActionResult>
implements RemoveMessageAction {
    @NotNull
    private final String channel;
    private final long messageTimetoken;
    private final long actionTimetoken;
    @NotNull
    private final PNLogger log;

    public RemoveMessageActionEndpoint(@NotNull PubNubImpl pubnub, @NotNull String channel, long messageTimetoken, long actionTimetoken) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.channel = channel;
        this.messageTimetoken = messageTimetoken;
        this.actionTimetoken = actionTimetoken;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    @NotNull
    public String getChannel() {
        return this.channel;
    }

    public long getMessageTimetoken() {
        return this.messageTimetoken;
    }

    public long getActionTimetoken() {
        return this.actionTimetoken;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Object object = new Pair[]{TuplesKt.to((Object)"channel", (Object)this.getChannel()), TuplesKt.to((Object)"messageTimetoken", (Object)this.getMessageTimetoken()), TuplesKt.to((Object)"actionTimetoken", (Object)this.getActionTimetoken())};
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])object), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "RemoveMessageAction API call", null, null, null, null, null, 124, null));
        MessageActionService messageActionService = this.getRetrofitManager().getMessageActionService$pubnub_kotlin_impl();
        String string = this.getConfiguration().getSubscribeKey();
        String string2 = this.getChannel();
        object = String.valueOf(this.getMessageTimetoken());
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        object = String.valueOf(this.getActionTimetoken());
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string4 = ((String)object).toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        return messageActionService.deleteMessageAction(string, string2, string3, string4, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNRemoveMessageActionResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNRemoveMessageActionResult();
    }

    @NotNull
    public PNOperationType.PNDeleteMessageAction operationType() {
        return PNOperationType.PNDeleteMessageAction.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_REACTION;
    }
}

