/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.access;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.access.GrantToken;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.logging.LogMessageType;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNGrantTokenResult;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.PNConfiguration;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.models.server.access_manager.v3.GrantTokenRequestBody;
import com.pubnub.internal.models.server.access_manager.v3.GrantTokenResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BU\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J2\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\"\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0!j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f`\"H\u0014J\u0016\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0014J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020+H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/pubnub/internal/endpoints/access/GrantTokenEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/access_manager/v3/GrantTokenResponse;", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNGrantTokenResult;", "Lcom/pubnub/api/endpoints/access/GrantToken;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "ttl", "", "meta", "", "authorizedUUID", "", "channels", "", "Lcom/pubnub/api/models/consumer/access_manager/v3/ChannelGrant;", "channelGroups", "Lcom/pubnub/api/models/consumer/access_manager/v3/ChannelGroupGrant;", "uuids", "Lcom/pubnub/api/models/consumer/access_manager/v3/UUIDGrant;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;ILjava/lang/Object;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getTtl", "()I", "log", "Lcom/pubnub/internal/logging/PNLogger;", "getAffectedChannels", "getAffectedChannelGroups", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "isAuthRequired", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nGrantTokenEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrantTokenEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantTokenEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1563#2:99\n1634#2,3:100\n1563#2:103\n1634#2,3:104\n1563#2:107\n1634#2,3:108\n1563#2:111\n1634#2,3:112\n1563#2:115\n1634#2,3:116\n1#3:119\n*S KotlinDebug\n*F\n+ 1 GrantTokenEndpoint.kt\ncom/pubnub/internal/endpoints/access/GrantTokenEndpoint\n*L\n35#1:99\n35#1:100,3\n37#1:103\n37#1:104,3\n62#1:107\n62#1:108,3\n65#1:111\n65#1:112,3\n66#1:115\n66#1:116,3\n*E\n"})
public final class GrantTokenEndpoint
extends EndpointCore<GrantTokenResponse, PNGrantTokenResult>
implements GrantToken {
    private final int ttl;
    @Nullable
    private final Object meta;
    @Nullable
    private final String authorizedUUID;
    @NotNull
    private final List<ChannelGrant> channels;
    @NotNull
    private final List<ChannelGroupGrant> channelGroups;
    @NotNull
    private final List<UUIDGrant> uuids;
    @NotNull
    private final PNLogger log;

    public GrantTokenEndpoint(@NotNull PubNubImpl pubnub, int ttl, @Nullable Object meta, @Nullable String authorizedUUID, @NotNull List<? extends ChannelGrant> channels, @NotNull List<? extends ChannelGroupGrant> channelGroups, @NotNull List<? extends UUIDGrant> uuids) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        super(pubnub);
        this.ttl = ttl;
        this.meta = meta;
        this.authorizedUUID = authorizedUUID;
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuids = uuids;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    public int getTtl() {
        return this.ttl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGrant channelGrant = (ChannelGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channelGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGroupGrant channelGroupGrant = (ChannelGroupGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void validateParams() {
        if (!PNConfiguration.Companion.isValid(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING, null, 2, null);
        }
        if (!PNConfiguration.Companion.isValid(this.getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING, null, 2, null);
        }
        if (CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.channels, (Iterable)this.channelGroups), (Iterable)this.uuids).isEmpty()) {
            PubNubError pubNubError = PubNubError.RESOURCES_MISSING;
            throw new PubNubException("At least one grant required", pubNubError, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    @Override
    @NotNull
    protected Call<GrantTokenResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Pair[] pairArray;
        ChannelGroupGrant it;
        Collection<Map> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray2 = new Pair[6];
        pairArray2[0] = TuplesKt.to((Object)"ttl", (Object)this.getTtl());
        Object object = this.meta;
        if (object == null) {
            object = "";
        }
        pairArray2[1] = TuplesKt.to((Object)"meta", (Object)object);
        String string = this.authorizedUUID;
        if (string == null) {
            string = "";
        }
        pairArray2[2] = TuplesKt.to((Object)"authorizedUUID", (Object)string);
        Iterable iterable = this.channels;
        String string2 = "channels";
        int n = 3;
        Pair[] pairArray3 = pairArray2;
        PNLogger pNLogger = this.log;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChannelGrant channelGrant = (ChannelGrant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)it.getId()), TuplesKt.to((Object)"read", (Object)it.getRead()), TuplesKt.to((Object)"write", (Object)it.getWrite()), TuplesKt.to((Object)"manage", (Object)it.getManage()), TuplesKt.to((Object)"delete", (Object)it.getDelete()), TuplesKt.to((Object)"get", (Object)it.getGet()), TuplesKt.to((Object)"update", (Object)it.getUpdate()), TuplesKt.to((Object)"join", (Object)it.getJoin())};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        pairArray3[n] = TuplesKt.to((Object)string2, (Object)collection);
        $this$map$iv = this.channelGroups;
        string2 = "channelGroups";
        n = 4;
        pairArray3 = pairArray2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ChannelGroupGrant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)it.getId()), TuplesKt.to((Object)"read", (Object)it.getRead()), TuplesKt.to((Object)"write", (Object)it.getWrite()), TuplesKt.to((Object)"manage", (Object)it.getManage())};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        pairArray3[n] = TuplesKt.to((Object)string2, (Object)collection);
        $this$map$iv = this.uuids;
        string2 = "uuids";
        n = 5;
        pairArray3 = pairArray2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UUIDGrant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)it.getId()), TuplesKt.to((Object)"get", (Object)it.getGet()), TuplesKt.to((Object)"update", (Object)it.getUpdate()), TuplesKt.to((Object)"delete", (Object)it.getDelete())};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        pairArray3[n] = TuplesKt.to((Object)string2, collection);
        String string3 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Map map = MapsKt.mapOf((Pair[])pairArray2);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 124;
        String string4 = null;
        Level level = null;
        String string5 = null;
        String string6 = null;
        LogMessageType logMessageType = null;
        String string7 = "GrantToken API call";
        LogMessageContent logMessageContent = (LogMessageContent)new LogMessageContent.Object(map, string3);
        pNLogger.debug(new LogMessage(logMessageContent, string7, logMessageType, string6, string5, level, string4, n2, defaultConstructorMarker));
        GrantTokenRequestBody requestBody = GrantTokenRequestBody.Companion.of(this.getTtl(), this.channels, this.channelGroups, this.uuids, this.meta, this.authorizedUUID);
        return this.getRetrofitManager().getAccessManagerService$pubnub_kotlin_impl().grantToken(this.getConfiguration().getSubscribeKey(), requestBody, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNGrantTokenResult createResponse(@NotNull Response<GrantTokenResponse> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        String it = ((GrantTokenResponse)object).getData().getToken();
        boolean bl = false;
        return new PNGrantTokenResult(it);
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.PNAccessManagerGrantToken.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }
}

