/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.v2.subscription;

import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.api.v2.callbacks.EventEmitter;
import com.pubnub.api.v2.callbacks.EventListener;
import com.pubnub.api.v2.subscriptions.SubscribeCapable;
import com.pubnub.api.v2.subscriptions.SubscriptionCursor;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.managers.AnnouncementCallback;
import com.pubnub.internal.managers.AnnouncementEnvelope;
import com.pubnub.internal.v2.callbacks.EventEmitterImpl;
import com.pubnub.internal.v2.subscription.EmitterHelper;
import com.pubnub.internal.v2.subscription.SubscriptionInternal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u00032\u00060\u0004j\u0002`\u0005B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u0013\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J\u0016\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u00103\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001d\u0018\u0001012\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001d\u0018\u0001018V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b6\u00107\"\u0004\b8\u00109*\u0004\b4\u00105RG\u0010;\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u001d\u0018\u0001012\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u001d\u0018\u0001018V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b=\u00107\"\u0004\b>\u00109*\u0004\b<\u00105RG\u0010@\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u001d\u0018\u0001012\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u001d\u0018\u0001018V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bB\u00107\"\u0004\bC\u00109*\u0004\bA\u00105RG\u0010E\u001a\u0010\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020\u001d\u0018\u0001012\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020\u001d\u0018\u0001018V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bG\u00107\"\u0004\bH\u00109*\u0004\bF\u00105RG\u0010J\u001a\u0010\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\u001d\u0018\u0001012\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\u001d\u0018\u0001018V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bL\u00107\"\u0004\bM\u00109*\u0004\bK\u00105RG\u0010O\u001a\u0010\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020\u001d\u0018\u0001012\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020\u001d\u0018\u0001018V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bQ\u00107\"\u0004\bR\u00109*\u0004\bP\u00105\u00a8\u0006S"}, d2={"Lcom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl;", "SubscriptionT", "Lcom/pubnub/api/v2/callbacks/EventEmitter;", "Lcom/pubnub/api/v2/subscriptions/SubscribeCapable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "initialSubscriptions", "", "Lcom/pubnub/internal/v2/subscription/SubscriptionInternal;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/Set;)V", "getPubnub", "()Lcom/pubnub/internal/PubNubImpl;", "subscriptionsInternal", "Ljava/util/concurrent/CopyOnWriteArraySet;", "getSubscriptionsInternal", "()Ljava/util/concurrent/CopyOnWriteArraySet;", "subscriptions", "getSubscriptions", "()Ljava/util/Set;", "eventEmitter", "Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "accepts", "", "envelope", "Lcom/pubnub/internal/managers/AnnouncementEnvelope;", "add", "", "subscription", "(Ljava/lang/Object;)V", "remove", "subscribe", "cursor", "Lcom/pubnub/api/v2/subscriptions/SubscriptionCursor;", "unsubscribe", "close", "addListener", "listener", "Lcom/pubnub/api/v2/callbacks/EventListener;", "removeListener", "Lcom/pubnub/api/callbacks/Listener;", "removeAllListeners", "plusAssign", "minusAssign", "emitterHelper", "Lcom/pubnub/internal/v2/subscription/EmitterHelper;", "<set-?>", "Lkotlin/Function1;", "Lcom/pubnub/api/models/consumer/pubsub/PNMessageResult;", "onMessage", "getOnMessage$delegate", "(Lcom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl;)Ljava/lang/Object;", "getOnMessage", "()Lkotlin/jvm/functions/Function1;", "setOnMessage", "(Lkotlin/jvm/functions/Function1;)V", "Lcom/pubnub/api/models/consumer/pubsub/PNPresenceEventResult;", "onPresence", "getOnPresence$delegate", "getOnPresence", "setOnPresence", "Lcom/pubnub/api/models/consumer/pubsub/PNSignalResult;", "onSignal", "getOnSignal$delegate", "getOnSignal", "setOnSignal", "Lcom/pubnub/api/models/consumer/pubsub/message_actions/PNMessageActionResult;", "onMessageAction", "getOnMessageAction$delegate", "getOnMessageAction", "setOnMessageAction", "Lcom/pubnub/api/models/consumer/pubsub/objects/PNObjectEventResult;", "onObjects", "getOnObjects$delegate", "getOnObjects", "setOnObjects", "Lcom/pubnub/api/models/consumer/pubsub/files/PNFileEventResult;", "onFile", "getOnFile$delegate", "getOnFile", "setOnFile", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nBaseSubscriptionSetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSubscriptionSetImpl.kt\ncom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n1740#2,3:98\n1761#2,3:102\n1869#2,2:105\n1869#2,2:111\n1#3:101\n37#4:107\n36#4,3:108\n37#4:113\n36#4,3:114\n*S KotlinDebug\n*F\n+ 1 BaseSubscriptionSetImpl.kt\ncom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl\n*L\n32#1:98,3\n29#1:102,3\n49#1:105,2\n54#1:111,2\n50#1:107\n50#1:108,3\n55#1:113\n55#1:114,3\n*E\n"})
public abstract class BaseSubscriptionSetImpl<SubscriptionT>
implements EventEmitter,
SubscribeCapable,
AutoCloseable {
    @NotNull
    private final PubNubImpl pubnub;
    @NotNull
    private final CopyOnWriteArraySet<SubscriptionInternal> subscriptionsInternal;
    @NotNull
    private final EventEmitterImpl eventEmitter;
    @NotNull
    private final EmitterHelper emitterHelper;

    public BaseSubscriptionSetImpl(@NotNull PubNubImpl pubnub, @NotNull Set<? extends SubscriptionInternal> initialSubscriptions) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
            Intrinsics.checkNotNullParameter(initialSubscriptions, (String)"initialSubscriptions");
            this.pubnub = pubnub;
            this.subscriptionsInternal = new CopyOnWriteArraySet();
            this.eventEmitter = new EventEmitterImpl(AnnouncementCallback.Phase.SET, (Function1<? super AnnouncementEnvelope<? extends PNEvent>, Boolean>)new Function1<AnnouncementEnvelope<?>, Boolean>(this){

                public final Boolean invoke(AnnouncementEnvelope<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return BaseSubscriptionSetImpl.access$accepts((BaseSubscriptionSetImpl)this.receiver, p0);
                }
            });
            Iterable $this$all$iv = initialSubscriptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SubscriptionInternal it = (SubscriptionInternal)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getPubnub(), (Object)this.pubnub)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Adding Subscriptions from another PubNub instance to a SubscriptionSet is not allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        this.subscriptionsInternal.addAll((Collection<SubscriptionInternal>)initialSubscriptions);
        this.pubnub.getListenerManager().addAnnouncementCallback$pubnub_kotlin_impl(this.eventEmitter);
        this.emitterHelper = new EmitterHelper(this.eventEmitter);
    }

    @NotNull
    public final PubNubImpl getPubnub() {
        return this.pubnub;
    }

    @NotNull
    protected final CopyOnWriteArraySet<SubscriptionInternal> getSubscriptionsInternal() {
        return this.subscriptionsInternal;
    }

    @NotNull
    public abstract Set<SubscriptionT> getSubscriptions();

    private final boolean accepts(AnnouncementEnvelope<?> envelope) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.subscriptionsInternal;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SubscriptionInternal subscription = (SubscriptionInternal)element$iv;
                    boolean bl2 = false;
                    if (!envelope.getAcceptedBy().contains(subscription)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void add(SubscriptionT subscription) {
        if (!(subscription instanceof SubscriptionInternal)) {
            boolean $i$a$-require-BaseSubscriptionSetImpl$add$32 = false;
            String $i$a$-require-BaseSubscriptionSetImpl$add$32 = "Only Subscriptions returned from objects createdthrough the PubNub instance and their methods, such as channel(...).subscriptions() are supported.";
            throw new IllegalArgumentException($i$a$-require-BaseSubscriptionSetImpl$add$32.toString());
        }
        if (!Intrinsics.areEqual((Object)((SubscriptionInternal)subscription).getPubnub(), (Object)this.pubnub)) {
            boolean bl = false;
            String string = "Adding Subscriptions from another PubNub instance to a SubscriptionSet is not allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        this.subscriptionsInternal.add((SubscriptionInternal)subscription);
    }

    public final void remove(SubscriptionT subscription) {
        if (!(subscription instanceof SubscriptionInternal)) {
            boolean bl = false;
            String string = "Only Subscriptions returned from objects createdthrough the PubNub instance and their methods, such as channel(...).subscriptions() are supported.";
            throw new IllegalArgumentException(string.toString());
        }
        this.subscriptionsInternal.remove(subscription);
    }

    public void subscribe(@NotNull SubscriptionCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Iterable $this$forEach$iv = this.subscriptionsInternal;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SubscriptionInternal it = (SubscriptionInternal)element$iv;
            boolean bl = false;
            it.onSubscriptionActive(cursor);
        }
        Collection $this$toTypedArray$iv = this.subscriptionsInternal;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SubscriptionInternal[] subscriptionInternalArray = thisCollection$iv.toArray(new SubscriptionInternal[0]);
        this.pubnub.subscribe$pubnub_kotlin_impl(Arrays.copyOf(subscriptionInternalArray, subscriptionInternalArray.length), cursor);
    }

    public void unsubscribe() {
        Iterable $this$forEach$iv = this.subscriptionsInternal;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SubscriptionInternal it = (SubscriptionInternal)element$iv;
            boolean bl = false;
            it.onSubscriptionInactive();
        }
        Collection $this$toTypedArray$iv = this.subscriptionsInternal;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SubscriptionInternal[] subscriptionInternalArray = thisCollection$iv.toArray(new SubscriptionInternal[0]);
        this.pubnub.unsubscribe$pubnub_kotlin_impl(Arrays.copyOf(subscriptionInternalArray, subscriptionInternalArray.length));
    }

    @Override
    public void close() {
        this.unsubscribe();
        this.pubnub.getListenerManager().removeAnnouncementCallback$pubnub_kotlin_impl(this.eventEmitter);
    }

    public void addListener(@NotNull EventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventEmitter.addListener(listener);
    }

    public void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventEmitter.removeListener(listener);
    }

    public void removeAllListeners() {
        this.eventEmitter.removeAllListeners();
    }

    public final void plusAssign(SubscriptionT subscription) {
        this.add(subscription);
    }

    public final void minusAssign(SubscriptionT subscription) {
        this.remove(subscription);
    }

    @Nullable
    public Function1<PNMessageResult, Unit> getOnMessage() {
        return this.emitterHelper.getOnMessage();
    }

    public void setOnMessage(@Nullable Function1<? super PNMessageResult, Unit> function1) {
        this.emitterHelper.setOnMessage(function1);
    }

    private static Object getOnMessage$delegate(BaseSubscriptionSetImpl<Object> baseSubscriptionSetImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)baseSubscriptionSetImpl.emitterHelper, EmitterHelper.class, "onMessage", "getOnMessage()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNPresenceEventResult, Unit> getOnPresence() {
        return this.emitterHelper.getOnPresence();
    }

    public void setOnPresence(@Nullable Function1<? super PNPresenceEventResult, Unit> function1) {
        this.emitterHelper.setOnPresence(function1);
    }

    private static Object getOnPresence$delegate(BaseSubscriptionSetImpl<Object> baseSubscriptionSetImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)baseSubscriptionSetImpl.emitterHelper, EmitterHelper.class, "onPresence", "getOnPresence()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNSignalResult, Unit> getOnSignal() {
        return this.emitterHelper.getOnSignal();
    }

    public void setOnSignal(@Nullable Function1<? super PNSignalResult, Unit> function1) {
        this.emitterHelper.setOnSignal(function1);
    }

    private static Object getOnSignal$delegate(BaseSubscriptionSetImpl<Object> baseSubscriptionSetImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)baseSubscriptionSetImpl.emitterHelper, EmitterHelper.class, "onSignal", "getOnSignal()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNMessageActionResult, Unit> getOnMessageAction() {
        return this.emitterHelper.getOnMessageAction();
    }

    public void setOnMessageAction(@Nullable Function1<? super PNMessageActionResult, Unit> function1) {
        this.emitterHelper.setOnMessageAction(function1);
    }

    private static Object getOnMessageAction$delegate(BaseSubscriptionSetImpl<Object> baseSubscriptionSetImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)baseSubscriptionSetImpl.emitterHelper, EmitterHelper.class, "onMessageAction", "getOnMessageAction()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNObjectEventResult, Unit> getOnObjects() {
        return this.emitterHelper.getOnObjects();
    }

    public void setOnObjects(@Nullable Function1<? super PNObjectEventResult, Unit> function1) {
        this.emitterHelper.setOnObjects(function1);
    }

    private static Object getOnObjects$delegate(BaseSubscriptionSetImpl<Object> baseSubscriptionSetImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)baseSubscriptionSetImpl.emitterHelper, EmitterHelper.class, "onObjects", "getOnObjects()Lkotlin/jvm/functions/Function1;", 0)));
    }

    @Nullable
    public Function1<PNFileEventResult, Unit> getOnFile() {
        return this.emitterHelper.getOnFile();
    }

    public void setOnFile(@Nullable Function1<? super PNFileEventResult, Unit> function1) {
        this.emitterHelper.setOnFile(function1);
    }

    private static Object getOnFile$delegate(BaseSubscriptionSetImpl<Object> baseSubscriptionSetImpl) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)baseSubscriptionSetImpl.emitterHelper, EmitterHelper.class, "onFile", "getOnFile()Lkotlin/jvm/functions/Function1;", 0)));
    }

    public static final /* synthetic */ boolean access$accepts(BaseSubscriptionSetImpl $this, AnnouncementEnvelope envelope) {
        return $this.accepts(envelope);
    }
}

