/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.presence.eventengine.effect;

import com.pubnub.api.logging.LogConfig;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.internal.eventengine.ManagedEffect;
import com.pubnub.internal.eventengine.Sink;
import com.pubnub.internal.extension.ScheduledExecutorServiceKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.presence.eventengine.event.PresenceEvent;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/pubnub/internal/presence/eventengine/effect/WaitEffect;", "Lcom/pubnub/internal/eventengine/ManagedEffect;", "heartbeatInterval", "Lkotlin/time/Duration;", "presenceEventSink", "Lcom/pubnub/internal/eventengine/Sink;", "Lcom/pubnub/internal/presence/eventengine/event/PresenceEvent;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "<init>", "(JLcom/pubnub/internal/eventengine/Sink;Ljava/util/concurrent/ScheduledExecutorService;Lcom/pubnub/api/logging/LogConfig;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "log", "Lcom/pubnub/internal/logging/PNLogger;", "cancelled", "", "scheduled", "Ljava/util/concurrent/ScheduledFuture;", "runEffect", "", "cancel", "pubnub-kotlin-impl"})
public final class WaitEffect
implements ManagedEffect {
    private final long heartbeatInterval;
    @NotNull
    private final Sink<PresenceEvent> presenceEventSink;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final LogConfig logConfig;
    @NotNull
    private final PNLogger log;
    private transient boolean cancelled;
    @Nullable
    private transient ScheduledFuture<?> scheduled;

    private WaitEffect(long heartbeatInterval, Sink<PresenceEvent> presenceEventSink, ScheduledExecutorService executorService, LogConfig logConfig) {
        Intrinsics.checkNotNullParameter(presenceEventSink, (String)"presenceEventSink");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        this.heartbeatInterval = heartbeatInterval;
        this.presenceEventSink = presenceEventSink;
        this.executorService = executorService;
        this.logConfig = logConfig;
        this.log = LoggerManager.Companion.getInstance().getLogger(this.logConfig, this.getClass());
    }

    @Override
    public synchronized void runEffect() {
        this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text("Running WaitEffect."), null, null, null, null, null, null, 126, null));
        if (this.cancelled) {
            return;
        }
        try {
            this.scheduled = ScheduledExecutorServiceKt.scheduleWithDelay-8Mi8wO0(this.executorService, this.heartbeatInterval, (Function0<Unit>)((Function0)() -> WaitEffect.runEffect$lambda$0(this)));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.log.trace(new LogMessage((LogMessageContent)new LogMessageContent.Text("Unable to schedule retry, PubNub was likely already destroyed."), null, null, null, null, null, null, 126, null));
        }
    }

    @Override
    public synchronized void cancel() {
        if (this.cancelled) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.scheduled;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.cancelled = true;
    }

    private static final Unit runEffect$lambda$0(WaitEffect this$0) {
        this$0.presenceEventSink.add(PresenceEvent.TimesUp.INSTANCE);
        return Unit.INSTANCE;
    }

    public /* synthetic */ WaitEffect(long heartbeatInterval, Sink presenceEventSink, ScheduledExecutorService executorService, LogConfig logConfig, DefaultConstructorMarker $constructor_marker) {
        this(heartbeatInterval, presenceEventSink, executorService, logConfig);
    }
}

