/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.logging;

import com.pubnub.api.logging.LogConfig;
import com.pubnub.internal.logging.CompositeLogger;
import com.pubnub.internal.logging.NoOpLogger;
import com.pubnub.internal.logging.PNLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0004J\u001c\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J \u0010\u000e\u001a\u00020\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/internal/logging/LoggerManager;", "", "loggerFactory", "Lkotlin/Function1;", "Ljava/lang/Class;", "Lorg/slf4j/Logger;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getLogger", "Lcom/pubnub/internal/logging/PNLogger;", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "clazz", "createLogger", "createFallbackLogger", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "pubnub-kotlin-impl"})
public final class LoggerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Class<?>, Logger> loggerFactory;
    @NotNull
    private static final LoggerManager instance = new LoggerManager(null, 1, null);

    public LoggerManager(@NotNull Function1<? super Class<?>, ? extends Logger> loggerFactory) {
        Intrinsics.checkNotNullParameter(loggerFactory, (String)"loggerFactory");
        this.loggerFactory = loggerFactory;
    }

    public /* synthetic */ LoggerManager(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = LoggerManager::_init_$lambda$0;
        }
        this(function1);
    }

    @NotNull
    public final PNLogger getLogger(@NotNull LogConfig logConfig, @NotNull Class<?> clazz) {
        PNLogger pNLogger;
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            pNLogger = this.createLogger(logConfig, clazz);
        }
        catch (Exception e) {
            pNLogger = this.createFallbackLogger(clazz, e);
        }
        return pNLogger;
    }

    private final PNLogger createLogger(LogConfig logConfig, Class<?> clazz) {
        Logger slf4jLogger = (Logger)this.loggerFactory.invoke(clazz);
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return new CompositeLogger(slf4jLogger, string, logConfig.getPnInstanceId(), null, logConfig.getCustomLoggers());
    }

    private final PNLogger createFallbackLogger(Class<?> clazz, Exception cause) {
        PNLogger pNLogger;
        try {
            Logger fallbackSlf4jLogger = LoggerFactory.getLogger(clazz);
            fallbackSlf4jLogger.warn("Failed to create portal logger. Using fallback", (Throwable)cause);
            Intrinsics.checkNotNull((Object)fallbackSlf4jLogger);
            String string = clazz.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            pNLogger = new CompositeLogger(fallbackSlf4jLogger, string, "fallback-instance", null, null, 24, null);
        }
        catch (Exception fallbackException) {
            pNLogger = new NoOpLogger(clazz);
        }
        return pNLogger;
    }

    private static final Logger _init_$lambda$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LoggerFactory.getLogger((Class)it);
    }

    public LoggerManager() {
        this(null, 1, null);
    }

    @NotNull
    public static final LoggerManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/pubnub/internal/logging/LoggerManager$Companion;", "", "<init>", "()V", "instance", "Lcom/pubnub/internal/logging/LoggerManager;", "getInstance$annotations", "getInstance", "()Lcom/pubnub/internal/logging/LoggerManager;", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LoggerManager getInstance() {
            return instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

