/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.pubsub;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtil;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.models.server.SubscribeEnvelope;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010(\u001a\u00020)H\u0014J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J2\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-2\"\u0010.\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0/j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`0H\u0014J,\u00101\u001a\u00020)2\"\u0010.\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0/j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`0H\u0002J\u0016\u00102\u001a\u00020\u00022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000204H\u0014J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001e\u00a8\u00069"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/SubscribeEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/SubscribeEnvelope;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;)V", "log", "Lcom/pubnub/internal/logging/PNLogger;", "channels", "", "", "getChannels", "()Ljava/util/List;", "setChannels", "(Ljava/util/List;)V", "channelGroups", "getChannelGroups", "setChannelGroups", "timetoken", "", "getTimetoken", "()Ljava/lang/Long;", "setTimetoken", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "region", "getRegion", "()Ljava/lang/String;", "setRegion", "(Ljava/lang/String;)V", "state", "", "getState", "()Ljava/lang/Object;", "setState", "(Ljava/lang/Object;)V", "filterExpression", "getFilterExpression", "setFilterExpression", "validateParams", "", "getAffectedChannels", "getAffectedChannelGroups", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addQueryParams", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSubscribeOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
public final class SubscribeEndpoint
extends EndpointCore<SubscribeEnvelope, SubscribeEnvelope> {
    @NotNull
    private final PNLogger log;
    @NotNull
    private List<String> channels;
    @NotNull
    private List<String> channelGroups;
    @Nullable
    private Long timetoken;
    @Nullable
    private String region;
    @Nullable
    private Object state;
    @Nullable
    private String filterExpression;

    public SubscribeEndpoint(@NotNull PubNubImpl pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        super(pubnub);
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
        this.channels = CollectionsKt.emptyList();
        this.channelGroups = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    public final void setChannels(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channels = list;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public final void setChannelGroups(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channelGroups = list;
    }

    @Nullable
    public final Long getTimetoken() {
        return this.timetoken;
    }

    public final void setTimetoken(@Nullable Long l) {
        this.timetoken = l;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    public final void setRegion(@Nullable String string) {
        this.region = string;
    }

    @Nullable
    public final Object getState() {
        return this.state;
    }

    public final void setState(@Nullable Object object) {
        this.state = object;
    }

    @Nullable
    public final String getFilterExpression() {
        return this.filterExpression;
    }

    public final void setFilterExpression(@Nullable String string) {
        this.filterExpression = string;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty() && this.channelGroups.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    protected Call<SubscribeEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"channels", this.channels);
        pairArray[1] = TuplesKt.to((Object)"channelGroups", this.channelGroups);
        Long l = this.timetoken;
        pairArray[2] = TuplesKt.to((Object)"timetoken", (Object)(l != null ? l : 0L));
        String string = this.region;
        if (string == null) {
            string = "";
        }
        pairArray[3] = TuplesKt.to((Object)"region", (Object)string);
        Object object = this.state;
        if (object == null) {
            object = "";
        }
        pairArray[4] = TuplesKt.to((Object)"state", (Object)object);
        String string2 = this.filterExpression;
        if (string2 == null) {
            string2 = "";
        }
        pairArray[5] = TuplesKt.to((Object)"filterExpression", (Object)string2);
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "Subscribe API call", null, null, null, null, null, 124, null));
        this.addQueryParams(queryParams);
        return this.getRetrofitManager().getSubscribeService$pubnub_kotlin_impl().subscribe(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams);
    }

    private final void addQueryParams(HashMap<String, String> queryParams) {
        CharSequence charSequence;
        if (!((Collection)this.channelGroups).isEmpty()) {
            ((Map)queryParams).put("channel-group", CollectionsKt.joinToString$default((Iterable)this.channelGroups, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((charSequence = (CharSequence)this.filterExpression) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Map map = queryParams;
            String string = this.filterExpression;
            Intrinsics.checkNotNull((Object)string);
            map.put("filter-expr", string);
        }
        Long l = this.timetoken;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            ((Map)queryParams).put("tt", String.valueOf(it));
        }
        String string = this.region;
        if (string != null) {
            String it = string;
            boolean bl = false;
            ((Map)queryParams).put("tr", it);
        }
        ((Map)queryParams).put("heartbeat", String.valueOf(this.getPubnub().getConfiguration().getPresenceTimeout()));
        Object object = this.state;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            ((Map)queryParams).put("state", this.getPubnub().getMapper().toJson(it));
        }
        PubNubUtil.INSTANCE.maybeAddEeQueryParam$pubnub_kotlin_impl((Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected SubscribeEnvelope createResponse(@NotNull Response<SubscribeEnvelope> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return (SubscribeEnvelope)object;
    }

    @NotNull
    public PNOperationType.PNSubscribeOperation operationType() {
        return PNOperationType.PNSubscribeOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.SUBSCRIBE;
    }
}

