/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.pubsub;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.pubsub.Publish;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.extension.BooleanKt;
import com.pubnub.internal.extension.StringKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\u0018\u0000 ;2\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005:\u0001;Be\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010&\u001a\u00020'H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u0002H\u0014J8\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020*2\"\u0010+\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0,j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`-H\u0014J\u001c\u0010.\u001a\u00020\u00042\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000200H\u0014J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\rH\u0014J\b\u00104\u001a\u000205H\u0014J\u001c\u00106\u001a\u00020'2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n07H\u0002J\u0010\u00108\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u00109\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u0010:\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0002R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0018\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000e\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/PublishEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/PNPublishResult;", "Lcom/pubnub/api/endpoints/pubsub/Publish;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "message", "channel", "", "meta", "shouldStore", "", "usePost", "replicate", "ttl", "", "customMessageType", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Boolean;ZZLjava/lang/Integer;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/Object;", "getChannel", "()Ljava/lang/String;", "getMeta", "getShouldStore", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getUsePost", "()Z", "getReplicate", "getTtl", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getCustomMessageType", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "", "getAffectedChannels", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNPublishOperation;", "isPubKeyRequired", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "addQueryParams", "", "getBodyMessage", "getParamMessage", "toJson", "Companion", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nPublishEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishEndpoint.kt\ncom/pubnub/internal/endpoints/pubsub/PublishEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class PublishEndpoint
extends EndpointCore<List<? extends Object>, PNPublishResult>
implements Publish {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object message;
    @NotNull
    private final String channel;
    @Nullable
    private final Object meta;
    @Nullable
    private final Boolean shouldStore;
    private final boolean usePost;
    private final boolean replicate;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final String customMessageType;
    @NotNull
    private final PNLogger log;
    @NotNull
    public static final String CUSTOM_MESSAGE_TYPE_QUERY_PARAM = "custom_message_type";

    public PublishEndpoint(@NotNull PubNubImpl pubnub, @NotNull Object message, @NotNull String channel, @Nullable Object meta, @Nullable Boolean shouldStore, boolean usePost, boolean replicate, @Nullable Integer ttl, @Nullable String customMessageType) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.message = message;
        this.channel = channel;
        this.meta = meta;
        this.shouldStore = shouldStore;
        this.usePost = usePost;
        this.replicate = replicate;
        this.ttl = ttl;
        this.customMessageType = customMessageType;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    public /* synthetic */ PublishEndpoint(PubNubImpl pubNubImpl, Object object, String string, Object object2, Boolean bl, boolean bl2, boolean bl3, Integer n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            object2 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x80) != 0) {
            n = null;
        }
        if ((n2 & 0x100) != 0) {
            string2 = null;
        }
        this(pubNubImpl, object, string, object2, bl, bl2, bl3, n, string2);
    }

    @NotNull
    public Object getMessage() {
        return this.message;
    }

    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Nullable
    public Object getMeta() {
        return this.meta;
    }

    @Nullable
    public Boolean getShouldStore() {
        return this.shouldStore;
    }

    public boolean getUsePost() {
        return this.usePost;
    }

    public boolean getReplicate() {
        return this.replicate;
    }

    @Nullable
    public Integer getTtl() {
        return this.ttl;
    }

    @Nullable
    public String getCustomMessageType() {
        return this.customMessageType;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) {
        Call<List<Object>> call;
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"message", (Object)this.getMessage());
        pairArray[1] = TuplesKt.to((Object)"channel", (Object)this.getChannel());
        Boolean bl = this.getShouldStore();
        pairArray[2] = TuplesKt.to((Object)"shouldStore", (Object)(bl != null ? bl : true));
        Object object = this.getMeta();
        if (object == null) {
            object = "";
        }
        pairArray[3] = TuplesKt.to((Object)"meta", (Object)object);
        pairArray[4] = TuplesKt.to((Object)"usePost", (Object)this.getUsePost());
        Integer n = this.getTtl();
        pairArray[5] = TuplesKt.to((Object)"ttl", (Object)(n != null ? n : 0));
        pairArray[6] = TuplesKt.to((Object)"replicate", (Object)this.getReplicate());
        String string = this.getCustomMessageType();
        if (string == null) {
            string = "";
        }
        pairArray[7] = TuplesKt.to((Object)"customMessageType", (Object)string);
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "Publish API call", null, null, null, null, null, 124, null));
        this.addQueryParams((Map<String, String>)queryParams);
        if (this.getUsePost()) {
            Object payload = this.getBodyMessage(this.getMessage());
            call = this.getRetrofitManager().getPublishService$pubnub_kotlin_impl().publishWithPost(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.getChannel(), payload, (Map<String, String>)queryParams);
        } else {
            String stringifiedMessage = this.getParamMessage(this.getMessage());
            call = this.getRetrofitManager().getPublishService$pubnub_kotlin_impl().publish(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.getChannel(), stringifiedMessage, (Map<String, String>)queryParams);
        }
        return call;
    }

    @Override
    @NotNull
    protected PNPublishResult createResponse(@NotNull Response<List<Object>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPublishResult(Long.parseLong(((List)object).get(2).toString()));
    }

    @NotNull
    public PNOperationType.PNPublishOperation operationType() {
        return PNOperationType.PNPublishOperation.INSTANCE;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUBLISH;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        Object object = this.getMeta();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            queryParams.put("meta", this.getPubnub().getMapper().toJson(it));
        }
        Boolean bl = this.getShouldStore();
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            queryParams.put("store", BooleanKt.getNumericString(it));
        }
        Integer n = this.getTtl();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            queryParams.put("ttl", String.valueOf(it));
        }
        if (!this.getReplicate()) {
            queryParams.put("norep", BooleanKt.getValueString(true));
        }
        String string = this.getCustomMessageType();
        if (string != null) {
            String it = string;
            boolean bl4 = false;
            queryParams.put(CUSTOM_MESSAGE_TYPE_QUERY_PARAM, it);
        }
        queryParams.put("seqn", String.valueOf(this.getPubnub().getPublishSequenceManager$pubnub_kotlin_impl().nextSequence$pubnub_kotlin_impl()));
    }

    private final Object getBodyMessage(Object message) {
        Object object = this.getPubnub().getCryptoModuleWithLogConfig$pubnub_kotlin_impl();
        if (object == null || (object = CryptoModuleImplKt.encryptString(object, this.toJson(message))) == null) {
            object = message;
        }
        return object;
    }

    private final String getParamMessage(Object message) {
        Object object = this.getPubnub().getCryptoModuleWithLogConfig$pubnub_kotlin_impl();
        if (object == null || (object = CryptoModuleImplKt.encryptString(object, this.toJson(message))) == null || (object = StringKt.quoted((String)object)) == null) {
            object = this.toJson(message);
        }
        return object;
    }

    private final String toJson(Object message) {
        return this.getPubnub().getMapper().toJson(message);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/PublishEndpoint$Companion;", "", "<init>", "()V", "CUSTOM_MESSAGE_TYPE_QUERY_PARAM", "", "pubnub-kotlin-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

