/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.endpoints.presence.HereNow;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.presence.PNHereNowChannelData;
import com.pubnub.api.models.consumer.presence.PNHereNowOccupantData;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.managers.MapperManager;
import com.pubnub.internal.models.server.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B[\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010!\u001a\u00020\rH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J8\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020%2\"\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0'j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`(H\u0014J\u001c\u0010)\u001a\u00020\u00042\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020+H\u0014J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0014J\u0016\u00100\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0010\u00101\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010*\u001a\u00020\u0003H\u0002J\u001c\u00105\u001a\u0002062\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n07H\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u000e\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/pubnub/internal/endpoints/presence/HereNowEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNHereNowResult;", "Lcom/pubnub/api/endpoints/presence/HereNow;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channels", "", "", "channelGroups", "includeState", "", "includeUUIDs", "limit", "", "offset", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/util/List;Ljava/util/List;ZZILjava/lang/Integer;)V", "getChannels", "()Ljava/util/List;", "getChannelGroups", "getIncludeState", "()Z", "getIncludeUUIDs", "getLimit", "()I", "getOffset", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "isGlobalHereNow", "getAffectedChannels", "getAffectedChannelGroups", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNHereNowOperation;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "parseSingleChannelResponse", "parseMultipleChannelResponse", "prepareOccupantData", "", "Lcom/pubnub/api/models/consumer/presence/PNHereNowOccupantData;", "addQueryParams", "", "", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nHereNowEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HereNowEndpoint.kt\ncom/pubnub/internal/endpoints/presence/HereNowEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class HereNowEndpoint
extends EndpointCore<Envelope<JsonElement>, PNHereNowResult>
implements HereNow {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    private final boolean includeState;
    private final boolean includeUUIDs;
    private final int limit;
    @Nullable
    private final Integer offset;
    @NotNull
    private final PNLogger log;

    public HereNowEndpoint(@NotNull PubNubImpl pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, boolean includeState, boolean includeUUIDs, int limit, @Nullable Integer offset) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.includeState = includeState;
        this.includeUUIDs = includeUUIDs;
        this.limit = limit;
        this.offset = offset;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    public /* synthetic */ HereNowEndpoint(PubNubImpl pubNubImpl, List list, List list2, boolean bl, boolean bl2, int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x20) != 0) {
            n = 1000;
        }
        if ((n3 & 0x40) != 0) {
            n2 = null;
        }
        this(pubNubImpl, list, list2, bl, bl2, n, n2);
    }

    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    public boolean getIncludeState() {
        return this.includeState;
    }

    public boolean getIncludeUUIDs() {
        return this.includeUUIDs;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nullable
    public Integer getOffset() {
        return this.offset;
    }

    private final boolean isGlobalHereNow() {
        return this.getChannels().isEmpty() && this.getChannelGroups().isEmpty();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"channels", this.getChannels());
        pairArray[1] = TuplesKt.to((Object)"channelGroups", this.getChannelGroups());
        pairArray[2] = TuplesKt.to((Object)"includeState", (Object)this.getIncludeState());
        pairArray[3] = TuplesKt.to((Object)"includeUUIDs", (Object)this.getIncludeUUIDs());
        pairArray[4] = TuplesKt.to((Object)"limit", (Object)this.getLimit());
        Object object = this.getOffset();
        if (object == null || (object = ((Integer)object).toString()) == null) {
            object = "null";
        }
        pairArray[5] = TuplesKt.to((Object)"offset", (Object)object);
        pairArray[6] = TuplesKt.to((Object)"isGlobalHereNow", (Object)this.isGlobalHereNow());
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "HereNow API call", null, null, null, null, null, 124, null));
        this.addQueryParams((Map<String, String>)queryParams);
        return !this.isGlobalHereNow() ? this.getRetrofitManager().getPresenceService$pubnub_kotlin_impl().hereNow(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), (Map<String, String>)queryParams) : this.getRetrofitManager().getPresenceService$pubnub_kotlin_impl().globalHereNow(this.getConfiguration().getSubscribeKey(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNHereNowResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        PNHereNowResult pNHereNowResult;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (this.isGlobalHereNow() || this.getChannels().size() > 1 || !((Collection)this.getChannelGroups()).isEmpty()) {
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            Object t = ((Envelope)object).getPayload$pubnub_kotlin_impl();
            Intrinsics.checkNotNull(t);
            pNHereNowResult = this.parseMultipleChannelResponse((JsonElement)t);
        } else {
            Object object = input.body();
            Intrinsics.checkNotNull((Object)object);
            pNHereNowResult = this.parseSingleChannelResponse((Envelope)object);
        }
        return pNHereNowResult;
    }

    @NotNull
    public PNOperationType.PNHereNowOperation operationType() {
        return PNOperationType.PNHereNowOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PNHereNowResult parseSingleChannelResponse(Envelope<JsonElement> input) {
        List list;
        if (this.getIncludeUUIDs()) {
            if (input.getUuids$pubnub_kotlin_impl() != null) {
                list = this.prepareOccupantData(input.getUuids$pubnub_kotlin_impl());
            } else {
                if (this.getLimit() != 0) {
                    HereNowEndpoint hereNowEndpoint = this;
                    Intrinsics.checkNotNull((Object)input.getUuids$pubnub_kotlin_impl());
                    throw new KotlinNothingValueException();
                }
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List occupants = list;
        PNHereNowResult pnHereNowResult = new PNHereNowResult(1, input.getOccupancy$pubnub_kotlin_impl(), null, 4, null);
        PNHereNowChannelData pnHereNowChannelData = new PNHereNowChannelData(this.getChannels().get(0), input.getOccupancy$pubnub_kotlin_impl(), occupants);
        pnHereNowResult.getChannels().put(this.getChannels().get(0), pnHereNowChannelData);
        return pnHereNowResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PNHereNowResult parseMultipleChannelResponse(JsonElement input) {
        Iterator<Map.Entry<String, JsonElement>> channels = this.getPubnub().getMapper().getObjectIterator(input, "channels");
        Map channelsMap = new LinkedHashMap();
        while (channels.hasNext()) {
            List list;
            Map.Entry<String, JsonElement> entry = channels.next();
            JsonElement uuidsField = this.getPubnub().getMapper().getField(entry.getValue(), "uuids");
            if (this.getIncludeUUIDs()) {
                JsonElement jsonElement = uuidsField;
                if (jsonElement != null) {
                    list = this.prepareOccupantData(jsonElement);
                } else {
                    if (this.getLimit() != 0) {
                        HereNowEndpoint hereNowEndpoint = this;
                        Intrinsics.checkNotNull((Object)uuidsField);
                        throw new KotlinNothingValueException();
                    }
                    list = CollectionsKt.emptyList();
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List occupants = list;
            String string = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-key>(...)");
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonElement jsonElement = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"<get-value>(...)");
            PNHereNowChannelData pnHereNowChannelData = new PNHereNowChannelData(string, mapperManager.elementToInt(jsonElement, "occupancy"), occupants);
            channelsMap.put(entry.getKey(), pnHereNowChannelData);
        }
        return new PNHereNowResult(this.getPubnub().getMapper().elementToInt(input, "total_channels"), this.getPubnub().getMapper().elementToInt(input, "total_occupancy"), channelsMap);
    }

    private final List<PNHereNowOccupantData> prepareOccupantData(JsonElement input) {
        List occupantsResults = new ArrayList();
        Iterator<JsonElement> it = this.getPubnub().getMapper().getArrayIterator(input);
        while (true) {
            PNHereNowOccupantData pNHereNowOccupantData;
            Iterator<JsonElement> iterator = it;
            Boolean bl = iterator != null ? Boolean.valueOf(iterator.hasNext()) : null;
            Intrinsics.checkNotNull((Object)bl);
            if (!bl.booleanValue()) break;
            JsonElement occupant = it.next();
            if (this.getIncludeState()) {
                String string = this.getPubnub().getMapper().elementToString(occupant, "uuid");
                Intrinsics.checkNotNull((Object)string);
                pNHereNowOccupantData = new PNHereNowOccupantData(string, this.getPubnub().getMapper().getField(occupant, "state"));
            } else {
                String string = this.getPubnub().getMapper().elementToString(occupant);
                Intrinsics.checkNotNull((Object)string);
                pNHereNowOccupantData = new PNHereNowOccupantData(string, null, 2, null);
            }
            occupantsResults.add(pNHereNowOccupantData);
        }
        return occupantsResults;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block3: {
            if (this.getIncludeState()) {
                queryParams.put("state", "1");
            }
            if (!this.getIncludeUUIDs()) {
                queryParams.put("disable_uuids", "1");
            }
            if (!((Collection)this.getChannelGroups()).isEmpty()) {
                queryParams.put("channel-group", PubNubUtilKt.toCsv(this.getChannelGroups()));
            }
            queryParams.put("limit", String.valueOf(this.getLimit()));
            Integer n = this.getOffset();
            if (n == null) break block3;
            int it = ((Number)n).intValue();
            boolean bl = false;
            queryParams.put("offset", String.valueOf(it));
        }
    }
}

