/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.message_actions;

import com.google.gson.JsonObject;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.message_actions.AddMessageAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.message_actions.PNAddMessageActionResult;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.models.server.objects_api.EntityEnvelope;
import com.pubnub.internal.services.MessageActionService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B!\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0014J8\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001aj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u001bH\u0014J\u001c\u0010\u001c\u001a\u00020\u00042\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pubnub/internal/endpoints/message_actions/AddMessageActionEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/objects_api/EntityEnvelope;", "Lcom/pubnub/api/models/consumer/message_actions/PNMessageAction;", "Lcom/pubnub/api/models/consumer/message_actions/PNAddMessageActionResult;", "Lcom/pubnub/api/endpoints/message_actions/AddMessageAction;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channel", "", "messageAction", "<init>", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;Lcom/pubnub/api/models/consumer/message_actions/PNMessageAction;)V", "getChannel", "()Ljava/lang/String;", "getMessageAction", "()Lcom/pubnub/api/models/consumer/message_actions/PNMessageAction;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "", "getAffectedChannels", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAddMessageAction;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "pubnub-kotlin-impl"})
public final class AddMessageActionEndpoint
extends EndpointCore<EntityEnvelope<PNMessageAction>, PNAddMessageActionResult>
implements AddMessageAction {
    @NotNull
    private final String channel;
    @NotNull
    private final PNMessageAction messageAction;
    @NotNull
    private final PNLogger log;

    public AddMessageActionEndpoint(@NotNull PubNubImpl pubnub, @NotNull String channel, @NotNull PNMessageAction messageAction) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)messageAction, (String)"messageAction");
        super(pubnub);
        this.channel = channel;
        this.messageAction = messageAction;
        this.log = LoggerManager.Companion.getInstance().getLogger(pubnub.getLogConfig(), this.getClass());
    }

    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @NotNull
    public PNMessageAction getMessageAction() {
        return this.messageAction;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
        if (StringsKt.isBlank((CharSequence)this.getMessageAction().type)) {
            throw new PubNubException(PubNubError.MESSAGE_ACTION_TYPE_MISSING, null, 2, null);
        }
        if (StringsKt.isBlank((CharSequence)this.getMessageAction().value)) {
            throw new PubNubException(PubNubError.MESSAGE_ACTION_VALUE_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<EntityEnvelope<PNMessageAction>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"channel", (Object)this.getChannel()), TuplesKt.to((Object)"messageActionType", (Object)this.getMessageAction().type), TuplesKt.to((Object)"messageActionValue", (Object)this.getMessageAction().value), TuplesKt.to((Object)"messageTimetoken", (Object)this.getMessageAction().messageTimetoken)};
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "AddMessageAction API call", null, null, null, null, null, 124, null));
        Object object = new JsonObject();
        JsonObject $this$doWork_u24lambda_u240 = object;
        boolean bl = false;
        $this$doWork_u24lambda_u240.addProperty("type", this.getMessageAction().type);
        $this$doWork_u24lambda_u240.addProperty("value", this.getMessageAction().value);
        JsonObject body = object;
        MessageActionService messageActionService = this.getRetrofitManager().getMessageActionService$pubnub_kotlin_impl();
        String string = this.getConfiguration().getSubscribeKey();
        String string2 = this.getChannel();
        object = String.valueOf(this.getMessageAction().messageTimetoken);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return messageActionService.addMessageAction(string, string2, string3, body, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNAddMessageActionResult createResponse(@NotNull Response<EntityEnvelope<PNMessageAction>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object t = ((EntityEnvelope)object).getData();
        Intrinsics.checkNotNull(t);
        return new PNAddMessageActionResult((PNMessageAction)t);
    }

    @NotNull
    public PNOperationType.PNAddMessageAction operationType() {
        return PNOperationType.PNAddMessageAction.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_REACTION;
    }
}

