/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.models.server.files.FileUploadRequestDetails;
import com.pubnub.internal.models.server.files.FormField;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 F2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0003DEFBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0002H\u0014J\u0016\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0014J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\"\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u001cH\u0014J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010!\u001a\u00020\u0002H\u0016J\u001c\u0010\"\u001a\u00020\u00022\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020%0$H\u0016J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0000\u00a2\u0006\u0002\b)J\u0012\u0010*\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0018\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020-2\u0006\u0010(\u001a\u00020'H\u0002J\u0018\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'H\u0002J\u001c\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u00042\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u00106\u001a\u00020\u00042\b\u00104\u001a\u0004\u0018\u00010\u00042\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u00107\u001a\u00020'2\n\u00108\u001a\u000609j\u0002`:2\u0006\u0010(\u001a\u00020'H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0014J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0014J\b\u0010=\u001a\u00020\rH\u0014J\b\u0010>\u001a\u00020\rH\u0014J\b\u0010?\u001a\u00020\rH\u0014J\b\u0010@\u001a\u00020AH\u0014J\b\u0010B\u001a\u00020CH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "fileName", "", "content", "", "key", "Lcom/pubnub/internal/models/server/files/FormField;", "formParams", "", "baseUrl", "isEncrypted", "", "pubNub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Ljava/lang/String;[BLcom/pubnub/internal/models/server/files/FormField;Ljava/util/List;Ljava/lang/String;ZLcom/pubnub/internal/PubNubImpl;)V", "log", "Lcom/pubnub/internal/logging/PNLogger;", "validateParams", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "findContentType", "getMediaType", "Lokhttp3/MediaType;", "contentType", "sync", "async", "callback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "parseS3XmlError", "Lcom/pubnub/api/PubNubException;", "exception", "parseS3XmlError$pubnub_kotlin_impl", "isS3XmlError", "errorMessage", "parseS3XmlErrorResponse", "Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$S3ErrorResponse;", "handleS3ErrorCode", "s3Error", "handleAccessDeniedError", "message", "handleEntityTooLargeError", "", "proposedSize", "maxSizeAllowed", "buildEntityTooLargeMessage", "handleParsingException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getAffectedChannels", "getAffectedChannelGroups", "isAuthRequired", "isSubKeyRequired", "isPubKeyRequired", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "S3ErrorResponse", "Factory", "Companion", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nUploadFileEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Result.kt\ncom/pubnub/api/v2/callbacks/Result\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1563#2:345\n1634#2,3:346\n83#3:349\n84#3:351\n89#3,4:352\n1#4:350\n*S KotlinDebug\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint\n*L\n76#1:345\n76#1:346,3\n167#1:349\n167#1:351\n196#1:352,4\n167#1:350\n*E\n"})
public final class UploadFileEndpoint
extends EndpointCore<Unit, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final byte[] content;
    @NotNull
    private final FormField key;
    @NotNull
    private final List<FormField> formParams;
    @NotNull
    private final String baseUrl;
    private final boolean isEncrypted;
    @NotNull
    private final PNLogger log;
    @NotNull
    private static final MediaType APPLICATION_OCTET_STREAM = MediaType.Companion.get("application/octet-stream");
    @NotNull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    private static final String FILE_PART_MULTIPART = "file";

    public UploadFileEndpoint(@NotNull String fileName, @NotNull byte[] content, @NotNull FormField key, @NotNull List<FormField> formParams, @NotNull String baseUrl, boolean isEncrypted, @NotNull PubNubImpl pubNub) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(formParams, (String)"formParams");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.fileName = fileName;
        this.content = content;
        this.key = key;
        this.formParams = formParams;
        this.baseUrl = baseUrl;
        this.isEncrypted = isEncrypted;
        this.log = LoggerManager.Companion.getInstance().getLogger(this.getPubnub().getLogConfig(), this.getClass());
    }

    public /* synthetic */ UploadFileEndpoint(String string, byte[] byArray, FormField formField, List list, String string2, boolean bl, PubNubImpl pubNubImpl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(string, byArray, formField, list, string2, bl, pubNubImpl);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (StringsKt.isBlank((CharSequence)this.baseUrl)) {
            throw PubNubException.copy$default((PubNubException)new PubNubException(PubNubError.INVALID_ARGUMENTS, null, 2, null), (String)"S3 upload URL cannot be empty", null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
        }
        if (StringsKt.isBlank((CharSequence)this.fileName)) {
            throw PubNubException.copy$default((PubNubException)new PubNubException(PubNubError.INVALID_ARGUMENTS, null, 2, null), (String)"File name cannot be empty", null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
        }
    }

    @Override
    protected void createResponse(@NotNull Response<Unit> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Text("S3 upload successful - fileName: " + this.fileName + ", responseCode: " + input.code() + ", responseMessage: " + input.message()), null, null, null, null, null, null, 126, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Call<Unit> doWork(@NotNull HashMap<String, String> queryParams) {
        List list;
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        String contentType = this.findContentType(this.formParams);
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Text("Initiating S3 upload - fileName: " + this.fileName + ", contentSize: " + this.content.length + " bytes, contentType: " + contentType + ", isEncrypted: " + this.isEncrypted + ", formFieldsCount: " + this.formParams.size()), null, null, null, null, null, null, 126, null));
        if (this.isEncrypted) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.formParams;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void param;
                FormField formField = (FormField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.equals((String)param.getKey(), (String)CONTENT_TYPE_HEADER, (boolean)true) ? new FormField(param.getKey(), "application/octet-stream") : param);
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.formParams;
        }
        List modifiedFormParams = list;
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        UploadFileEndpoint.Companion.addFormParamsWithKeyFirst(this.key, modifiedFormParams, builder);
        MediaType mediaType = this.isEncrypted ? APPLICATION_OCTET_STREAM : this.getMediaType(this.findContentType(modifiedFormParams));
        builder.addFormDataPart(FILE_PART_MULTIPART, this.fileName, RequestBody.Companion.create(this.content, mediaType, 0, this.content.length));
        this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Text("Multipart request built - executing upload to S3 for fileName: " + this.fileName + " with mediaType: " + mediaType), null, null, null, null, null, null, 126, null));
        return this.getRetrofitManager().getS3Service$pubnub_kotlin_impl().upload(this.baseUrl, builder.build());
    }

    private final String findContentType(List<FormField> $this$findContentType) {
        Object v0;
        block1: {
            Iterable iterable = $this$findContentType;
            for (Object t : iterable) {
                FormField formField = (FormField)t;
                boolean bl = false;
                String key = formField.component1();
                if (!StringsKt.equals((String)key, (String)CONTENT_TYPE_HEADER, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        FormField formField = v0;
        return formField != null ? formField.getValue() : null;
    }

    private final MediaType getMediaType(String contentType) {
        MediaType mediaType;
        if (contentType == null) {
            mediaType = APPLICATION_OCTET_STREAM;
        } else {
            MediaType mediaType2;
            try {
                mediaType2 = MediaType.Companion.get(contentType);
            }
            catch (Throwable t) {
                this.log.warn(new LogMessage((LogMessageContent)new LogMessageContent.Text("Content-Type: " + contentType + " was not recognized by MediaType.get: " + t.getMessage()), null, null, null, null, null, null, 126, null));
                mediaType2 = APPLICATION_OCTET_STREAM;
            }
            mediaType = mediaType2;
        }
        return mediaType;
    }

    @Override
    public void sync() throws PubNubException {
        long startTime = System.currentTimeMillis();
        try {
            super.sync();
            long duration = System.currentTimeMillis() - startTime;
            this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Text("Synchronous upload completed successfully - fileName: " + this.fileName + ", duration: " + duration + "ms"), null, null, null, null, null, null, 126, null));
        }
        catch (PubNubException e) {
            long duration = System.currentTimeMillis() - startTime;
            String string = e.getErrorMessage();
            this.log.error(new LogMessage((LogMessageContent)new LogMessageContent.Text("Synchronous upload failed - fileName: " + this.fileName + ", duration: " + duration + "ms, error: " + e.getPubnubError() + ", statusCode: " + e.getStatusCode() + ", message: " + (string != null ? StringsKt.take((String)string, (int)200) : null)), null, null, null, null, null, null, 126, null));
            throw this.parseS3XmlError$pubnub_kotlin_impl(e);
        }
    }

    @Override
    public void async(@NotNull Consumer<Result<Unit>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        long startTime = System.currentTimeMillis();
        super.async(arg_0 -> UploadFileEndpoint.async$lambda$5(startTime, this, callback, arg_0));
    }

    @NotNull
    public final PubNubException parseS3XmlError$pubnub_kotlin_impl(@NotNull PubNubException exception) {
        PubNubException pubNubException;
        Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
        String errorMessage = exception.getErrorMessage();
        if (!this.isS3XmlError(errorMessage)) {
            return exception;
        }
        try {
            String string = errorMessage;
            Intrinsics.checkNotNull((Object)string);
            S3ErrorResponse s3ErrorResponse = this.parseS3XmlErrorResponse(string);
            if (s3ErrorResponse == null) {
                return exception;
            }
            S3ErrorResponse s3Error = s3ErrorResponse;
            pubNubException = this.handleS3ErrorCode(s3Error, exception);
        }
        catch (Exception e) {
            pubNubException = this.handleParsingException(e, exception);
        }
        return pubNubException;
    }

    private final boolean isS3XmlError(String errorMessage) {
        return errorMessage != null && StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)errorMessage)).toString(), (String)"<", (boolean)false, (int)2, null);
    }

    private final S3ErrorResponse parseS3XmlErrorResponse(String errorMessage) {
        S3ErrorResponse s3ErrorResponse;
        try {
            String code;
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbFactory.setXIncludeAware(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            String string = errorMessage;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Document doc = dBuilder.parse(new ByteArrayInputStream(byArray));
            doc.getDocumentElement().normalize();
            Node node = doc.getElementsByTagName("Code").item(0);
            String string2 = code = node != null && (node = node.getFirstChild()) != null ? node.getNodeValue() : null;
            Object object = doc.getElementsByTagName("Message").item(0);
            if (object == null || (object = object.getFirstChild()) == null || (object = object.getNodeValue()) == null) {
                object = errorMessage;
            }
            Object message = object;
            Node node2 = doc.getElementsByTagName("ProposedSize").item(0);
            String proposedSize = node2 != null && (node2 = node2.getFirstChild()) != null ? node2.getNodeValue() : null;
            Node node3 = doc.getElementsByTagName("MaxSizeAllowed").item(0);
            String maxSizeAllowed = node3 != null && (node3 = node3.getFirstChild()) != null ? node3.getNodeValue() : null;
            s3ErrorResponse = new S3ErrorResponse(code, (String)message, proposedSize, maxSizeAllowed);
        }
        catch (Exception e) {
            s3ErrorResponse = null;
        }
        return s3ErrorResponse;
    }

    private final PubNubException handleS3ErrorCode(S3ErrorResponse s3Error, PubNubException exception) {
        PubNubException pubNubException;
        String string = s3Error.getCode();
        if (Intrinsics.areEqual((Object)string, (Object)"AccessDenied")) {
            pubNubException = this.handleAccessDeniedError(s3Error.getMessage(), exception);
        } else {
            if (Intrinsics.areEqual((Object)string, (Object)"EntityTooLarge")) {
                this.handleEntityTooLargeError(s3Error.getProposedSize(), s3Error.getMaxSizeAllowed());
                throw new KotlinNothingValueException();
            }
            pubNubException = PubNubException.copy$default((PubNubException)exception, (String)s3Error.getMessage(), null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
        }
        return pubNubException;
    }

    private final PubNubException handleAccessDeniedError(String message, PubNubException exception) {
        if (StringsKt.contains((CharSequence)message, (CharSequence)"Policy expired", (boolean)true)) {
            throw new PubNubException(PubNubError.UPLOAD_URL_HAS_EXPIRED, null, 2, null);
        }
        return PubNubException.copy$default((PubNubException)exception, (String)message, null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
    }

    private final Void handleEntityTooLargeError(String proposedSize, String maxSizeAllowed) {
        String detailedMessage = this.buildEntityTooLargeMessage(proposedSize, maxSizeAllowed);
        throw PubNubException.copy$default((PubNubException)new PubNubException(PubNubError.FILE_TOO_LARGE, null, 2, null), (String)detailedMessage, null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
    }

    private final String buildEntityTooLargeMessage(String proposedSize, String maxSizeAllowed) {
        return proposedSize != null && maxSizeAllowed != null ? "File size (" + proposedSize + " bytes) exceeds maximum allowed size (" + maxSizeAllowed + " bytes)" : "File size exceeds maximum allowed size";
    }

    private final PubNubException handleParsingException(Exception e, PubNubException exception) {
        if (e instanceof PubNubException) {
            throw e;
        }
        this.log.warn(new LogMessage((LogMessageContent)new LogMessageContent.Text("Failed to parse S3 XML error: " + e.getMessage()), null, null, null, null, null, null, 126, null));
        return exception;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return false;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.FILE_PERSISTENCE;
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.FileOperation.INSTANCE;
    }

    private static final void async$lambda$5$lambda$2(UploadFileEndpoint this$0, long $duration, Consumer $callback, Result $result, PubNubException throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)throwable), (String)"throwable");
        String string = throwable.getErrorMessage();
        this$0.log.error(new LogMessage((LogMessageContent)new LogMessageContent.Text("Asynchronous upload failed - fileName: " + this$0.fileName + ", duration: " + $duration + "ms, error: " + throwable.getPubnubError() + ", statusCode: " + throwable.getStatusCode() + ", message: " + (string != null ? StringsKt.take((String)string, (int)200) : null)), null, null, null, null, null, null, 126, null));
        $callback.accept(Result.Companion.failure(this$0.parseS3XmlError$pubnub_kotlin_impl(throwable)));
    }

    private static final Unit async$lambda$5$lambda$3(UploadFileEndpoint this$0, long $duration, Consumer $callback, Result $result, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Text("Asynchronous upload completed successfully - fileName: " + this$0.fileName + ", duration: " + $duration + "ms"), null, null, null, null, null, null, 126, null));
        $callback.accept($result);
        return Unit.INSTANCE;
    }

    private static final void async$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void async$lambda$5(long $startTime, UploadFileEndpoint this$0, Consumer $callback, Result result) {
        Result this_$iv;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        long duration = System.currentTimeMillis() - $startTime;
        Result result2 = result;
        Consumer<Object> action$iv = arg_0 -> UploadFileEndpoint.async$lambda$5$lambda$2(this$0, duration, $callback, result, arg_0);
        boolean $i$f$onFailure = false;
        PubNubException pubNubException = this_$iv.exceptionOrNull();
        if (pubNubException != null) {
            PubNubException it$iv = pubNubException;
            boolean bl = false;
            action$iv.accept((Object)it$iv);
        }
        this_$iv = result;
        action$iv = arg_0 -> UploadFileEndpoint.async$lambda$5$lambda$4(arg_0 -> UploadFileEndpoint.async$lambda$5$lambda$3(this$0, duration, $callback, result, arg_0), arg_0);
        boolean $i$f$onSuccess = false;
        if (this_$iv.isSuccess()) {
            action$iv.accept((Object)((PubNubException)((Object)this_$iv.getValue())));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Companion;", "", "<init>", "()V", "APPLICATION_OCTET_STREAM", "Lokhttp3/MediaType;", "CONTENT_TYPE_HEADER", "", "FILE_PART_MULTIPART", "addFormParamsWithKeyFirst", "", "keyValue", "Lcom/pubnub/internal/models/server/files/FormField;", "formParams", "", "builder", "Lokhttp3/MultipartBody$Builder;", "pubnub-kotlin-impl"})
    @SourceDebugExtension(value={"SMAP\nUploadFileEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,344:1\n774#2:345\n865#2,2:346\n1869#2,2:348\n*S KotlinDebug\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint$Companion\n*L\n337#1:345\n337#1:346,2\n338#1:348,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void addFormParamsWithKeyFirst(FormField keyValue, List<FormField> formParams, MultipartBody.Builder builder) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            builder.addFormDataPart(keyValue.getKey(), keyValue.getValue());
            Iterable iterable = formParams;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FormField it = (FormField)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getKey(), (Object)keyValue.getKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormField it = (FormField)element$iv;
                boolean bl = false;
                builder.addFormDataPart(it.getKey(), it.getValue());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Factory;", "", "pubNub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;)V", "create", "Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint;", "fileName", "", "content", "", "fileUploadRequestDetails", "Lcom/pubnub/internal/models/server/files/FileUploadRequestDetails;", "isEncrypted", "", "pubnub-kotlin-impl"})
    public static final class Factory {
        @NotNull
        private final PubNubImpl pubNub;

        public Factory(@NotNull PubNubImpl pubNub) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final UploadFileEndpoint create(@NotNull String fileName, @NotNull byte[] content, @NotNull FileUploadRequestDetails fileUploadRequestDetails, boolean isEncrypted) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)fileUploadRequestDetails, (String)"fileUploadRequestDetails");
            return new UploadFileEndpoint(fileName, content, fileUploadRequestDetails.getKeyFormField(), fileUploadRequestDetails.getFormFields(), fileUploadRequestDetails.getUrl(), isEncrypted, this.pubNub);
        }

        public static /* synthetic */ UploadFileEndpoint create$default(Factory factory, String string, byte[] byArray, FileUploadRequestDetails fileUploadRequestDetails, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return factory.create(string, byArray, fileUploadRequestDetails, bl);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$S3ErrorResponse;", "", "code", "", "message", "proposedSize", "maxSizeAllowed", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getMessage", "getProposedSize", "getMaxSizeAllowed", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "pubnub-kotlin-impl"})
    private static final class S3ErrorResponse {
        @Nullable
        private final String code;
        @NotNull
        private final String message;
        @Nullable
        private final String proposedSize;
        @Nullable
        private final String maxSizeAllowed;

        public S3ErrorResponse(@Nullable String code, @NotNull String message, @Nullable String proposedSize, @Nullable String maxSizeAllowed) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.code = code;
            this.message = message;
            this.proposedSize = proposedSize;
            this.maxSizeAllowed = maxSizeAllowed;
        }

        public /* synthetic */ S3ErrorResponse(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @Nullable
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getProposedSize() {
            return this.proposedSize;
        }

        @Nullable
        public final String getMaxSizeAllowed() {
            return this.maxSizeAllowed;
        }

        @Nullable
        public final String component1() {
            return this.code;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final String component3() {
            return this.proposedSize;
        }

        @Nullable
        public final String component4() {
            return this.maxSizeAllowed;
        }

        @NotNull
        public final S3ErrorResponse copy(@Nullable String code, @NotNull String message, @Nullable String proposedSize, @Nullable String maxSizeAllowed) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new S3ErrorResponse(code, message, proposedSize, maxSizeAllowed);
        }

        public static /* synthetic */ S3ErrorResponse copy$default(S3ErrorResponse s3ErrorResponse, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = s3ErrorResponse.code;
            }
            if ((n & 2) != 0) {
                string2 = s3ErrorResponse.message;
            }
            if ((n & 4) != 0) {
                string3 = s3ErrorResponse.proposedSize;
            }
            if ((n & 8) != 0) {
                string4 = s3ErrorResponse.maxSizeAllowed;
            }
            return s3ErrorResponse.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "S3ErrorResponse(code=" + this.code + ", message=" + this.message + ", proposedSize=" + this.proposedSize + ", maxSizeAllowed=" + this.maxSizeAllowed + ')';
        }

        public int hashCode() {
            int result = this.code == null ? 0 : this.code.hashCode();
            result = result * 31 + this.message.hashCode();
            result = result * 31 + (this.proposedSize == null ? 0 : this.proposedSize.hashCode());
            result = result * 31 + (this.maxSizeAllowed == null ? 0 : this.maxSizeAllowed.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof S3ErrorResponse)) {
                return false;
            }
            S3ErrorResponse s3ErrorResponse = (S3ErrorResponse)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)s3ErrorResponse.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)s3ErrorResponse.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proposedSize, (Object)s3ErrorResponse.proposedSize)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.maxSizeAllowed, (Object)s3ErrorResponse.maxSizeAllowed);
        }
    }
}

