/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.extension.BooleanKt;
import com.pubnub.internal.extension.StringKt;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import com.pubnub.internal.models.server.files.FileUploadNotification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005:\u0001.Bc\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J8\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001e2\"\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070 j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`!H\u0014J\u001c\u0010\"\u001a\u00020\u00042\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u0014J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u0014J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000fH\u0014J\b\u0010*\u001a\u00020\u000fH\u0014J\b\u0010+\u001a\u00020\u000fH\u0014J\b\u0010,\u001a\u00020-H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "Lcom/pubnub/api/endpoints/files/PublishFileMessage;", "channel", "", "fileName", "fileId", "message", "meta", "ttl", "", "shouldStore", "", "customMessageType", "pubNub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;Lcom/pubnub/internal/PubNubImpl;)V", "Ljava/lang/Integer;", "Ljava/lang/Boolean;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "pnFile", "Lcom/pubnub/api/models/consumer/files/PNBaseFile;", "validateParams", "", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "input", "Lretrofit2/Response;", "getAffectedChannels", "getAffectedChannelGroups", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "isAuthRequired", "isSubKeyRequired", "isPubKeyRequired", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "Factory", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nPublishFileMessageEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishFileMessageEndpoint.kt\ncom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public class PublishFileMessageEndpoint
extends EndpointCore<List<? extends Object>, PNPublishFileMessageResult>
implements PublishFileMessage {
    @NotNull
    private final String channel;
    @Nullable
    private final Object message;
    @Nullable
    private final Object meta;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final Boolean shouldStore;
    @Nullable
    private final String customMessageType;
    @NotNull
    private final PNLogger log;
    @NotNull
    private final PNBaseFile pnFile;

    public PublishFileMessageEndpoint(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, @Nullable String customMessageType, @NotNull PubNubImpl pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.message = message;
        this.meta = meta;
        this.ttl = ttl;
        this.shouldStore = shouldStore;
        this.customMessageType = customMessageType;
        this.log = LoggerManager.Companion.getInstance().getLogger(this.getPubnub().getLogConfig(), this.getClass());
        this.pnFile = new PNBaseFile(fileId, fileName);
    }

    public /* synthetic */ PublishFileMessageEndpoint(String string, String string2, String string3, Object object, Object object2, Integer n, Boolean bl, String string4, PubNubImpl pubNubImpl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            object = null;
        }
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        if ((n2 & 0x40) != 0) {
            bl = null;
        }
        if ((n2 & 0x80) != 0) {
            string4 = null;
        }
        this(string, string2, string3, object, object2, n, bl, string4, pubNubImpl);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING, null, 2, null);
        }
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Object messageAsString;
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Pair[] pairArray = new Pair[8];
            pairArray[0] = TuplesKt.to((Object)"channel", (Object)this.channel);
            pairArray[1] = TuplesKt.to((Object)"fileName", (Object)this.pnFile.getName());
            pairArray[2] = TuplesKt.to((Object)"fileId", (Object)this.pnFile.getId());
            Object object2 = this.message;
            if (object2 == null) {
                object2 = "";
            }
            pairArray[3] = TuplesKt.to((Object)"message", (Object)object2);
            Object object3 = this.meta;
            if (object3 == null) {
                object3 = "";
            }
            pairArray[4] = TuplesKt.to((Object)"meta", (Object)object3);
            Integer n = this.ttl;
            pairArray[5] = TuplesKt.to((Object)"ttl", (Object)(n != null ? n : 0));
            Boolean bl = this.shouldStore;
            pairArray[6] = TuplesKt.to((Object)"shouldStore", (Object)(bl != null ? bl : true));
            String string = this.customMessageType;
            if (string == null) {
                string = "";
            }
            pairArray[7] = TuplesKt.to((Object)"customMessageType", (Object)string);
            this.log.debug(new LogMessage((LogMessageContent)new LogMessageContent.Object(MapsKt.mapOf((Pair[])pairArray), Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName()), "PublishFileMessage API call", null, null, null, null, null, 124, null));
            String stringifiedMessage = this.getPubnub().getMapper().toJson(new FileUploadNotification(this.message, this.pnFile));
            Object object4 = this.getPubnub().getCryptoModuleWithLogConfig$pubnub_kotlin_impl();
            if (object4 == null || (object4 = CryptoModuleImplKt.encryptString(object4, stringifiedMessage)) == null || (object4 = StringKt.quoted((String)object4)) == null) {
                object4 = stringifiedMessage;
            }
            messageAsString = object4;
            Object object5 = this.meta;
            if (object5 != null) {
                Object it = object5;
                boolean bl2 = false;
                String stringifiedMeta = this.getPubnub().getMapper().toJson(it);
                ((Map)queryParams).put("meta", stringifiedMeta);
            }
            if ((object = this.shouldStore) != null && (object = BooleanKt.getNumericString((Boolean)object)) != null) {
                Object it = object;
                boolean bl3 = false;
                ((Map)queryParams).put("store", it);
            }
            Integer n2 = this.ttl;
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl4 = false;
                ((Map)queryParams).put("ttl", String.valueOf(it));
            }
            String string2 = this.customMessageType;
            if (string2 == null) break block7;
            String it = string2;
            boolean bl5 = false;
            ((Map)queryParams).put("custom_message_type", it);
        }
        return this.getRetrofitManager().getFilesService$pubnub_kotlin_impl().notifyAboutFileUpload(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.channel, (String)messageAsString, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPublishFileMessageResult createResponse(@NotNull Response<List<Object>> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List list = (List)input.body();
        if (list == null) {
            throw new PubNubException(PubNubError.INTERNAL_ERROR, null, 2, null);
        }
        List body = list;
        boolean bl = false;
        long timetoken = Long.parseLong(body.get(2).toString());
        return new PNPublishFileMessageResult(timetoken);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUBLISH;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Je\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint$Factory;", "", "pubNub", "Lcom/pubnub/internal/PubNubImpl;", "<init>", "(Lcom/pubnub/internal/PubNubImpl;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "channel", "", "fileName", "fileId", "message", "meta", "ttl", "", "shouldStore", "", "customMessageType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;)Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "pubnub-kotlin-impl"})
    public static final class Factory {
        @NotNull
        private final PubNubImpl pubNub;

        public Factory(@NotNull PubNubImpl pubNub) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final ExtendedRemoteAction<PNPublishFileMessageResult> create(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, @Nullable String customMessageType) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            return (ExtendedRemoteAction)new PublishFileMessageEndpoint(channel, fileName, fileId, message, meta, ttl, shouldStore, customMessageType, this.pubNub);
        }

        public static /* synthetic */ ExtendedRemoteAction create$default(Factory factory, String string, String string2, String string3, Object object, Object object2, Integer n, Boolean bl, String string4, int n2, Object object3) {
            if ((n2 & 8) != 0) {
                object = null;
            }
            if ((n2 & 0x10) != 0) {
                object2 = null;
            }
            if ((n2 & 0x20) != 0) {
                n = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = null;
            }
            if ((n2 & 0x80) != 0) {
                string4 = null;
            }
            return factory.create(string, string2, string3, object, object2, n, bl, string4);
        }
    }
}

