/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.crypto;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.cryptor.Cryptor;
import com.pubnub.api.crypto.data.EncryptedData;
import com.pubnub.api.crypto.data.EncryptedStreamData;
import com.pubnub.api.logging.LogConfig;
import com.pubnub.api.logging.LogMessage;
import com.pubnub.api.logging.LogMessageContent;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.crypto.cryptor.HeaderParser;
import com.pubnub.internal.crypto.cryptor.LegacyCryptorKt;
import com.pubnub.internal.crypto.cryptor.ParseResult;
import com.pubnub.internal.logging.LoggerManager;
import com.pubnub.internal.logging.PNLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0018\u0010(\u001a\u00020\u00192\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/pubnub/internal/crypto/CryptoModuleImpl;", "Lcom/pubnub/api/crypto/CryptoModule;", "primaryCryptor", "Lcom/pubnub/api/crypto/cryptor/Cryptor;", "cryptorsForDecryptionOnly", "", "logConfig", "Lcom/pubnub/api/logging/LogConfig;", "<init>", "(Lcom/pubnub/api/crypto/cryptor/Cryptor;Ljava/util/List;Lcom/pubnub/api/logging/LogConfig;)V", "getPrimaryCryptor", "()Lcom/pubnub/api/crypto/cryptor/Cryptor;", "getCryptorsForDecryptionOnly", "()Ljava/util/List;", "getLogConfig", "()Lcom/pubnub/api/logging/LogConfig;", "log", "Lcom/pubnub/internal/logging/PNLogger;", "getLog", "()Lcom/pubnub/internal/logging/PNLogger;", "log$delegate", "Lkotlin/Lazy;", "headerParser", "Lcom/pubnub/internal/crypto/cryptor/HeaderParser;", "encrypt", "", "data", "decrypt", "encryptedData", "encryptStream", "Ljava/io/InputStream;", "stream", "decryptStream", "logTraceMessage", "", "message", "", "validateCryptorIdSize", "cryptorId", "getDecryptedDataForLegacyCryptor", "getDecryptedDataForCryptorWithHeader", "parsedHeader", "Lcom/pubnub/internal/crypto/cryptor/ParseResult$Success;", "getCryptorById", "validateData", "validateStreamAndReturnBuffered", "Ljava/io/BufferedInputStream;", "pubnub-kotlin-impl"})
@SourceDebugExtension(value={"SMAP\nCryptoModuleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CryptoModuleImpl.kt\ncom/pubnub/internal/crypto/CryptoModuleImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n295#2,2:231\n230#2,2:233\n295#2,2:235\n1#3:237\n*S KotlinDebug\n*F\n+ 1 CryptoModuleImpl.kt\ncom/pubnub/internal/crypto/CryptoModuleImpl\n*L\n100#1:231,2\n109#1:233,2\n156#1:235,2\n*E\n"})
public final class CryptoModuleImpl
implements CryptoModule {
    @NotNull
    private final Cryptor primaryCryptor;
    @NotNull
    private final List<Cryptor> cryptorsForDecryptionOnly;
    @Nullable
    private final LogConfig logConfig;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final HeaderParser headerParser;

    public CryptoModuleImpl(@NotNull Cryptor primaryCryptor, @NotNull List<? extends Cryptor> cryptorsForDecryptionOnly, @Nullable LogConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)primaryCryptor, (String)"primaryCryptor");
        Intrinsics.checkNotNullParameter(cryptorsForDecryptionOnly, (String)"cryptorsForDecryptionOnly");
        this.primaryCryptor = primaryCryptor;
        this.cryptorsForDecryptionOnly = cryptorsForDecryptionOnly;
        this.logConfig = logConfig;
        this.log$delegate = LazyKt.lazy(() -> CryptoModuleImpl.log_delegate$lambda$1(this));
        this.headerParser = new HeaderParser(this.logConfig);
    }

    public /* synthetic */ CryptoModuleImpl(Cryptor cryptor, List list, LogConfig logConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            logConfig = null;
        }
        this(cryptor, list, logConfig);
    }

    public final /* synthetic */ Cryptor getPrimaryCryptor() {
        return this.primaryCryptor;
    }

    public final /* synthetic */ List getCryptorsForDecryptionOnly() {
        return this.cryptorsForDecryptionOnly;
    }

    public final /* synthetic */ LogConfig getLogConfig() {
        return this.logConfig;
    }

    private final PNLogger getLog() {
        Lazy lazy = this.log$delegate;
        return (PNLogger)lazy.getValue();
    }

    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.logTraceMessage("Encrypting data of size: " + data.length + " bytes");
        byte[] cryptorId = this.primaryCryptor.id();
        this.validateData(data);
        this.validateCryptorIdSize(cryptorId);
        EncryptedData encryptedData = this.primaryCryptor.encrypt(data);
        byte[] metadata = encryptedData.component1();
        byte[] encryptedData2 = encryptedData.component2();
        if (Arrays.equals(cryptorId, LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) {
            byArray = encryptedData2;
        } else {
            byte[] cryptorHeader = this.headerParser.createCryptorHeader(cryptorId, metadata);
            byArray = ArraysKt.plus((byte[])cryptorHeader, (byte[])encryptedData2);
        }
        byte[] result = byArray;
        this.logTraceMessage("Encrypting successful");
        return result;
    }

    @NotNull
    public byte[] decrypt(@NotNull byte[] encryptedData) {
        byte[] byArray;
        ParseResult<? extends byte[]> parsedData;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.logTraceMessage("Decrypting data of size: " + encryptedData.length + " bytes");
        this.validateData(encryptedData);
        ParseResult<? extends byte[]> parseResult = parsedData = this.headerParser.parseDataWithHeader(encryptedData);
        if (parseResult instanceof ParseResult.NoHeader) {
            this.logTraceMessage("Using legacy cryptor for decryption");
            byArray = this.getDecryptedDataForLegacyCryptor(encryptedData);
        } else if (parseResult instanceof ParseResult.Success) {
            this.logTraceMessage("Using cryptor with header for decryption");
            byArray = this.getDecryptedDataForCryptorWithHeader((ParseResult.Success)parsedData);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] decryptedData = byArray;
        this.logTraceMessage("Decryption successful");
        return decryptedData;
    }

    @NotNull
    public InputStream encryptStream(@NotNull InputStream stream) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.logTraceMessage("Encrypting stream");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(stream);
        EncryptedStreamData encryptedStreamData = this.primaryCryptor.encryptStream((InputStream)bufferedInputStream);
        byte[] metadata = encryptedStreamData.component1();
        InputStream encryptedData = encryptedStreamData.component2();
        this.logTraceMessage("Encrypting stream successful");
        if (Arrays.equals(this.primaryCryptor.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) {
            inputStream = encryptedData;
        } else {
            byte[] cryptorHeader = this.headerParser.createCryptorHeader(this.primaryCryptor.id(), metadata);
            inputStream = new SequenceInputStream(new ByteArrayInputStream(cryptorHeader), encryptedData);
        }
        return inputStream;
    }

    @NotNull
    public InputStream decryptStream(@NotNull InputStream encryptedData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        this.logTraceMessage("Decrypting stream");
        BufferedInputStream bufferedInputStream = this.validateStreamAndReturnBuffered(encryptedData);
        ParseResult<? extends InputStream> parsedHeader = this.headerParser.parseDataWithHeader(bufferedInputStream);
        if (Intrinsics.areEqual(parsedHeader, (Object)ParseResult.NoHeader.INSTANCE)) {
            Cryptor decryptor;
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = this.cryptorsForDecryptionOnly;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Cryptor it = (Cryptor)element$iv;
                    boolean bl = false;
                    if (!Arrays.equals(it.id(), LegacyCryptorKt.getLEGACY_CRYPTOR_ID())) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            if ((object = (decryptor = (Cryptor)v0)) == null || (object = object.decryptStream(new EncryptedStreamData(null, (InputStream)bufferedInputStream, 1, null))) == null) {
                throw new PubNubException("LegacyCryptor not registered", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
            }
        } else if (parsedHeader instanceof ParseResult.Success) {
            Object element$iv2;
            block8: {
                Iterable $this$first$iv = this.cryptorsForDecryptionOnly;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Cryptor it = (Cryptor)element$iv2;
                    boolean bl = false;
                    if (!Arrays.equals(it.id(), ((ParseResult.Success)parsedHeader).getCryptoId())) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Cryptor decryptor = (Cryptor)element$iv2;
            object = decryptor.decryptStream(new EncryptedStreamData(((ParseResult.Success)parsedHeader).getCryptorData(), (InputStream)((ParseResult.Success)parsedHeader).getEncryptedData()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final void logTraceMessage(String message) {
        this.getLog().trace(new LogMessage((LogMessageContent)new LogMessageContent.Text(message), null, null, null, null, null, null, 126, null));
    }

    private final void validateCryptorIdSize(byte[] cryptorId) {
        if (cryptorId.length != 4) {
            throw new PubNubException("CryptorId should be exactly 4 bytes long", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final byte[] getDecryptedDataForLegacyCryptor(byte[] encryptedData) {
        Object object;
        block3: {
            block2: {
                object = this.getCryptorById(LegacyCryptorKt.getLEGACY_CRYPTOR_ID());
                if (object == null) break block2;
                byte[] byArray = object.decrypt(new EncryptedData(null, encryptedData, 1, null));
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new PubNubException("LegacyCryptor not available", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        return object;
    }

    private final byte[] getDecryptedDataForCryptorWithHeader(ParseResult.Success<? extends byte[]> parsedHeader) {
        Object object;
        Object decryptedData;
        block3: {
            block2: {
                decryptedData = null;
                byte[] cryptorId = parsedHeader.getCryptoId();
                byte[] cryptorData = parsedHeader.getCryptorData();
                byte[] pureEncryptedData = parsedHeader.getEncryptedData();
                Cryptor cryptor = this.getCryptorById(cryptorId);
                object = cryptor;
                if (object == null) break block2;
                byte[] byArray = object.decrypt(new EncryptedData(cryptorData, pureEncryptedData));
                object = byArray;
                if (byArray != null) break block3;
            }
            throw new PubNubException("No cryptor found", PubNubError.UNKNOWN_CRYPTOR, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
        decryptedData = object;
        return decryptedData;
    }

    private final Cryptor getCryptorById(byte[] cryptorId) {
        Object v0;
        block1: {
            this.validateCryptorIdSize(cryptorId);
            Iterable $this$firstOrNull$iv = this.cryptorsForDecryptionOnly;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Cryptor it = (Cryptor)element$iv;
                boolean bl = false;
                if (!Arrays.equals(it.id(), cryptorId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void validateData(byte[] data) {
        if (data.length == 0) {
            throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
        }
    }

    private final BufferedInputStream validateStreamAndReturnBuffered(InputStream stream) {
        InputStream inputStream = stream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        CryptoModuleImplKt.checkMinSize(bufferedInputStream, 1, (Function1<? super Integer, Unit>)((Function1)CryptoModuleImpl::validateStreamAndReturnBuffered$lambda$5));
        return bufferedInputStream;
    }

    private static final PNLogger log_delegate$lambda$1(CryptoModuleImpl this$0) {
        Object object;
        block3: {
            block2: {
                object = this$0.logConfig;
                if (object == null) break block2;
                LogConfig it = object;
                boolean bl = false;
                PNLogger pNLogger = LoggerManager.Companion.getInstance().getLogger(it, this$0.getClass());
                object = pNLogger;
                if (pNLogger != null) break block3;
            }
            object = LoggerManager.Companion.getInstance().getLogger(new LogConfig("default", "default", null, 4, null), this$0.getClass());
        }
        return object;
    }

    private static final Unit validateStreamAndReturnBuffered$lambda$5(int it) {
        throw new PubNubException("Encryption/Decryption of empty data not allowed.", PubNubError.ENCRYPTION_AND_DECRYPTION_OF_EMPTY_DATA_NOT_ALLOWED, null, 0, null, null, null, null, null, null, null, 2044, null);
    }
}

