/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/pubnub/api/utils/TimetokenUtil;", "", "<init>", "()V", "Companion", "pubnub-kotlin-api"})
public final class TimetokenUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long MINIMAL_TIMETOKE_VALUE = 10000000000000000L;
    private static final long MAXIMUM_TIMETOKEN_VALUE = 99999999999999999L;
    private static final long MINIMAL_UNIX_TIME_VALUE = 1000000000000L;
    private static final long MAXIMUM_UNIX_TIME_VALUE = 9999999999999L;
    private static final int UNIX_TIME_LENGHT_WHEN_IN_MILLISECONDS = 13;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00052\n\u0010\u0011\u001a\u00060\fj\u0002`\r\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pubnub/api/utils/TimetokenUtil$Companion;", "", "<init>", "()V", "MINIMAL_TIMETOKE_VALUE", "", "MAXIMUM_TIMETOKEN_VALUE", "MINIMAL_UNIX_TIME_VALUE", "MAXIMUM_UNIX_TIME_VALUE", "UNIX_TIME_LENGHT_WHEN_IN_MILLISECONDS", "", "timetokenToInstant", "Lkotlinx/datetime/Instant;", "Lcom/pubnub/api/utils/Instant;", "timetoken", "(J)Lkotlinx/datetime/Instant;", "instantToTimetoken", "instant", "(Lkotlinx/datetime/Instant;)J", "unixToTimetoken", "unixTime", "timetokenToUnix", "isLengthDifferentThan17Digits", "", "isLengthDifferentThan13Digits", "pubnub-kotlin-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Instant timetokenToInstant(long timetoken) {
            if (this.isLengthDifferentThan17Digits(timetoken)) {
                throw new IllegalArgumentException("Timetoken should have 17 digits");
            }
            long epochSeconds = timetoken / (long)10000000;
            int epochNanoseconds = (int)(timetoken % (long)10000000 * (long)100);
            return Instant.Companion.fromEpochSeconds(epochSeconds, epochNanoseconds);
        }

        public final long instantToTimetoken(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            long epochSeconds = instant.getEpochSeconds();
            int epochNanoseconds = instant.getNanosecondsOfSecond();
            long pnTimetokenInNanosecondsWithoutNanoPrecision = epochSeconds * (long)10000000;
            int nanosecondsForPubNubTimetoken = epochNanoseconds / 100;
            return pnTimetokenInNanosecondsWithoutNanoPrecision + (long)nanosecondsForPubNubTimetoken;
        }

        public final long unixToTimetoken(long unixTime) {
            if (this.isLengthDifferentThan13Digits(unixTime)) {
                throw new IllegalArgumentException("Unix timetoken should have 13 digits.");
            }
            return unixTime * (long)10000;
        }

        public final long timetokenToUnix(long timetoken) {
            if (this.isLengthDifferentThan17Digits(timetoken)) {
                throw new IllegalArgumentException("Timetoken should have 17 digits");
            }
            return timetoken / (long)10000;
        }

        private final boolean isLengthDifferentThan17Digits(long timetoken) {
            return !(10000000000000000L <= timetoken ? timetoken < 100000000000000000L : false);
        }

        private final boolean isLengthDifferentThan13Digits(long unixTime) {
            return !(1000000000000L <= unixTime ? unixTime < 10000000000000L : false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

