/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.workers;

import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.objects_api.channel.PNChannelMetadataResult;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembershipResult;
import com.pubnub.api.models.consumer.objects_api.uuid.PNUUIDMetadataResult;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.workers.SubscribeMessageProcessor;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeMessageWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SubscribeMessageWorker.class);
    private final ListenerManager listenerManager;
    private final LinkedBlockingQueue<SubscribeMessage> queue;
    private final SubscribeMessageProcessor subscribeMessageProcessor;

    @Override
    public void run() {
        this.takeMessage();
    }

    private void takeMessage() {
        while (!Thread.interrupted()) {
            try {
                PNEvent event = this.subscribeMessageProcessor.processIncomingPayload(this.queue.take());
                if (event instanceof PNMessageResult) {
                    this.listenerManager.announce((PNMessageResult)event);
                    continue;
                }
                if (event instanceof PNPresenceEventResult) {
                    this.listenerManager.announce((PNPresenceEventResult)event);
                    continue;
                }
                if (event instanceof PNSignalResult) {
                    this.listenerManager.announce((PNSignalResult)event);
                    continue;
                }
                if (event instanceof PNMessageActionResult) {
                    this.listenerManager.announce((PNMessageActionResult)event);
                    continue;
                }
                if (event instanceof PNUUIDMetadataResult) {
                    this.listenerManager.announce((PNUUIDMetadataResult)event);
                    continue;
                }
                if (event instanceof PNChannelMetadataResult) {
                    this.listenerManager.announce((PNChannelMetadataResult)event);
                    continue;
                }
                if (event instanceof PNMembershipResult) {
                    this.listenerManager.announce((PNMembershipResult)event);
                    continue;
                }
                if (!(event instanceof PNFileEventResult)) continue;
                this.listenerManager.announce((PNFileEventResult)event);
            }
            catch (PubNubException e) {
                PNStatus pnStatus = PNStatus.builder().error(true).errorData(new PNErrorData(e.getMessage(), e)).operation(PNOperationType.PNSubscribeOperation).category(PNStatusCategory.PNDecryptionErrorCategory).build();
                this.listenerManager.announce(pnStatus);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.trace("take message interrupted", (Throwable)e);
            }
        }
    }

    public SubscribeMessageWorker(ListenerManager listenerManager, LinkedBlockingQueue<SubscribeMessage> queue, SubscribeMessageProcessor subscribeMessageProcessor) {
        this.listenerManager = listenerManager;
        this.queue = queue;
        this.subscribeMessageProcessor = subscribeMessageProcessor;
    }
}

