/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.vendor;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.vendor.Crypto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class FileEncryptionUtil {
    private static final int IV_SIZE_BYTES = 16;
    public static final int BUFFER_SIZE_BYTES = 8192;
    static final String ENCODING_UTF_8 = "UTF-8";
    static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";

    private FileEncryptionUtil() {
    }

    public static String effectiveCipherKey(PubNub pubNub, String cipherKey) {
        if (cipherKey != null) {
            return cipherKey;
        }
        if (pubNub.getConfiguration().getCipherKey() != null) {
            return pubNub.getConfiguration().getCipherKey();
        }
        return null;
    }

    public static byte[] encryptToBytes(String cipherKey, byte[] bytesToEncrypt) throws PubNubException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] keyBytes = FileEncryptionUtil.keyBytes(cipherKey);
            byte[] randomIvBytes = FileEncryptionUtil.randomIv();
            Cipher encryptionCipher = FileEncryptionUtil.encryptionCipher(keyBytes, randomIvBytes);
            byteArrayOutputStream.write(randomIvBytes);
            byteArrayOutputStream.write(encryptionCipher.doFinal(bytesToEncrypt));
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw PubNubException.builder().errormsg(e.toString()).build();
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    public static InputStream encrypt(String cipherKey, InputStream inputStreamToEncrypt) throws PubNubException {
        try {
            return new ByteArrayInputStream(FileEncryptionUtil.encryptToBytes(cipherKey, PubNubUtil.readBytes(inputStreamToEncrypt)));
        }
        catch (IOException e) {
            throw PubNubException.builder().errormsg(e.getMessage()).cause(e).build();
        }
    }

    public static InputStream decrypt(String cipherKey, InputStream encryptedInputStream) throws PubNubException {
        try {
            byte[] keyBytes = FileEncryptionUtil.keyBytes(cipherKey);
            IvAndData ivAndData = FileEncryptionUtil.loadIvAndDataFromInputStream(encryptedInputStream);
            Cipher decryptionCipher = FileEncryptionUtil.decryptionCipher(keyBytes, ivAndData.ivBytes);
            byte[] decryptedBytes = decryptionCipher.doFinal(ivAndData.dataToDecrypt);
            return new ByteArrayInputStream(decryptedBytes);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw PubNubException.builder().errormsg(e.toString()).cause(e).build();
        }
    }

    private static IvAndData loadIvAndDataFromInputStream(InputStream inputStreamToEncrypt) throws IOException {
        int read;
        byte[] ivBytes = new byte[16];
        int readSoFar = 0;
        do {
            if ((read = inputStreamToEncrypt.read(ivBytes, readSoFar, 16 - readSoFar)) == -1) continue;
            readSoFar += read;
        } while (read != -1 && readSoFar < 16);
        if (read == -1) {
            throw new IOException("EOF before IV fully read");
        }
        return new IvAndData(ivBytes, PubNubUtil.readBytes(inputStreamToEncrypt));
    }

    private static Cipher encryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return FileEncryptionUtil.cipher(keyBytes, ivBytes, 1);
    }

    private static Cipher decryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return FileEncryptionUtil.cipher(keyBytes, ivBytes, 2);
    }

    private static Cipher cipher(byte[] keyBytes, byte[] ivBytes, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        cipher.init(mode, (Key)key, iv);
        return cipher;
    }

    private static byte[] keyBytes(String cipherKey) throws UnsupportedEncodingException, PubNubException {
        return new String(Crypto.hexEncode(Crypto.sha256(cipherKey.getBytes(ENCODING_UTF_8))), ENCODING_UTF_8).substring(0, 32).toLowerCase().getBytes(ENCODING_UTF_8);
    }

    private static byte[] randomIv() throws NoSuchAlgorithmException {
        byte[] randomIv = new byte[16];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(randomIv);
        return randomIv;
    }

    private static class IvAndData {
        final byte[] ivBytes;
        final byte[] dataToDecrypt;

        public IvAndData(byte[] ivBytes, byte[] dataToDecrypt) {
            this.ivBytes = ivBytes;
            this.dataToDecrypt = dataToDecrypt;
        }

        public byte[] getIvBytes() {
            return this.ivBytes;
        }

        public byte[] getDataToDecrypt() {
            return this.dataToDecrypt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IvAndData)) {
                return false;
            }
            IvAndData other = (IvAndData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getIvBytes(), other.getIvBytes())) {
                return false;
            }
            return Arrays.equals(this.getDataToDecrypt(), other.getDataToDecrypt());
        }

        protected boolean canEqual(Object other) {
            return other instanceof IvAndData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getIvBytes());
            result = result * 59 + Arrays.hashCode(this.getDataToDecrypt());
            return result;
        }

        public String toString() {
            return "FileEncryptionUtil.IvAndData(ivBytes=" + Arrays.toString(this.getIvBytes()) + ", dataToDecrypt=" + Arrays.toString(this.getDataToDecrypt()) + ")";
        }
    }
}

