/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.consumer.push.payload;

import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.models.consumer.push.payload.PushPayloadSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushPayloadHelper {
    private Map<String, Object> commonPayload;
    private FCMPayload fcmPayload;
    private MPNSPayload mpnsPayload;
    private APNSPayload apnsPayload;

    public Map<String, Object> build() {
        Map<String, Object> mpnsMap;
        Map<String, Object> fcmMap;
        Map<String, Object> apnsMap;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (this.apnsPayload != null && !(apnsMap = this.apnsPayload.toMap()).isEmpty()) {
            payload.put("pn_apns", apnsMap);
        }
        if (this.fcmPayload != null && !(fcmMap = this.fcmPayload.toMap()).isEmpty()) {
            payload.put("pn_gcm", fcmMap);
        }
        if (this.mpnsPayload != null && !(mpnsMap = this.mpnsPayload.toMap()).isEmpty()) {
            payload.put("pn_mpns", mpnsMap);
        }
        payload.putAll(PushPayloadHelper.filterNonNullEntries(this.commonPayload));
        return payload;
    }

    private static Map<String, Object> filterNonNullEntries(Map<String, Object> targetMap) {
        if (targetMap == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : targetMap.entrySet()) {
            if (entry.getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public PushPayloadHelper setCommonPayload(Map<String, Object> commonPayload) {
        this.commonPayload = commonPayload;
        return this;
    }

    public PushPayloadHelper setFcmPayload(FCMPayload fcmPayload) {
        this.fcmPayload = fcmPayload;
        return this;
    }

    public PushPayloadHelper setMpnsPayload(MPNSPayload mpnsPayload) {
        this.mpnsPayload = mpnsPayload;
        return this;
    }

    public PushPayloadHelper setApnsPayload(APNSPayload apnsPayload) {
        this.apnsPayload = apnsPayload;
        return this;
    }

    public static class FCMPayload
    implements PushPayloadSerializer {
        private Map<String, Object> custom;
        private Map<String, Object> data;
        private Notification notification;

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> notificationMap;
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.notification != null && (notificationMap = this.notification.toMap()) != null && !notificationMap.isEmpty()) {
                map.put("notification", this.notification.toMap());
            }
            if (this.data != null && !this.data.isEmpty()) {
                map.put("data", this.data);
            }
            map.putAll(PushPayloadHelper.filterNonNullEntries(this.custom));
            return map;
        }

        public FCMPayload setCustom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        public FCMPayload setData(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public FCMPayload setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public static class Notification
        implements PushPayloadSerializer {
            private Map<String, Object> parametersMap = new HashMap<String, Object>();

            public Notification set(String parameterName, Object parameterValue) {
                this.parametersMap.put(parameterName, parameterValue);
                return this;
            }

            public Notification setTitle(String title) {
                this.set("title", title);
                return this;
            }

            public Notification setBody(String body) {
                this.set("body", body);
                return this;
            }

            public Notification setImage(String image) {
                this.set("image", image);
                return this;
            }

            public Notification setClickAction(String clickAction) {
                this.set("click_action", clickAction);
                return this;
            }

            @Override
            public Map<String, Object> toMap() {
                return PushPayloadHelper.filterNonNullEntries(this.parametersMap);
            }

            public Notification setParametersMap(Map<String, Object> parametersMap) {
                this.parametersMap = parametersMap;
                return this;
            }
        }
    }

    public static class MPNSPayload
    implements PushPayloadSerializer {
        private Integer count;
        private String backTitle;
        private String title;
        private String backContent;
        private String type;
        private Map<String, Object> custom;

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.count != null) {
                map.put("count", this.count);
            }
            if (this.backTitle != null) {
                map.put("back_title", this.backTitle);
            }
            if (this.title != null) {
                map.put("title", this.title);
            }
            if (this.backContent != null) {
                map.put("back_content", this.backContent);
            }
            if (this.type != null) {
                map.put("type", this.type);
            }
            map.putAll(PushPayloadHelper.filterNonNullEntries(this.custom));
            return map;
        }

        public MPNSPayload setCount(Integer count) {
            this.count = count;
            return this;
        }

        public MPNSPayload setBackTitle(String backTitle) {
            this.backTitle = backTitle;
            return this;
        }

        public MPNSPayload setTitle(String title) {
            this.title = title;
            return this;
        }

        public MPNSPayload setBackContent(String backContent) {
            this.backContent = backContent;
            return this;
        }

        public MPNSPayload setType(String type) {
            this.type = type;
            return this;
        }

        public MPNSPayload setCustom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }
    }

    public static class APNSPayload
    implements PushPayloadSerializer {
        private APS aps;
        private List<APNS2Configuration> apns2Configurations;
        private Map<String, Object> custom;

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> apsMap;
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.aps != null && (apsMap = this.aps.toMap()) != null && !apsMap.isEmpty()) {
                map.put("aps", apsMap);
            }
            if (this.apns2Configurations != null) {
                ArrayList<Map<String, Object>> pnPushArray = new ArrayList<Map<String, Object>>();
                for (APNS2Configuration configuration : this.apns2Configurations) {
                    Map<String, Object> pushItemMap = configuration.toMap();
                    if (pushItemMap == null || pushItemMap.isEmpty()) continue;
                    pnPushArray.add(pushItemMap);
                }
                map.put("pn_push", pnPushArray);
            }
            map.putAll(PushPayloadHelper.filterNonNullEntries(this.custom));
            return map;
        }

        public APNSPayload setAps(APS aps) {
            this.aps = aps;
            return this;
        }

        public APNSPayload setApns2Configurations(List<APNS2Configuration> apns2Configurations) {
            this.apns2Configurations = apns2Configurations;
            return this;
        }

        public APNSPayload setCustom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        public static class APNS2Configuration
        implements PushPayloadSerializer {
            private String collapseId;
            private String expiration;
            private List<Target> targets;
            private String version;

            @Override
            public Map<String, Object> toMap() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (this.collapseId != null) {
                    map.put("collapse_id", this.collapseId);
                }
                if (this.expiration != null) {
                    map.put("expiration", this.expiration);
                }
                if (this.targets != null && !this.targets.isEmpty()) {
                    ArrayList<Map<String, Object>> targetsList = new ArrayList<Map<String, Object>>();
                    for (Target target : this.targets) {
                        Map<String, Object> targetMap = target.toMap();
                        if (targetMap == null || targetMap.isEmpty()) continue;
                        targetsList.add(targetMap);
                    }
                    map.put("targets", targetsList);
                }
                if (this.version != null) {
                    map.put("version", this.version);
                }
                return map;
            }

            public APNS2Configuration setCollapseId(String collapseId) {
                this.collapseId = collapseId;
                return this;
            }

            public APNS2Configuration setExpiration(String expiration) {
                this.expiration = expiration;
                return this;
            }

            public APNS2Configuration setTargets(List<Target> targets) {
                this.targets = targets;
                return this;
            }

            public APNS2Configuration setVersion(String version) {
                this.version = version;
                return this;
            }

            public static class Target
            implements PushPayloadSerializer {
                private String topic;
                private List<String> excludeDevices;
                private PNPushEnvironment environment;

                @Override
                public Map<String, Object> toMap() {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (this.topic != null) {
                        map.put("topic", this.topic);
                    }
                    if (this.excludeDevices != null && !this.excludeDevices.isEmpty()) {
                        map.put("excluded_devices", this.excludeDevices);
                    }
                    if (this.environment != null) {
                        map.put("environment", this.environment.name().toLowerCase());
                    }
                    return map;
                }

                public Target setTopic(String topic) {
                    this.topic = topic;
                    return this;
                }

                public Target setExcludeDevices(List<String> excludeDevices) {
                    this.excludeDevices = excludeDevices;
                    return this;
                }

                public Target setEnvironment(PNPushEnvironment environment) {
                    this.environment = environment;
                    return this;
                }
            }
        }

        public static class APS
        implements PushPayloadSerializer {
            private Object alert;
            private Integer badge;
            private String sound;

            @Override
            public Map<String, Object> toMap() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (this.alert != null) {
                    map.put("alert", this.alert);
                }
                if (this.badge != null) {
                    map.put("badge", this.badge);
                }
                if (this.sound != null) {
                    map.put("sound", this.sound);
                }
                return map;
            }

            public APS setAlert(Object alert) {
                this.alert = alert;
                return this;
            }

            public APS setBadge(Integer badge) {
                this.badge = badge;
                return this;
            }

            public APS setSound(String sound) {
                this.sound = sound;
                return this;
            }
        }
    }
}

