/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.models.consumer.history;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;

public class PNFetchMessageItem {
    private final JsonElement message;
    private final JsonElement meta;
    private final Long timetoken;
    private final HashMap<String, HashMap<String, List<Action>>> actions;
    private final String uuid;
    @SerializedName(value="message_type")
    private final String messageType;

    private int getMessageType() {
        if (this.messageType == null || this.messageType.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(this.messageType);
    }

    PNFetchMessageItem(JsonElement message, JsonElement meta, Long timetoken, HashMap<String, HashMap<String, List<Action>>> actions, String uuid, String messageType) {
        this.message = message;
        this.meta = meta;
        this.timetoken = timetoken;
        this.actions = actions;
        this.uuid = uuid;
        this.messageType = messageType;
    }

    public static PNFetchMessageItemBuilder builder() {
        return new PNFetchMessageItemBuilder();
    }

    public PNFetchMessageItemBuilder toBuilder() {
        return new PNFetchMessageItemBuilder().message(this.message).meta(this.meta).timetoken(this.timetoken).actions(this.actions).uuid(this.uuid).messageType(this.messageType);
    }

    public JsonElement getMessage() {
        return this.message;
    }

    public JsonElement getMeta() {
        return this.meta;
    }

    public Long getTimetoken() {
        return this.timetoken;
    }

    public HashMap<String, HashMap<String, List<Action>>> getActions() {
        return this.actions;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PNFetchMessageItem)) {
            return false;
        }
        PNFetchMessageItem other = (PNFetchMessageItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonElement this$message = this.getMessage();
        JsonElement other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        JsonElement this$meta = this.getMeta();
        JsonElement other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !this$meta.equals(other$meta)) {
            return false;
        }
        Long this$timetoken = this.getTimetoken();
        Long other$timetoken = other.getTimetoken();
        if (this$timetoken == null ? other$timetoken != null : !((Object)this$timetoken).equals(other$timetoken)) {
            return false;
        }
        HashMap<String, HashMap<String, List<Action>>> this$actions = this.getActions();
        HashMap<String, HashMap<String, List<Action>>> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        return this.getMessageType() == other.getMessageType();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PNFetchMessageItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonElement $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        JsonElement $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : $meta.hashCode());
        Long $timetoken = this.getTimetoken();
        result = result * 59 + ($timetoken == null ? 43 : ((Object)$timetoken).hashCode());
        HashMap<String, HashMap<String, List<Action>>> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        result = result * 59 + this.getMessageType();
        return result;
    }

    public String toString() {
        return "PNFetchMessageItem(message=" + this.getMessage() + ", meta=" + this.getMeta() + ", timetoken=" + this.getTimetoken() + ", actions=" + this.getActions() + ", uuid=" + this.getUuid() + ", messageType=" + this.getMessageType() + ")";
    }

    public static class PNFetchMessageItemBuilder {
        private JsonElement message;
        private JsonElement meta;
        private Long timetoken;
        private HashMap<String, HashMap<String, List<Action>>> actions;
        private String uuid;
        private String messageType;

        PNFetchMessageItemBuilder() {
        }

        public PNFetchMessageItemBuilder message(JsonElement message) {
            this.message = message;
            return this;
        }

        public PNFetchMessageItemBuilder meta(JsonElement meta) {
            this.meta = meta;
            return this;
        }

        public PNFetchMessageItemBuilder timetoken(Long timetoken) {
            this.timetoken = timetoken;
            return this;
        }

        public PNFetchMessageItemBuilder actions(HashMap<String, HashMap<String, List<Action>>> actions) {
            this.actions = actions;
            return this;
        }

        public PNFetchMessageItemBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public PNFetchMessageItemBuilder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public PNFetchMessageItem build() {
            return new PNFetchMessageItem(this.message, this.meta, this.timetoken, this.actions, this.uuid, this.messageType);
        }

        public String toString() {
            return "PNFetchMessageItem.PNFetchMessageItemBuilder(message=" + this.message + ", meta=" + this.meta + ", timetoken=" + this.timetoken + ", actions=" + this.actions + ", uuid=" + this.uuid + ", messageType=" + this.messageType + ")";
        }
    }

    public static class Action {
        private final String uuid;
        private final String actionTimetoken;

        public Action(String uuid, String actionTimetoken) {
            this.uuid = uuid;
            this.actionTimetoken = actionTimetoken;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getActionTimetoken() {
            return this.actionTimetoken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uuid = this.getUuid();
            String other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
                return false;
            }
            String this$actionTimetoken = this.getActionTimetoken();
            String other$actionTimetoken = other.getActionTimetoken();
            return !(this$actionTimetoken == null ? other$actionTimetoken != null : !this$actionTimetoken.equals(other$actionTimetoken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
            String $actionTimetoken = this.getActionTimetoken();
            result = result * 59 + ($actionTimetoken == null ? 43 : $actionTimetoken.hashCode());
            return result;
        }

        public String toString() {
            return "PNFetchMessageItem.Action(uuid=" + this.getUuid() + ", actionTimetoken=" + this.getActionTimetoken() + ")";
        }
    }
}

