/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PubNub;
import com.pubnub.api.builder.dto.ChangeTemporaryUnavailableOperation;
import com.pubnub.api.builder.dto.PresenceOperation;
import com.pubnub.api.builder.dto.PubSubOperation;
import com.pubnub.api.builder.dto.StateOperation;
import com.pubnub.api.builder.dto.SubscribeOperation;
import com.pubnub.api.builder.dto.TimetokenAndRegionOperation;
import com.pubnub.api.builder.dto.UnsubscribeOperation;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.endpoints.presence.Heartbeat;
import com.pubnub.api.endpoints.presence.Leave;
import com.pubnub.api.endpoints.pubsub.Subscribe;
import com.pubnub.api.enums.PNHeartbeatNotificationOptions;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.DelayedReconnectionManager;
import com.pubnub.api.managers.DuplicationManager;
import com.pubnub.api.managers.ListenerManager;
import com.pubnub.api.managers.ReconnectionManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.StateManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeMessage;
import com.pubnub.api.workers.SubscribeMessageProcessor;
import com.pubnub.api.workers.SubscribeMessageWorker;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionManager.class);
    private static final int TWO_SECONDS = 2000;
    private static final int HEARTBEAT_INTERVAL_MULTIPLIER = 1000;
    private static final int MAX_HEARTBEAT_RETRIES = 5;
    private volatile boolean connected;
    private final AtomicInteger heartbeatRetries = new AtomicInteger(0);
    PubNub pubnub;
    private final TelemetryManager telemetryManager;
    private final TokenManager tokenManager;
    private Subscribe subscribeCall;
    private Heartbeat heartbeatCall;
    private final LinkedBlockingQueue<SubscribeMessage> messageQueue;
    private final DuplicationManager duplicationManager;
    private Timer timer;
    final StateManager subscriptionState;
    private final ListenerManager listenerManager;
    private final ReconnectionManager reconnectionManager;
    private final DelayedReconnectionManager delayedReconnectionManager;
    private final RetrofitManager retrofitManager;
    private Timer temporaryUnavailableChannelsDelayer;
    private Thread consumerThread;

    public SubscriptionManager(PubNub pubnubInstance, RetrofitManager retrofitManagerInstance, TelemetryManager telemetry, StateManager stateManager, final ListenerManager listenerManager, ReconnectionManager reconnectionManager, DelayedReconnectionManager delayedReconnectionManager, DuplicationManager duplicationManager, TokenManager tokenManager) {
        this.pubnub = pubnubInstance;
        this.telemetryManager = telemetry;
        this.messageQueue = new LinkedBlockingQueue();
        this.subscriptionState = stateManager;
        this.listenerManager = listenerManager;
        this.reconnectionManager = reconnectionManager;
        this.delayedReconnectionManager = delayedReconnectionManager;
        this.retrofitManager = retrofitManagerInstance;
        this.duplicationManager = duplicationManager;
        this.tokenManager = tokenManager;
        ReconnectionCallback reconnectionCallback = new ReconnectionCallback(){

            @Override
            public void onReconnection() {
                SubscriptionManager.this.reconnect(PubSubOperation.RECONNECT);
                StateManager.SubscriptionStateData subscriptionStateData = SubscriptionManager.this.subscriptionState.subscriptionStateData(true);
                PNStatus pnStatus = PNStatus.builder().error(false).affectedChannels(subscriptionStateData.getChannels()).affectedChannelGroups(subscriptionStateData.getChannelGroups()).category(PNStatusCategory.PNReconnectedCategory).build();
                listenerManager.announce(pnStatus);
            }

            @Override
            public void onMaxReconnectionExhaustion() {
                StateManager.SubscriptionStateData subscriptionStateData = SubscriptionManager.this.subscriptionState.subscriptionStateData(true);
                PNStatus pnStatus = PNStatus.builder().error(false).category(PNStatusCategory.PNReconnectionAttemptsExhaustedCategory).affectedChannels(subscriptionStateData.getChannels()).affectedChannelGroups(subscriptionStateData.getChannelGroups()).build();
                listenerManager.announce(pnStatus);
                SubscriptionManager.this.disconnect();
            }
        };
        this.delayedReconnectionManager.setReconnectionListener(reconnectionCallback);
        this.reconnectionManager.setReconnectionListener(reconnectionCallback);
        if (this.pubnub.getConfiguration().isStartSubscriberThread()) {
            this.consumerThread = new Thread(new SubscribeMessageWorker(listenerManager, this.messageQueue, new SubscribeMessageProcessor(this.pubnub, duplicationManager)));
            this.consumerThread.setName("Subscription Manager Consumer Thread");
            this.consumerThread.setDaemon(true);
            this.consumerThread.start();
        }
    }

    public void reconnect() {
        this.reconnect(PubSubOperation.RECONNECT);
    }

    private synchronized void reconnect(PubSubOperation pubSubOperation) {
        this.connected = true;
        this.startSubscribeLoop(pubSubOperation);
        this.registerHeartbeatTimer(PubSubOperation.NO_OP);
    }

    public synchronized void disconnect() {
        this.connected = false;
        this.cancelDelayedLoopIterationForTemporaryUnavailableChannels();
        this.subscriptionState.handleOperation(PubSubOperation.DISCONNECT);
        this.delayedReconnectionManager.stop();
        this.stopHeartbeatTimer();
        this.stopSubscribeLoop();
    }

    @Deprecated
    public synchronized void stop() {
        this.disconnect();
        this.consumerThread.interrupt();
    }

    public synchronized void destroy(boolean forceDestroy) {
        this.disconnect();
        if (forceDestroy && this.consumerThread != null) {
            this.consumerThread.interrupt();
        }
    }

    public void adaptStateBuilder(StateOperation stateOperation) {
        this.connected = true;
        this.startSubscribeLoop(stateOperation);
    }

    public void adaptSubscribeBuilder(SubscribeOperation subscribeOperation) {
        this.reconnect(subscribeOperation);
    }

    public void adaptPresenceBuilder(PresenceOperation presenceOperation) {
        if (!this.pubnub.getConfiguration().isSuppressLeaveEvents() && !presenceOperation.isConnected()) {
            new Leave(this.pubnub, this.telemetryManager, this.retrofitManager, this.tokenManager).channels(presenceOperation.getChannels()).channelGroups(presenceOperation.getChannelGroups()).async(new PNCallback<Boolean>(){

                @Override
                public void onResponse(Boolean result, @NotNull PNStatus status) {
                    SubscriptionManager.this.listenerManager.announce(status);
                }
            });
        }
        this.registerHeartbeatTimer(presenceOperation);
    }

    public void adaptUnsubscribeBuilder(UnsubscribeOperation unsubscribeOperation) {
        this.reconnect(unsubscribeOperation);
        if (!this.pubnub.getConfiguration().isSuppressLeaveEvents()) {
            new Leave(this.pubnub, this.telemetryManager, this.retrofitManager, this.tokenManager).channels(unsubscribeOperation.getChannels()).channelGroups(unsubscribeOperation.getChannelGroups()).async(new PNCallback<Boolean>(){

                @Override
                public void onResponse(Boolean result, @NotNull PNStatus status) {
                    if (status.isError() && status.getCategory() == PNStatusCategory.PNAccessDeniedCategory) {
                        return;
                    }
                    SubscriptionManager.this.listenerManager.announce(status);
                }
            });
        }
    }

    private synchronized void registerHeartbeatTimer(final PubSubOperation pubSubOperation) {
        this.stopHeartbeatTimer();
        if (this.pubnub.getConfiguration().getHeartbeatInterval() <= 0) {
            return;
        }
        this.timer = new Timer("Subscription Manager Heartbeat Timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SubscriptionManager.this.performHeartbeatLoop(pubSubOperation);
            }
        }, 0L, (long)(this.pubnub.getConfiguration().getHeartbeatInterval() * 1000));
    }

    private void stopHeartbeatTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.heartbeatCall != null) {
            this.heartbeatCall.silentCancel();
            this.heartbeatCall = null;
        }
        this.heartbeatRetries.set(0);
    }

    private synchronized void cancelDelayedLoopIterationForTemporaryUnavailableChannels() {
        if (this.temporaryUnavailableChannelsDelayer != null) {
            this.temporaryUnavailableChannelsDelayer.cancel();
            this.temporaryUnavailableChannelsDelayer = null;
        }
    }

    private void scheduleDelayedLoopIterationForTemporaryUnavailableChannels() {
        this.cancelDelayedLoopIterationForTemporaryUnavailableChannels();
        this.temporaryUnavailableChannelsDelayer = new Timer("Subscription Manager TMP Unavailable Channel Delayer", true);
        this.temporaryUnavailableChannelsDelayer.schedule(new TimerTask(){

            @Override
            public void run() {
                SubscriptionManager.this.startSubscribeLoop(PubSubOperation.NO_OP);
            }
        }, 2000L);
    }

    synchronized void startSubscribeLoop(PubSubOperation ... pubSubOperations) {
        if (!this.connected) {
            return;
        }
        boolean subscriptionLoopStateChanged = this.subscriptionState.handleOperation(pubSubOperations);
        if (!subscriptionLoopStateChanged) {
            return;
        }
        this.stopSubscribeLoop();
        for (PubSubOperation pubSubOperation : pubSubOperations) {
            if (!(pubSubOperation instanceof SubscribeOperation)) continue;
            this.duplicationManager.clearHistory();
        }
        StateManager.SubscriptionStateData subscriptionStateData = this.subscriptionState.subscriptionStateData(true, StateManager.ChannelFilter.WITHOUT_TEMPORARY_UNAVAILABLE);
        if (!subscriptionStateData.isAnythingToSubscribe()) {
            return;
        }
        if (subscriptionStateData.isSubscribedToOnlyTemporaryUnavailable()) {
            this.scheduleDelayedLoopIterationForTemporaryUnavailableChannels();
            return;
        }
        this.subscribeCall = new Subscribe(this.pubnub, this.retrofitManager, this.tokenManager).channels(subscriptionStateData.getChannels()).channelGroups(subscriptionStateData.getChannelGroups()).timetoken(subscriptionStateData.getTimetoken()).region(subscriptionStateData.getRegion()).filterExpression(this.pubnub.getConfiguration().getFilterExpression()).state(subscriptionStateData.getStatePayload());
        this.subscribeCall.async((result, status) -> {
            if (status.isError()) {
                this.handleError(status, pubSubOperations);
            } else {
                PubSubOperation statusAnnouncedOperation;
                ChangeTemporaryUnavailableOperation.ChangeTemporaryUnavailableOperationBuilder availableChannels = ChangeTemporaryUnavailableOperation.builder();
                if (status.getCategory() == PNStatusCategory.PNAcknowledgmentCategory) {
                    List<String> affectedChannels = status.getAffectedChannels();
                    List<String> affectedChannelGroups = status.getAffectedChannelGroups();
                    if (affectedChannels != null) {
                        for (String affectedChannel : affectedChannels) {
                            availableChannels.availableChannel(affectedChannel);
                        }
                    }
                    if (affectedChannelGroups != null) {
                        for (String affectedChannelGroup : affectedChannelGroups) {
                            availableChannels.availableChannelGroup(affectedChannelGroup);
                        }
                    }
                }
                if (subscriptionStateData.isShouldAnnounce()) {
                    PNStatus pnStatus = this.createPublicStatus(status).category(subscriptionStateData.getAnnounceStatus()).error(false).build();
                    this.listenerManager.announce(pnStatus);
                    statusAnnouncedOperation = PubSubOperation.STATUS_ANNOUNCED;
                } else {
                    statusAnnouncedOperation = PubSubOperation.NO_OP;
                }
                Integer requestMessageCountThreshold = this.pubnub.getConfiguration().getRequestMessageCountThreshold();
                if (requestMessageCountThreshold != null && requestMessageCountThreshold <= result.getMessages().size()) {
                    PNStatus pnStatus = this.createPublicStatus(status).category(PNStatusCategory.PNRequestMessageCountExceededCategory).error(false).build();
                    this.listenerManager.announce(pnStatus);
                }
                if (result.getMessages().size() != 0) {
                    this.messageQueue.addAll(result.getMessages());
                }
                TimetokenAndRegionOperation timetokenAndRegionOperation = new TimetokenAndRegionOperation(result.getMetadata().getTimetoken(), result.getMetadata().getRegion());
                this.startSubscribeLoop(timetokenAndRegionOperation, availableChannels.build(), statusAnnouncedOperation);
            }
        });
    }

    private void handleError(@NotNull PNStatus status, PubSubOperation ... pubSubOperations) {
        PNStatusCategory category = status.getCategory();
        switch (category) {
            case PNTimeoutCategory: {
                this.startSubscribeLoop(pubSubOperations);
                break;
            }
            case PNUnexpectedDisconnectCategory: {
                this.disconnect();
                this.listenerManager.announce(status);
                this.reconnectionManager.startPolling();
                break;
            }
            case PNBadRequestCategory: 
            case PNURITooLongCategory: {
                this.disconnect();
                this.listenerManager.announce(status);
                break;
            }
            case PNAccessDeniedCategory: {
                this.listenerManager.announce(status);
                List<String> affectedChannels = status.getAffectedChannels();
                List<String> affectedChannelGroups = status.getAffectedChannelGroups();
                ChangeTemporaryUnavailableOperation.ChangeTemporaryUnavailableOperationBuilder unavailableChannels = ChangeTemporaryUnavailableOperation.builder();
                if (affectedChannels == null && affectedChannelGroups == null) break;
                if (affectedChannels != null) {
                    for (String channelToMoveToTemporaryUnavailable : affectedChannels) {
                        unavailableChannels.unavailableChannel(channelToMoveToTemporaryUnavailable);
                    }
                }
                if (affectedChannelGroups != null) {
                    for (String channelGroupToMoveToTemporaryUnavailable : affectedChannelGroups) {
                        unavailableChannels.unavailableChannelGroup(channelGroupToMoveToTemporaryUnavailable);
                    }
                }
                this.startSubscribeLoop(unavailableChannels.build());
                break;
            }
            default: {
                this.listenerManager.announce(status);
                this.delayedReconnectionManager.scheduleDelayedReconnection();
            }
        }
    }

    private void stopSubscribeLoop() {
        this.cancelDelayedLoopIterationForTemporaryUnavailableChannels();
        if (this.subscribeCall != null) {
            this.subscribeCall.silentCancel();
            this.subscribeCall = null;
        }
    }

    private synchronized void performHeartbeatLoop(PubSubOperation pubSubOperation) {
        if (this.heartbeatCall != null) {
            this.heartbeatCall.silentCancel();
            this.heartbeatCall = null;
        }
        this.subscriptionState.handleOperation(pubSubOperation);
        StateManager.HeartbeatStateData heartbeatStateData = this.subscriptionState.heartbeatStateData();
        List<String> heartbeatChannels = heartbeatStateData.getHeartbeatChannels();
        List<String> heartbeatChannelGroups = heartbeatStateData.getHeartbeatChannelGroups();
        if (heartbeatChannels.isEmpty() && heartbeatChannelGroups.isEmpty()) {
            return;
        }
        Map<String, Object> statePayload = heartbeatStateData.getStatePayload().isEmpty() ? null : heartbeatStateData.getStatePayload();
        this.heartbeatCall = new Heartbeat(this.pubnub, this.telemetryManager, this.retrofitManager, this.tokenManager).channels(heartbeatChannels).channelGroups(heartbeatChannelGroups).state(statePayload);
        this.heartbeatCall.async(new PNCallback<Boolean>(){

            @Override
            public void onResponse(Boolean result, @NotNull PNStatus status) {
                PNHeartbeatNotificationOptions heartbeatVerbosity = SubscriptionManager.this.pubnub.getConfiguration().getHeartbeatNotificationOptions();
                if (status.isError()) {
                    if (SubscriptionManager.this.heartbeatRetries.getAndIncrement() >= 5) {
                        SubscriptionManager.this.stopHeartbeatTimer();
                    }
                    if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL || heartbeatVerbosity == PNHeartbeatNotificationOptions.FAILURES) {
                        SubscriptionManager.this.listenerManager.announce(status);
                    }
                } else {
                    SubscriptionManager.this.heartbeatRetries.set(0);
                    if (heartbeatVerbosity == PNHeartbeatNotificationOptions.ALL) {
                        SubscriptionManager.this.listenerManager.announce(status);
                    }
                }
            }
        });
    }

    public void unsubscribeAll() {
        StateManager.SubscriptionStateData subscriptionStateData = this.subscriptionState.subscriptionStateData(false);
        this.adaptUnsubscribeBuilder(UnsubscribeOperation.builder().channelGroups(subscriptionStateData.getChannelGroups()).channels(subscriptionStateData.getChannels()).build());
    }

    private PNStatus.PNStatusBuilder createPublicStatus(PNStatus privateStatus) {
        return PNStatus.builder().statusCode(privateStatus.getStatusCode()).authKey(privateStatus.getAuthKey()).operation(privateStatus.getOperation()).affectedChannels(privateStatus.getAffectedChannels()).affectedChannelGroups(privateStatus.getAffectedChannelGroups()).clientRequest(privateStatus.getClientRequest()).origin(privateStatus.getOrigin()).tlsEnabled(privateStatus.isTlsEnabled());
    }
}

