/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.builder.dto.ChangeTemporaryUnavailableOperation;
import com.pubnub.api.builder.dto.PresenceOperation;
import com.pubnub.api.builder.dto.PubSubOperation;
import com.pubnub.api.builder.dto.StateOperation;
import com.pubnub.api.builder.dto.SubscribeOperation;
import com.pubnub.api.builder.dto.TimetokenAndRegionOperation;
import com.pubnub.api.builder.dto.UnsubscribeOperation;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.SubscriptionItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateManager {
    static final int MILLIS_IN_SECOND = 1000;
    private final Map<String, SubscriptionItem> channels = new HashMap<String, SubscriptionItem>();
    private final Map<String, SubscriptionItem> presenceChannels = new HashMap<String, SubscriptionItem>();
    private final Map<String, SubscriptionItem> groups = new HashMap<String, SubscriptionItem>();
    private final Map<String, SubscriptionItem> presenceGroups = new HashMap<String, SubscriptionItem>();
    private final Map<String, SubscriptionItem> heartbeatChannels = new HashMap<String, SubscriptionItem>();
    private final Map<String, SubscriptionItem> heartbeatGroups = new HashMap<String, SubscriptionItem>();
    private final List<TemporaryUnavailableItem> temporaryUnavailableChannels = new ArrayList<TemporaryUnavailableItem>();
    private final List<TemporaryUnavailableItem> temporaryUnavailableChannelGroups = new ArrayList<TemporaryUnavailableItem>();
    private Long timetoken = 0L;
    private Long storedTimetoken = null;
    private String region = null;
    private final PNConfiguration configuration;
    private PNStatusCategory announceStatus = null;

    public StateManager(PNConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized boolean handleOperation(PubSubOperation ... pubSubOperations) {
        boolean stateChanged = false;
        for (PubSubOperation pubSubOperation : pubSubOperations) {
            if (pubSubOperation instanceof SubscribeOperation) {
                if (!this.adaptSubscribeBuilder((SubscribeOperation)pubSubOperation)) continue;
                stateChanged = true;
                this.announceStatus = PNStatusCategory.PNConnectedCategory;
                continue;
            }
            if (pubSubOperation instanceof UnsubscribeOperation) {
                this.unsubscribe((UnsubscribeOperation)pubSubOperation);
                stateChanged = true;
                this.announceStatus = PNStatusCategory.PNConnectedCategory;
                continue;
            }
            if (pubSubOperation instanceof StateOperation) {
                stateChanged = true;
                this.adaptStateBuilder((StateOperation)pubSubOperation);
                continue;
            }
            if (pubSubOperation instanceof PresenceOperation) {
                this.adaptPresenceBuilder((PresenceOperation)pubSubOperation);
                continue;
            }
            if (pubSubOperation instanceof TimetokenAndRegionOperation) {
                TimetokenAndRegionOperation ttAndReg = (TimetokenAndRegionOperation)pubSubOperation;
                this.updateTimetokenAndRegion(ttAndReg.getTimetoken(), ttAndReg.getRegion());
                stateChanged = true;
                continue;
            }
            if (pubSubOperation instanceof PubSubOperation.DisconnectOperation) {
                this.resetTemporaryUnavailableChannelsAndGroups();
                continue;
            }
            if (pubSubOperation instanceof ChangeTemporaryUnavailableOperation) {
                this.changeTemporary((ChangeTemporaryUnavailableOperation)pubSubOperation);
                continue;
            }
            if (pubSubOperation instanceof PubSubOperation.ConnectedStatusAnnouncedOperation) {
                this.announceStatus = null;
                continue;
            }
            if (!(pubSubOperation instanceof PubSubOperation.ReconnectOperation)) continue;
            stateChanged = true;
            this.announceStatus = PNStatusCategory.PNReconnectedCategory;
            this.storedTimetoken = this.timetoken;
            this.timetoken = 0L;
        }
        return stateChanged;
    }

    public synchronized SubscriptionStateData subscriptionStateData(Boolean includePresence) {
        return this.subscriptionStateData(includePresence, ChannelFilter.WITH_TEMPORARY_UNAVAILABLE);
    }

    public synchronized SubscriptionStateData subscriptionStateData(Boolean includePresence, ChannelFilter channelFilter) {
        List<String> groupsList;
        List<String> channelsList;
        if (channelFilter == ChannelFilter.WITH_TEMPORARY_UNAVAILABLE) {
            channelsList = this.prepareMembershipList(this.channels, this.presenceChannels, includePresence);
            groupsList = this.prepareMembershipList(this.groups, this.presenceGroups, includePresence);
        } else {
            channelsList = this.effectiveChannels(includePresence);
            groupsList = this.effectiveChannelGroups(includePresence);
        }
        return new SubscriptionStateData(this.createStatePayload(), groupsList, channelsList, this.timetoken, this.region, this.hasAnythingToSubscribe(), this.subscribedToOnlyTemporaryUnavailable(), this.announceStatus);
    }

    public synchronized HeartbeatStateData heartbeatStateData() {
        if (this.configuration.isManagePresenceListManually()) {
            return new HeartbeatStateData(this.createHeartbeatStatePayload(), this.getNames(this.heartbeatGroups), this.getNames(this.heartbeatChannels));
        }
        List<String> heartbeatGroupNames = this.getNames(this.heartbeatGroups);
        heartbeatGroupNames.addAll(this.getNames(this.groups));
        List<String> heartbeatChannelNames = this.getNames(this.heartbeatChannels);
        heartbeatChannelNames.addAll(this.getNames(this.channels));
        return new HeartbeatStateData(Collections.emptyMap(), heartbeatGroupNames, heartbeatChannelNames);
    }

    private void updateTimetokenAndRegion(Long newTimetoken, String region) {
        if (this.storedTimetoken != null) {
            this.timetoken = this.storedTimetoken;
            this.storedTimetoken = null;
        } else {
            this.timetoken = newTimetoken;
        }
        this.region = region;
    }

    private void explicitlySetTimetoken(Long timetokenToSet) {
        if (timetokenToSet != null) {
            this.timetoken = timetokenToSet;
        }
        if (this.timetoken != 0L) {
            this.storedTimetoken = this.timetoken;
        }
        this.timetoken = 0L;
    }

    private boolean adaptSubscribeBuilder(SubscribeOperation subscribeOperation) {
        SubscriptionItem presenceSubscriptionItem;
        SubscriptionItem subscriptionItem;
        boolean changeDetected = false;
        for (String channel : subscribeOperation.getChannels()) {
            if (channel == null || channel.length() == 0) continue;
            subscriptionItem = new SubscriptionItem().setName(channel);
            boolean bl = changeDetected = this.putIfDifferent(this.channels, channel, subscriptionItem) || changeDetected;
            if (!subscribeOperation.isPresenceEnabled()) continue;
            presenceSubscriptionItem = new SubscriptionItem().setName(channel);
            changeDetected = this.putIfDifferent(this.presenceChannels, channel, presenceSubscriptionItem) || changeDetected;
        }
        for (String channelGroup : subscribeOperation.getChannelGroups()) {
            if (channelGroup == null || channelGroup.length() == 0) continue;
            subscriptionItem = new SubscriptionItem().setName(channelGroup);
            boolean bl = changeDetected = this.putIfDifferent(this.groups, channelGroup, subscriptionItem) || changeDetected;
            if (!subscribeOperation.isPresenceEnabled()) continue;
            presenceSubscriptionItem = new SubscriptionItem().setName(channelGroup);
            changeDetected = this.putIfDifferent(this.presenceGroups, channelGroup, presenceSubscriptionItem) || changeDetected;
        }
        if (changeDetected) {
            this.explicitlySetTimetoken(subscribeOperation.getTimetoken());
        }
        return changeDetected;
    }

    private <T> boolean putIfDifferent(Map<String, T> map, String key, T newValue) {
        T existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, newValue);
            return true;
        }
        if (existingValue.equals(newValue)) {
            return false;
        }
        map.put(key, newValue);
        return true;
    }

    private void adaptStateBuilder(StateOperation stateOperation) {
        for (String channel : stateOperation.getChannels()) {
            SubscriptionItem heartbeatChannel;
            SubscriptionItem subscribedChannel = this.channels.get(channel);
            if (subscribedChannel != null) {
                subscribedChannel.setState(stateOperation.getState());
            }
            if ((heartbeatChannel = this.heartbeatChannels.get(channel)) == null) continue;
            heartbeatChannel.setState(stateOperation.getState());
        }
        for (String channelGroup : stateOperation.getChannelGroups()) {
            SubscriptionItem heartbeatChannelGroup;
            SubscriptionItem subscribedChannelGroup = this.groups.get(channelGroup);
            if (subscribedChannelGroup != null) {
                subscribedChannelGroup.setState(stateOperation.getState());
            }
            if ((heartbeatChannelGroup = this.heartbeatGroups.get(channelGroup)) == null) continue;
            heartbeatChannelGroup.setState(stateOperation.getState());
        }
    }

    private void unsubscribe(UnsubscribeOperation unsubscribeOperation) {
        for (String channel : unsubscribeOperation.getChannels()) {
            this.channels.remove(channel);
            this.presenceChannels.remove(channel);
        }
        this.removeTemporaryUnavailableChannels(unsubscribeOperation.getChannels());
        for (String channelGroup : unsubscribeOperation.getChannelGroups()) {
            this.groups.remove(channelGroup);
            this.presenceGroups.remove(channelGroup);
        }
        this.removeTemporaryUnavailableChannelGroups(unsubscribeOperation.getChannelGroups());
        if (this.isEmpty()) {
            this.region = null;
            this.storedTimetoken = null;
        } else {
            this.storedTimetoken = this.timetoken;
        }
        this.timetoken = 0L;
    }

    private void adaptPresenceBuilder(PresenceOperation presenceOperation) {
        SubscriptionItem subscriptionItem;
        for (String channel : presenceOperation.getChannels()) {
            if (channel == null || channel.length() == 0) continue;
            if (presenceOperation.isConnected()) {
                subscriptionItem = new SubscriptionItem().setName(channel);
                this.heartbeatChannels.put(channel, subscriptionItem);
                continue;
            }
            this.heartbeatChannels.remove(channel);
        }
        for (String channelGroup : presenceOperation.getChannelGroups()) {
            if (channelGroup == null || channelGroup.length() == 0) continue;
            if (presenceOperation.isConnected()) {
                subscriptionItem = new SubscriptionItem().setName(channelGroup);
                this.heartbeatGroups.put(channelGroup, subscriptionItem);
                continue;
            }
            this.heartbeatGroups.remove(channelGroup);
        }
    }

    private void changeTemporary(ChangeTemporaryUnavailableOperation operation) {
        for (String channel : operation.getUnavailableChannels()) {
            this.temporaryUnavailableChannels.add(new TemporaryUnavailableItem(channel, new Date()));
        }
        for (String channelGroup : operation.getUnavailableChannelGroups()) {
            this.temporaryUnavailableChannelGroups.add(new TemporaryUnavailableItem(channelGroup, new Date()));
        }
        this.removeTemporaryUnavailableChannels(operation.getAvailableChannels());
        this.removeTemporaryUnavailableChannelGroups(operation.getAvailableChannelGroups());
    }

    private Map<String, Object> createStatePayload() {
        return this.createStatePayload(this.channels, this.groups);
    }

    private Map<String, Object> createHeartbeatStatePayload() {
        return this.createStatePayload(this.heartbeatChannels, this.heartbeatGroups);
    }

    private Map<String, Object> createStatePayload(Map<String, SubscriptionItem> channels, Map<String, SubscriptionItem> groups) {
        HashMap<String, Object> stateResponse = new HashMap<String, Object>();
        for (SubscriptionItem channel : channels.values()) {
            if (channel.getState() == null) continue;
            stateResponse.put(channel.getName(), channel.getState());
        }
        for (SubscriptionItem channelGroup : groups.values()) {
            if (channelGroup.getState() == null) continue;
            stateResponse.put(channelGroup.getName(), channelGroup.getState());
        }
        return stateResponse;
    }

    private boolean hasAnythingToSubscribe() {
        List<String> combinedChannels = this.prepareMembershipList(this.channels, this.presenceChannels, true);
        List<String> combinedChannelGroups = this.prepareMembershipList(this.groups, this.presenceGroups, true);
        return !combinedChannels.isEmpty() || !combinedChannelGroups.isEmpty();
    }

    private void resetTemporaryUnavailableChannelsAndGroups() {
        this.temporaryUnavailableChannels.clear();
        this.temporaryUnavailableChannelGroups.clear();
    }

    private void removeTemporaryUnavailableChannels(Collection<String> channels) {
        this.removeTemporaryUnavailable(channels, this.temporaryUnavailableChannels);
    }

    private void removeTemporaryUnavailableChannelGroups(Collection<String> channelGroups) {
        this.removeTemporaryUnavailable(channelGroups, this.temporaryUnavailableChannelGroups);
    }

    private void removeTemporaryUnavailable(Collection<String> toBeRemoved, Collection<TemporaryUnavailableItem> temporaryUnavailableItems) {
        if (toBeRemoved.isEmpty()) {
            return;
        }
        ArrayList<TemporaryUnavailableItem> temporaryUnavailableItemsToBeRemoved = new ArrayList<TemporaryUnavailableItem>();
        for (TemporaryUnavailableItem temporaryUnavailableItem : temporaryUnavailableItems) {
            if (!toBeRemoved.contains(temporaryUnavailableItem.getItem())) continue;
            temporaryUnavailableItemsToBeRemoved.add(temporaryUnavailableItem);
        }
        temporaryUnavailableItems.removeAll(temporaryUnavailableItemsToBeRemoved);
    }

    private boolean subscribedToOnlyTemporaryUnavailable() {
        return this.effectiveChannels().isEmpty() && this.effectiveChannelGroups().isEmpty();
    }

    private List<String> effectiveChannels() {
        return this.effectiveChannels(true);
    }

    private List<String> effectiveChannels(boolean includePresence) {
        List<String> effectiveChannelsList = this.prepareMembershipList(this.channels, this.presenceChannels, includePresence);
        effectiveChannelsList.removeAll(this.channelsToPostponeSubscription(this.temporaryUnavailableChannels));
        return effectiveChannelsList;
    }

    private List<String> effectiveChannelGroups() {
        return this.effectiveChannelGroups(true);
    }

    private List<String> effectiveChannelGroups(boolean includePresence) {
        List<String> effectiveChannelGroupsList = this.prepareMembershipList(this.groups, this.presenceGroups, includePresence);
        effectiveChannelGroupsList.removeAll(this.channelGroupsToPostponeSubscription(this.temporaryUnavailableChannelGroups));
        return effectiveChannelGroupsList;
    }

    private List<String> channelsToPostponeSubscription(List<TemporaryUnavailableItem> temporaryUnavailableChannels) {
        ArrayList<String> result = new ArrayList<String>();
        for (TemporaryUnavailableItem temporaryUnavailableChannel : temporaryUnavailableChannels) {
            if (!temporaryUnavailableChannel.getTimestamp().after(new Date(System.currentTimeMillis() - (long)(this.configuration.getConnectTimeout() * 1000)))) continue;
            result.add(temporaryUnavailableChannel.getItem());
        }
        return result;
    }

    private List<String> channelGroupsToPostponeSubscription(List<TemporaryUnavailableItem> temporaryUnavailableChannelGroups) {
        ArrayList<String> result = new ArrayList<String>();
        for (TemporaryUnavailableItem temporaryUnavailableChannelGroup : temporaryUnavailableChannelGroups) {
            if (!temporaryUnavailableChannelGroup.getTimestamp().after(new Date(System.currentTimeMillis() - (long)(this.configuration.getConnectTimeout() * 1000)))) continue;
            result.add(temporaryUnavailableChannelGroup.getItem());
        }
        return result;
    }

    private boolean isEmpty() {
        return this.channels.isEmpty() && this.presenceChannels.isEmpty() && this.groups.isEmpty() && this.presenceGroups.isEmpty();
    }

    private List<String> getNames(Map<String, SubscriptionItem> dataStorage) {
        return new ArrayList<String>(dataStorage.keySet());
    }

    private void addPresence(List<String> response, Map<String, SubscriptionItem> presenceStorage) {
        for (SubscriptionItem presenceChannelGroupItem : presenceStorage.values()) {
            response.add(presenceChannelGroupItem.getName().concat("-pnpres"));
        }
    }

    private List<String> prepareMembershipList(Map<String, SubscriptionItem> dataStorage, Map<String, SubscriptionItem> presenceStorage, boolean includePresence) {
        List<String> response = this.getNames(dataStorage);
        if (includePresence) {
            this.addPresence(response, presenceStorage);
        }
        return response;
    }

    public static class HeartbeatStateData {
        private final Map<String, Object> statePayload;
        private final List<String> heartbeatChannelGroups;
        private final List<String> heartbeatChannels;

        public HeartbeatStateData(Map<String, Object> statePayload, List<String> heartbeatChannelGroups, List<String> heartbeatChannels) {
            this.statePayload = statePayload;
            this.heartbeatChannelGroups = heartbeatChannelGroups;
            this.heartbeatChannels = heartbeatChannels;
        }

        public Map<String, Object> getStatePayload() {
            return this.statePayload;
        }

        public List<String> getHeartbeatChannelGroups() {
            return this.heartbeatChannelGroups;
        }

        public List<String> getHeartbeatChannels() {
            return this.heartbeatChannels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeartbeatStateData)) {
                return false;
            }
            HeartbeatStateData other = (HeartbeatStateData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$statePayload = this.getStatePayload();
            Map<String, Object> other$statePayload = other.getStatePayload();
            if (this$statePayload == null ? other$statePayload != null : !((Object)this$statePayload).equals(other$statePayload)) {
                return false;
            }
            List<String> this$heartbeatChannelGroups = this.getHeartbeatChannelGroups();
            List<String> other$heartbeatChannelGroups = other.getHeartbeatChannelGroups();
            if (this$heartbeatChannelGroups == null ? other$heartbeatChannelGroups != null : !((Object)this$heartbeatChannelGroups).equals(other$heartbeatChannelGroups)) {
                return false;
            }
            List<String> this$heartbeatChannels = this.getHeartbeatChannels();
            List<String> other$heartbeatChannels = other.getHeartbeatChannels();
            return !(this$heartbeatChannels == null ? other$heartbeatChannels != null : !((Object)this$heartbeatChannels).equals(other$heartbeatChannels));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HeartbeatStateData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $statePayload = this.getStatePayload();
            result = result * 59 + ($statePayload == null ? 43 : ((Object)$statePayload).hashCode());
            List<String> $heartbeatChannelGroups = this.getHeartbeatChannelGroups();
            result = result * 59 + ($heartbeatChannelGroups == null ? 43 : ((Object)$heartbeatChannelGroups).hashCode());
            List<String> $heartbeatChannels = this.getHeartbeatChannels();
            result = result * 59 + ($heartbeatChannels == null ? 43 : ((Object)$heartbeatChannels).hashCode());
            return result;
        }

        public String toString() {
            return "StateManager.HeartbeatStateData(statePayload=" + this.getStatePayload() + ", heartbeatChannelGroups=" + this.getHeartbeatChannelGroups() + ", heartbeatChannels=" + this.getHeartbeatChannels() + ")";
        }
    }

    public static class SubscriptionStateData {
        private final Map<String, Object> statePayload;
        private final List<String> channelGroups;
        private final List<String> channels;
        private final Long timetoken;
        private final String region;
        private final boolean anythingToSubscribe;
        private final boolean subscribedToOnlyTemporaryUnavailable;
        private final PNStatusCategory announceStatus;

        public boolean isShouldAnnounce() {
            return this.announceStatus != null;
        }

        public SubscriptionStateData(Map<String, Object> statePayload, List<String> channelGroups, List<String> channels, Long timetoken, String region, boolean anythingToSubscribe, boolean subscribedToOnlyTemporaryUnavailable, PNStatusCategory announceStatus) {
            this.statePayload = statePayload;
            this.channelGroups = channelGroups;
            this.channels = channels;
            this.timetoken = timetoken;
            this.region = region;
            this.anythingToSubscribe = anythingToSubscribe;
            this.subscribedToOnlyTemporaryUnavailable = subscribedToOnlyTemporaryUnavailable;
            this.announceStatus = announceStatus;
        }

        public Map<String, Object> getStatePayload() {
            return this.statePayload;
        }

        public List<String> getChannelGroups() {
            return this.channelGroups;
        }

        public List<String> getChannels() {
            return this.channels;
        }

        public Long getTimetoken() {
            return this.timetoken;
        }

        public String getRegion() {
            return this.region;
        }

        public boolean isAnythingToSubscribe() {
            return this.anythingToSubscribe;
        }

        public boolean isSubscribedToOnlyTemporaryUnavailable() {
            return this.subscribedToOnlyTemporaryUnavailable;
        }

        public PNStatusCategory getAnnounceStatus() {
            return this.announceStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionStateData)) {
                return false;
            }
            SubscriptionStateData other = (SubscriptionStateData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$statePayload = this.getStatePayload();
            Map<String, Object> other$statePayload = other.getStatePayload();
            if (this$statePayload == null ? other$statePayload != null : !((Object)this$statePayload).equals(other$statePayload)) {
                return false;
            }
            List<String> this$channelGroups = this.getChannelGroups();
            List<String> other$channelGroups = other.getChannelGroups();
            if (this$channelGroups == null ? other$channelGroups != null : !((Object)this$channelGroups).equals(other$channelGroups)) {
                return false;
            }
            List<String> this$channels = this.getChannels();
            List<String> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            Long this$timetoken = this.getTimetoken();
            Long other$timetoken = other.getTimetoken();
            if (this$timetoken == null ? other$timetoken != null : !((Object)this$timetoken).equals(other$timetoken)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            if (this.isAnythingToSubscribe() != other.isAnythingToSubscribe()) {
                return false;
            }
            if (this.isSubscribedToOnlyTemporaryUnavailable() != other.isSubscribedToOnlyTemporaryUnavailable()) {
                return false;
            }
            PNStatusCategory this$announceStatus = this.getAnnounceStatus();
            PNStatusCategory other$announceStatus = other.getAnnounceStatus();
            return !(this$announceStatus == null ? other$announceStatus != null : !((Object)((Object)this$announceStatus)).equals((Object)other$announceStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SubscriptionStateData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $statePayload = this.getStatePayload();
            result = result * 59 + ($statePayload == null ? 43 : ((Object)$statePayload).hashCode());
            List<String> $channelGroups = this.getChannelGroups();
            result = result * 59 + ($channelGroups == null ? 43 : ((Object)$channelGroups).hashCode());
            List<String> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            Long $timetoken = this.getTimetoken();
            result = result * 59 + ($timetoken == null ? 43 : ((Object)$timetoken).hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            result = result * 59 + (this.isAnythingToSubscribe() ? 79 : 97);
            result = result * 59 + (this.isSubscribedToOnlyTemporaryUnavailable() ? 79 : 97);
            PNStatusCategory $announceStatus = this.getAnnounceStatus();
            result = result * 59 + ($announceStatus == null ? 43 : ((Object)((Object)$announceStatus)).hashCode());
            return result;
        }

        public String toString() {
            return "StateManager.SubscriptionStateData(statePayload=" + this.getStatePayload() + ", channelGroups=" + this.getChannelGroups() + ", channels=" + this.getChannels() + ", timetoken=" + this.getTimetoken() + ", region=" + this.getRegion() + ", anythingToSubscribe=" + this.isAnythingToSubscribe() + ", subscribedToOnlyTemporaryUnavailable=" + this.isSubscribedToOnlyTemporaryUnavailable() + ", announceStatus=" + (Object)((Object)this.getAnnounceStatus()) + ")";
        }
    }

    static enum ChannelFilter {
        WITH_TEMPORARY_UNAVAILABLE,
        WITHOUT_TEMPORARY_UNAVAILABLE;

    }

    private static class TemporaryUnavailableItem {
        private String item;
        private Date timestamp;

        public String getItem() {
            return this.item;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setItem(String item) {
            this.item = item;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemporaryUnavailableItem)) {
                return false;
            }
            TemporaryUnavailableItem other = (TemporaryUnavailableItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$item = this.getItem();
            String other$item = other.getItem();
            if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
                return false;
            }
            Date this$timestamp = this.getTimestamp();
            Date other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TemporaryUnavailableItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $item = this.getItem();
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            Date $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        public String toString() {
            return "StateManager.TemporaryUnavailableItem(item=" + this.getItem() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public TemporaryUnavailableItem(String item, Date timestamp) {
            this.item = item;
            this.timestamp = timestamp;
        }
    }
}

