/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.remoteaction;

import com.pubnub.api.PubNubException;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.endpoints.remoteaction.RemoteActionFactory;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import org.jetbrains.annotations.NotNull;

public class ComposableRemoteAction<T, U>
implements RemoteAction<U> {
    private final RemoteAction<T> remoteAction;
    private final RemoteActionFactory<T, U> nextRemoteActionFactory;
    private Boolean checkpoint;
    private RemoteAction<U> nextRemoteAction = null;
    private Boolean isCancelled = false;

    public ComposableRemoteAction(RemoteAction<T> remoteAction, RemoteActionFactory<T, U> nextRemoteActionFactory, Boolean checkpoint) {
        this.remoteAction = remoteAction;
        this.nextRemoteActionFactory = nextRemoteActionFactory;
        this.checkpoint = checkpoint;
    }

    public static <T> ComposableBuilder<T> firstDo(RemoteAction<T> remoteAction) {
        return new ComposableBuilder<T>(remoteAction);
    }

    public <Y> ComposableRemoteAction<U, Y> then(RemoteActionFactory<U, Y> factory) {
        return new ComposableRemoteAction<U, Y>(this, factory, false);
    }

    public synchronized ComposableRemoteAction<T, U> checkpoint() {
        this.checkpoint = true;
        return this;
    }

    @Override
    public U sync() throws PubNubException {
        T result = this.remoteAction.sync();
        return this.nextRemoteActionFactory.create(result).sync();
    }

    @Override
    public void async(@NotNull PNCallback<U> callback) {
        this.remoteAction.async((Output r, PNStatus s) -> {
            if (s.isError()) {
                callback.onResponse(null, this.switchRetryReceiver(s));
            } else {
                try {
                    ComposableRemoteAction composableRemoteAction = this;
                    synchronized (composableRemoteAction) {
                        if (!this.isCancelled.booleanValue()) {
                            RemoteAction<U> newNextRemoteAction = this.nextRemoteActionFactory.create(r);
                            this.nextRemoteAction = newNextRemoteAction;
                            newNextRemoteAction.async((Output r2, PNStatus s2) -> {
                                if (s2.isError()) {
                                    callback.onResponse(null, this.switchRetryReceiver(s2));
                                } else {
                                    callback.onResponse(r2, this.switchRetryReceiver(s2));
                                }
                            });
                        }
                    }
                }
                catch (PubNubException ex) {
                    callback.onResponse(null, PNStatus.builder().category(PNStatusCategory.PNBadRequestCategory).error(true).build());
                }
            }
        });
    }

    private PNStatus switchRetryReceiver(PNStatus s) {
        return s.toBuilder().executedEndpoint(this).build();
    }

    @Override
    public synchronized void retry() {
        if (this.checkpoint.booleanValue() && this.nextRemoteAction != null) {
            this.nextRemoteAction.retry();
        } else {
            this.remoteAction.retry();
        }
    }

    @Override
    public synchronized void silentCancel() {
        this.isCancelled = true;
        this.remoteAction.silentCancel();
        if (this.nextRemoteAction != null) {
            this.nextRemoteAction.silentCancel();
        }
    }

    public static class ComposableBuilder<T> {
        private final RemoteAction<T> remoteAction;
        private boolean checkpoint;

        public ComposableBuilder(RemoteAction<T> remoteAction) {
            this.remoteAction = remoteAction;
        }

        public <U> ComposableRemoteAction<T, U> then(RemoteActionFactory<T, U> nextRemoteActionFactory) {
            return new ComposableRemoteAction<T, U>(this.remoteAction, nextRemoteActionFactory, this.checkpoint);
        }

        public ComposableBuilder<T> checkpoint() {
            this.checkpoint = true;
            return this;
        }
    }
}

