/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.pubsub;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeEnvelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class Subscribe
extends Endpoint<SubscribeEnvelope, SubscribeEnvelope> {
    private static final Logger log = LoggerFactory.getLogger(Subscribe.class);
    static final int RATE_LIMIT_EXCEEDED = 429;
    static final int URI_TOO_LONG = 414;
    private List<String> channels = new ArrayList<String>();
    private List<String> channelGroups = new ArrayList<String>();
    private Long timetoken;
    private String filterExpression;
    private String region;
    private Object state;

    public Subscribe(PubNub pubnub, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, null, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channels.size() == 0 && this.channelGroups.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_AND_GROUP_MISSING).build();
        }
    }

    @Override
    public void async(final @NotNull PNCallback<SubscribeEnvelope> callback) {
        super.async(new PNCallback<SubscribeEnvelope>(){

            @Override
            public void onResponse(@Nullable SubscribeEnvelope result, @NotNull PNStatus status) {
                if (status.isError()) {
                    PNStatus maybeNewStatus = status.getStatusCode() == 400 && status.getErrorData().getInformation().contains("Filter syntax error") ? status.toBuilder().category(PNStatusCategory.PNMalformedFilterExpressionCategory).build() : (status.getStatusCode() == 414 ? status.toBuilder().category(PNStatusCategory.PNURITooLongCategory).build() : (status.getStatusCode() == 429 ? status.toBuilder().category(PNStatusCategory.PNRateLimitExceededCategory).build() : status));
                    callback.onResponse(result, maybeNewStatus);
                } else {
                    callback.onResponse(result, status);
                }
            }
        });
    }

    @Override
    protected Call<SubscribeEnvelope> doWork(Map<String, String> params) throws PubNubException {
        MapperManager mapper = this.getPubnub().getMapper();
        if (this.channelGroups.size() > 0) {
            params.put("channel-group", PubNubUtil.joinString(this.channelGroups, ","));
        }
        if (this.filterExpression != null && this.filterExpression.length() > 0) {
            params.put("filter-expr", PubNubUtil.urlEncode(this.filterExpression));
        }
        if (this.timetoken != null) {
            params.put("tt", this.timetoken.toString());
        }
        if (this.region != null) {
            params.put("tr", this.region);
        }
        String channelCSV = this.channels.size() > 0 ? PubNubUtil.joinString(this.channels, ",") : ",";
        params.put("heartbeat", String.valueOf(this.getPubnub().getConfiguration().getPresenceTimeout()));
        if (this.state != null) {
            String stringifiedState = mapper.toJson(this.state);
            stringifiedState = PubNubUtil.urlEncode(stringifiedState);
            params.put("state", stringifiedState);
        }
        params.putAll(this.encodeParams(params));
        return this.getRetrofit().getSubscribeService().subscribe(this.getPubnub().getConfiguration().getSubscribeKey(), channelCSV, params);
    }

    @Override
    protected SubscribeEnvelope createResponse(Response<SubscribeEnvelope> input) throws PubNubException {
        if (input.body() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        return (SubscribeEnvelope)input.body();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNSubscribeOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public Subscribe channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public Subscribe channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public Subscribe timetoken(Long timetoken) {
        this.timetoken = timetoken;
        return this;
    }

    public Subscribe filterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public Subscribe region(String region) {
        this.region = region;
        return this;
    }

    public Subscribe state(Object state) {
        this.state = state;
        return this;
    }
}

