/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.builder.dto.StateOperation;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.SubscriptionManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.models.server.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class SetState
extends Endpoint<Envelope<JsonElement>, PNSetStateResult> {
    private SubscriptionManager subscriptionManager;
    private List<String> channels;
    private List<String> channelGroups;
    private Object state;
    private String uuid;
    private boolean withHeartbeat;

    public SetState(PubNub pubnub, SubscriptionManager subscriptionManagerInstance, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
        this.subscriptionManager = subscriptionManagerInstance;
        this.channels = new ArrayList<String>();
        this.channelGroups = new ArrayList<String>();
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.state == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_STATE_MISSING).build();
        }
        String stringifiedState = this.getPubnub().getMapper().toJson(this.state);
        if (!this.isJsonObject(stringifiedState)) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_STATE_MUST_BE_JSON_OBJECT).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
        if (this.channels.size() == 0 && this.channelGroups.size() == 0) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_AND_GROUP_MISSING).build();
        }
        if (this.withHeartbeat && this.uuid != null && !this.uuid.equals(this.getPubnub().getConfiguration().getUserId().getValue())) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_USERID_CAN_NOT_BE_DIFFERENT_FROM_IN_CONFIGURATION_WHEN_WITHHEARTBEAT_TRUE).build();
        }
    }

    @Override
    protected Call<Envelope<JsonElement>> doWork(Map<String, String> params) throws PubNubException {
        String channelCSV;
        String selectedUUID = this.uuid != null ? this.uuid : this.getPubnub().getConfiguration().getUserId().getValue();
        this.storeStateChangeForSubscribe(selectedUUID);
        if (this.channelGroups.size() > 0) {
            params.put("channel-group", PubNubUtil.joinString(this.channelGroups, ","));
        }
        String string = channelCSV = this.channels.size() > 0 ? PubNubUtil.joinString(this.channels, ",") : ",";
        if (this.withHeartbeat) {
            params.put("heartbeat", String.valueOf(this.getPubnub().getConfiguration().getPresenceTimeout()));
            String encodedStateForChannelsAndGroups = this.composeStateParamValue();
            params.put("state", encodedStateForChannelsAndGroups);
            params.putAll(this.encodeParams(params));
            return this.getRetrofit().getPresenceService().heartbeat(this.getPubnub().getConfiguration().getSubscribeKey(), channelCSV, params);
        }
        String stringifiedState = this.getPubnub().getMapper().toJson(this.state);
        String encodedState = PubNubUtil.urlEncode(stringifiedState);
        params.put("state", encodedState);
        params.putAll(this.encodeParams(params));
        return this.getRetrofit().getExtendedPresenceService().setState(this.getPubnub().getConfiguration().getSubscribeKey(), channelCSV, selectedUUID, params);
    }

    @Override
    protected PNSetStateResult createResponse(Response<Envelope<JsonElement>> input) throws PubNubException {
        if (this.withHeartbeat) {
            String stateAsString = this.getPubnub().getMapper().toJson(this.state);
            JsonObject jsonObject = JsonParser.parseString((String)stateAsString).getAsJsonObject();
            PNSetStateResult.PNSetStateResultBuilder pnSetStateResult = PNSetStateResult.builder().state((JsonElement)jsonObject);
            return pnSetStateResult.build();
        }
        if (input.body() == null || ((Envelope)input.body()).getPayload() == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).build();
        }
        PNSetStateResult.PNSetStateResultBuilder pnSetStateResult = PNSetStateResult.builder().state((JsonElement)((Envelope)input.body()).getPayload());
        return pnSetStateResult.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNSetStateOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    private void storeStateChangeForSubscribe(String selectedUUID) {
        if (selectedUUID.equals(this.getPubnub().getConfiguration().getUserId().getValue())) {
            StateOperation stateOperation = StateOperation.builder().state(this.state).channels(this.channels).channelGroups(this.channelGroups).build();
            this.subscriptionManager.adaptStateBuilder(stateOperation);
        }
    }

    private String composeStateParamValue() throws PubNubException {
        HashMap<String, Object> stateParamValue = new HashMap<String, Object>();
        for (String channel : this.channels) {
            stateParamValue.put(channel, this.state);
        }
        for (String channelGroup : this.channelGroups) {
            stateParamValue.put(channelGroup, this.state);
        }
        String stringifiedStatePerChannel = this.getPubnub().getMapper().toJson(stateParamValue);
        String encodedStatePerChannel = PubNubUtil.urlEncode(stringifiedStatePerChannel);
        return encodedStatePerChannel;
    }

    private boolean isJsonObject(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    public SetState channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public SetState channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public SetState state(Object state) {
        this.state = state;
        return this;
    }

    public SetState uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public SetState withHeartbeat(boolean withHeartbeat) {
        this.withHeartbeat = withHeartbeat;
        return this;
    }
}

