/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.message_actions;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.message_actions.PNGetMessageActionsResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class GetMessageActions
extends Endpoint<PNGetMessageActionsResult, PNGetMessageActionsResult> {
    private String channel;
    private Long start;
    private Long end;
    private Integer limit;

    public GetMessageActions(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, TokenManager tokenManager) {
        super(pubnubInstance, telemetry, retrofitInstance, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return Collections.singletonList(this.channel);
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
    }

    @Override
    protected Call<PNGetMessageActionsResult> doWork(Map<String, String> params) {
        if (this.start != null) {
            params.put("start", Long.toString(this.start).toLowerCase());
        }
        if (this.end != null) {
            params.put("end", Long.toString(this.end).toLowerCase());
        }
        if (this.limit != null) {
            params.put("limit", String.valueOf(this.limit));
        }
        params.putAll(this.encodeParams(params));
        return this.getRetrofit().getMessageActionService().getMessageActions(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, params);
    }

    @Override
    protected PNGetMessageActionsResult createResponse(Response<PNGetMessageActionsResult> input) throws PubNubException {
        return (PNGetMessageActionsResult)input.body();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNGetMessageActions;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public GetMessageActions channel(String channel) {
        this.channel = channel;
        return this;
    }

    public GetMessageActions start(Long start) {
        this.start = start;
        return this;
    }

    public GetMessageActions end(Long end) {
        this.end = end;
        return this;
    }

    public GetMessageActions limit(Integer limit) {
        this.limit = limit;
        return this;
    }
}

