/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.files.GenerateUploadUrl;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.files.UploadFile;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.endpoints.remoteaction.ComposableRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.endpoints.remoteaction.RetryingRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.models.server.files.FileUploadRequestDetails;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class SendFile
implements RemoteAction<PNFileUploadResult> {
    private final RemoteAction<PNFileUploadResult> sendFileMultistepAction;
    private final String channel;
    private final String fileName;
    private final byte[] content;
    private final Exception byteContentReadingException;
    private final ExecutorService executorService;
    private final int fileMessagePublishRetryLimit;
    private Object message;
    private Object meta;
    private Integer ttl;
    private Boolean shouldStore;
    private String cipherKey;

    SendFile(Builder.SendFileRequiredParams requiredParams, GenerateUploadUrl.Factory generateUploadUrlFactory, BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<PublishFileMessage>>> publishFileMessageBuilder, UploadFile.Factory sendFileToS3Factory, ExecutorService executorService, int fileMessagePublishRetryLimit) {
        this.channel = requiredParams.channel();
        this.fileName = requiredParams.fileName();
        this.content = requiredParams.content();
        this.byteContentReadingException = requiredParams.byteReadingException;
        this.executorService = executorService;
        this.fileMessagePublishRetryLimit = fileMessagePublishRetryLimit;
        this.sendFileMultistepAction = this.sendFileComposedActions(generateUploadUrlFactory, publishFileMessageBuilder, sendFileToS3Factory);
    }

    @Override
    public PNFileUploadResult sync() throws PubNubException {
        this.validate();
        return this.sendFileMultistepAction.sync();
    }

    @Override
    public void async(@NotNull PNCallback<PNFileUploadResult> callback) {
        this.executorService.execute(() -> {
            try {
                this.validate();
                this.sendFileMultistepAction.async(callback);
            }
            catch (PubNubException ex) {
                callback.onResponse(null, PNStatus.builder().error(true).errorData(new PNErrorData(ex.getErrormsg(), ex)).build());
            }
        });
    }

    private void validate() throws PubNubException {
        if (this.channel == null || this.channel.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.byteContentReadingException != null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg(this.byteContentReadingException.getMessage()).build();
        }
        if (this.content == null) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("Content cannot be null").build();
        }
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_INVALID_ARGUMENTS).errormsg("File name cannot be null nor empty").build();
        }
    }

    private RemoteAction<PNFileUploadResult> sendFileComposedActions(GenerateUploadUrl.Factory generateUploadUrlFactory, BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<PublishFileMessage>>> publishFileMessageBuilder, UploadFile.Factory sendFileToS3Factory) {
        AtomicReference result = new AtomicReference();
        return ComposableRemoteAction.firstDo(generateUploadUrlFactory.create(this.channel, this.fileName)).then(res -> {
            result.set(res);
            return this.sendToS3((FileUploadRequestDetails)res, sendFileToS3Factory);
        }).checkpoint().then(res -> this.autoRetry(this.publishFileMessage(publishFileMessageBuilder, result), this.fileMessagePublishRetryLimit)).then(res -> this.mapPublishFileMessageToFileUpload(result, (PNPublishFileMessageResult)res));
    }

    private PublishFileMessage publishFileMessage(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<PublishFileMessage>>> publishFileMessageBuilder, AtomicReference<FileUploadRequestDetails> result) {
        return publishFileMessageBuilder.channel(this.channel).fileName(result.get().getData().getName()).fileId(result.get().getData().getId()).message(this.message).meta(this.meta).ttl(this.ttl).shouldStore(this.shouldStore);
    }

    private <T> RemoteAction<T> autoRetry(RemoteAction<T> remoteAction, int maxNumberOfRetries) {
        return RetryingRemoteAction.autoRetry(remoteAction, maxNumberOfRetries, PNOperationType.PNFileAction, this.executorService);
    }

    @NotNull
    private RemoteAction<PNFileUploadResult> mapPublishFileMessageToFileUpload(AtomicReference<FileUploadRequestDetails> result, PNPublishFileMessageResult res) {
        return MappingRemoteAction.map(res, pnPublishFileMessageResult -> new PNFileUploadResult(pnPublishFileMessageResult.getTimetoken(), 200, new PNBaseFile(((FileUploadRequestDetails)result.get()).getData().getId(), ((FileUploadRequestDetails)result.get()).getData().getName())));
    }

    @Override
    public void retry() {
        this.sendFileMultistepAction.retry();
    }

    @Override
    public void silentCancel() {
        this.sendFileMultistepAction.silentCancel();
    }

    private RemoteAction<Void> sendToS3(FileUploadRequestDetails result, UploadFile.Factory sendFileToS3Factory) {
        return sendFileToS3Factory.create(this.fileName, this.content, this.cipherKey, result);
    }

    public static Builder builder(PubNub pubnub, TelemetryManager telemetry, RetrofitManager retrofit, TokenManager tokenManager) {
        return new Builder(pubnub, telemetry, retrofit, tokenManager);
    }

    public SendFile message(Object message) {
        this.message = message;
        return this;
    }

    public SendFile meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public SendFile ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SendFile shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    public SendFile cipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public static class Builder
    implements BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>> {
        private final PubNub pubnub;
        private final TelemetryManager telemetry;
        private final RetrofitManager retrofit;
        private final TokenManager tokenManager;

        Builder(PubNub pubnub, TelemetryManager telemetry, RetrofitManager retrofit, TokenManager tokenManager) {
            this.pubnub = pubnub;
            this.telemetry = telemetry;
            this.retrofit = retrofit;
            this.tokenManager = tokenManager;
        }

        @Override
        public FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>> channel(String channel) {
            return new InnerBuilder(this.pubnub, this.telemetry, this.retrofit, this.tokenManager).channel(channel);
        }

        static class SendFileRequiredParams {
            private final String channel;
            private final String fileName;
            private final byte[] content;
            private final Exception byteReadingException;

            public SendFileRequiredParams(String channel, String fileName, byte[] content, Exception byteReadingException) {
                this.channel = channel;
                this.fileName = fileName;
                this.content = content;
                this.byteReadingException = byteReadingException;
            }

            public String channel() {
                return this.channel;
            }

            public String fileName() {
                return this.fileName;
            }

            public byte[] content() {
                return this.content;
            }

            public Exception byteReadingException() {
                return this.byteReadingException;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SendFileRequiredParams)) {
                    return false;
                }
                SendFileRequiredParams other = (SendFileRequiredParams)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$channel = this.channel();
                String other$channel = other.channel();
                if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                    return false;
                }
                String this$fileName = this.fileName();
                String other$fileName = other.fileName();
                if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                    return false;
                }
                if (!Arrays.equals(this.content(), other.content())) {
                    return false;
                }
                Exception this$byteReadingException = this.byteReadingException();
                Exception other$byteReadingException = other.byteReadingException();
                return !(this$byteReadingException == null ? other$byteReadingException != null : !this$byteReadingException.equals(other$byteReadingException));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SendFileRequiredParams;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $channel = this.channel();
                result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
                String $fileName = this.fileName();
                result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
                result = result * 59 + Arrays.hashCode(this.content());
                Exception $byteReadingException = this.byteReadingException();
                result = result * 59 + ($byteReadingException == null ? 43 : $byteReadingException.hashCode());
                return result;
            }

            public String toString() {
                return "SendFile.Builder.SendFileRequiredParams(channel=" + this.channel() + ", fileName=" + this.fileName() + ", content=" + Arrays.toString(this.content()) + ", byteReadingException=" + this.byteReadingException() + ")";
            }
        }

        public static class InnerBuilder
        implements BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>>,
        FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>>,
        FilesBuilderSteps.InputStreamStep<SendFile> {
            private final PubNub pubnub;
            private final RetrofitManager retrofit;
            private String channelValue;
            private String fileNameValue;
            private final PublishFileMessage.Builder publishFileMessageBuilder;
            private final UploadFile.Factory uploadFileFactory;
            private final GenerateUploadUrl.Factory generateUploadUrlFactory;

            private InnerBuilder(PubNub pubnub, TelemetryManager telemetry, RetrofitManager retrofit, TokenManager tokenManager) {
                this.pubnub = pubnub;
                this.retrofit = retrofit;
                this.publishFileMessageBuilder = PublishFileMessage.builder(pubnub, telemetry, retrofit, tokenManager);
                this.uploadFileFactory = new UploadFile.Factory(pubnub, retrofit);
                this.generateUploadUrlFactory = new GenerateUploadUrl.Factory(pubnub, telemetry, retrofit, tokenManager);
            }

            @Override
            public FilesBuilderSteps.FileNameStep<FilesBuilderSteps.InputStreamStep<SendFile>> channel(String channel) {
                this.channelValue = channel;
                return this;
            }

            @Override
            public FilesBuilderSteps.InputStreamStep<SendFile> fileName(String fileName) {
                this.fileNameValue = fileName;
                return this;
            }

            @Override
            public SendFile inputStream(InputStream inputStream) {
                try {
                    return new SendFile(new SendFileRequiredParams(this.channelValue, this.fileNameValue, PubNubUtil.readBytes(inputStream), null), this.generateUploadUrlFactory, this.publishFileMessageBuilder, this.uploadFileFactory, this.retrofit.getTransactionClientExecutorService(), this.pubnub.getConfiguration().getFileMessagePublishRetryLimit());
                }
                catch (IOException e) {
                    return new SendFile(new SendFileRequiredParams(this.channelValue, this.fileNameValue, null, e), this.generateUploadUrlFactory, this.publishFileMessageBuilder, this.uploadFileFactory, this.retrofit.getTransactionClientExecutorService(), this.pubnub.getConfiguration().getFileMessagePublishRetryLimit());
                }
            }
        }
    }
}

