/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access.builder;

import com.pubnub.api.UserId;
import com.pubnub.api.endpoints.access.GrantToken;
import com.pubnub.api.endpoints.access.builder.AbstractGrantTokenBuilder;
import com.pubnub.api.models.consumer.access_manager.sum.SpacePermissions;
import com.pubnub.api.models.consumer.access_manager.sum.UserPermissions;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GrantTokenEntitiesBuilder
extends AbstractGrantTokenBuilder<GrantTokenEntitiesBuilder> {
    public GrantTokenEntitiesBuilder(GrantToken grantToken) {
        super(grantToken);
    }

    public GrantTokenEntitiesBuilder meta(Object meta) {
        this.grantToken.meta(meta);
        return this;
    }

    public GrantTokenEntitiesBuilder spacesPermissions(List<SpacePermissions> spacesPermissions) {
        ArrayList<ChannelGrant> channelGrants = new ArrayList<ChannelGrant>();
        for (SpacePermissions spacePermission : spacesPermissions) {
            ChannelGrant channelGrant = spacePermission.isPatternResource() ? ChannelGrant.pattern(spacePermission.getId()) : ChannelGrant.name(spacePermission.getId());
            if (spacePermission.isRead()) {
                channelGrant.read();
            }
            if (spacePermission.isWrite()) {
                channelGrant.write();
            }
            if (spacePermission.isManage()) {
                channelGrant.manage();
            }
            if (spacePermission.isDelete()) {
                channelGrant.delete();
            }
            if (spacePermission.isUpdate()) {
                channelGrant.update();
            }
            if (spacePermission.isJoin()) {
                channelGrant.join();
            }
            if (spacePermission.isGet()) {
                channelGrant.get();
            }
            channelGrants.add(channelGrant);
        }
        this.grantToken.channels(channelGrants);
        return this;
    }

    public GrantTokenEntitiesBuilder usersPermissions(List<UserPermissions> usersPermissions) {
        ArrayList<UUIDGrant> uuidsGrants = new ArrayList<UUIDGrant>();
        for (UserPermissions userPermissions : usersPermissions) {
            UUIDGrant channelGrant = userPermissions.isPatternResource() ? UUIDGrant.pattern(userPermissions.getId()) : UUIDGrant.id(userPermissions.getId());
            if (userPermissions.isDelete()) {
                channelGrant.delete();
            }
            if (userPermissions.isUpdate()) {
                channelGrant.update();
            }
            if (userPermissions.isGet()) {
                channelGrant.get();
            }
            uuidsGrants.add(channelGrant);
        }
        this.grantToken.uuids(uuidsGrants);
        return this;
    }

    public GrantTokenEntitiesBuilder authorizedUserId(UserId userId) {
        this.grantToken.authorizedUUID(userId.getValue());
        return this;
    }

    @Override
    public GrantTokenEntitiesBuilder queryParam(Map queryParam) {
        this.grantToken.queryParam(queryParam);
        return this;
    }
}

