/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.history.PNMessageCountResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class MessageCounts
extends Endpoint<JsonElement, PNMessageCountResult> {
    private List<String> channels;
    private List<Long> channelsTimetoken;

    public MessageCounts(PubNub pubnub, TelemetryManager telemetryManager, RetrofitManager retrofit, TokenManager tokenManager) {
        super(pubnub, telemetryManager, retrofit, tokenManager);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return null;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channels == null || this.channels.isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING).build();
        }
        if (this.channelsTimetoken == null || this.channelsTimetoken.isEmpty() || this.channelsTimetoken.contains(null)) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_TIMETOKEN_MISSING).build();
        }
        if (this.channelsTimetoken.size() != this.channels.size() && this.channelsTimetoken.size() > 1) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_CHANNELS_TIMETOKEN_MISMATCH).build();
        }
    }

    @Override
    protected Call<JsonElement> doWork(Map<String, String> params) {
        if (this.channelsTimetoken.size() == 1) {
            params.put("timetoken", PubNubUtil.joinLong(this.channelsTimetoken, ","));
        } else {
            params.put("channelsTimetoken", PubNubUtil.joinLong(this.channelsTimetoken, ","));
        }
        return this.getRetrofit().getHistoryService().fetchCount(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtil.joinString(this.channels, ","), params);
    }

    @Override
    protected PNMessageCountResult createResponse(Response<JsonElement> input) throws PubNubException {
        PNMessageCountResult.PNMessageCountResultBuilder messageCountsData = PNMessageCountResult.builder();
        HashMap<String, Long> channelsMap = new HashMap<String, Long>();
        MapperManager mapper = this.getPubnub().getMapper();
        if (input.body() != null) {
            if (mapper.isJsonObject((JsonElement)input.body()) && mapper.hasField((JsonElement)input.body(), "channels")) {
                Iterator<Map.Entry<String, JsonElement>> it = mapper.getObjectIterator((JsonElement)input.body(), "channels");
                while (it.hasNext()) {
                    Map.Entry<String, JsonElement> entry = it.next();
                    channelsMap.put(entry.getKey(), entry.getValue().getAsLong());
                }
                messageCountsData.channels(channelsMap);
            } else {
                throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg("History is disabled").jso((JsonElement)input.body()).build();
            }
        }
        return messageCountsData.build();
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNMessageCountOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public MessageCounts channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public MessageCounts channelsTimetoken(List<Long> channelsTimetoken) {
        this.channelsTimetoken = channelsTimetoken;
        return this;
    }
}

