/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.callbacks.PNCallback;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.managers.token_manager.TokenManager;
import com.pubnub.api.models.consumer.PNErrorData;
import com.pubnub.api.models.consumer.PNStatus;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class Endpoint<Input, Output>
implements RemoteAction<Output> {
    private static final Logger log = Logger.getLogger(Endpoint.class.getName());
    private PubNub pubnub;
    private RetrofitManager retrofit;
    private TelemetryManager telemetryManager;
    private PNCallback<Output> cachedCallback;
    private Call<Input> call;
    private Map<String, String> queryParam;
    private boolean silenceFailures;
    private MapperManager mapper;
    private final TokenManager tokenManager;

    public Endpoint(PubNub pubnubInstance, TelemetryManager telemetry, RetrofitManager retrofitInstance, TokenManager tokenManager) {
        this.pubnub = pubnubInstance;
        this.retrofit = retrofitInstance;
        this.tokenManager = tokenManager;
        this.mapper = this.pubnub.getMapper();
        this.telemetryManager = telemetry;
    }

    @Override
    @Nullable
    public Output sync() throws PubNubException {
        Response serverResponse;
        this.validateParams();
        this.call = this.doWork(this.createBaseParams());
        try {
            serverResponse = this.call.execute();
        }
        catch (IOException e) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PARSING_ERROR).errormsg(e.toString()).affectedCall(this.call).cause(e).build();
        }
        if (this.isError(serverResponse)) {
            JsonElement responseBody;
            String responseBodyText;
            try {
                responseBodyText = serverResponse.errorBody().string();
            }
            catch (IOException e) {
                responseBodyText = "N/A";
            }
            try {
                responseBody = this.mapper.fromJson(responseBodyText, JsonElement.class);
            }
            catch (PubNubException e) {
                responseBody = null;
            }
            throw this.createPubNubException(serverResponse, responseBodyText, responseBody);
        }
        this.storeRequestLatency(serverResponse, this.getOperationType());
        Output response = this.createResponse(serverResponse);
        return response;
    }

    @Override
    public void async(final @NotNull PNCallback<Output> callback) {
        this.cachedCallback = callback;
        try {
            this.validateParams();
            this.call = this.doWork(this.createBaseParams());
        }
        catch (PubNubException pubnubException) {
            callback.onResponse(null, this.createStatusResponse(PNStatusCategory.PNBadRequestCategory, null, pubnubException, null, null));
            return;
        }
        this.call.enqueue(new Callback<Input>(){

            public void onResponse(Call<Input> performedCall, Response<Input> response) {
                Object callbackResponse;
                if (Endpoint.this.isError(response)) {
                    JsonElement responseBody;
                    String responseBodyText;
                    JsonElement responseBodyPayload = null;
                    ArrayList<String> affectedChannels = new ArrayList<String>();
                    ArrayList<String> affectedChannelGroups = new ArrayList<String>();
                    try (ResponseBody errorBody = response.errorBody();){
                        responseBodyText = errorBody != null ? errorBody.string() : "N/A";
                    }
                    catch (IOException e) {
                        responseBodyText = "N/A";
                    }
                    try {
                        responseBody = Endpoint.this.mapper.fromJson(responseBodyText, JsonElement.class);
                    }
                    catch (PubNubException e) {
                        responseBody = null;
                    }
                    if (responseBody != null && Endpoint.this.mapper.isJsonObject(responseBody) && Endpoint.this.mapper.hasField(responseBody, "payload")) {
                        responseBodyPayload = Endpoint.this.mapper.getField(responseBody, "payload");
                    }
                    PNStatusCategory pnStatusCategory = PNStatusCategory.PNUnknownCategory;
                    PubNubException ex = Endpoint.this.createPubNubException(response, responseBodyText, responseBody);
                    if (response.code() == 403) {
                        JsonElement objNode;
                        Iterator<JsonElement> it;
                        pnStatusCategory = PNStatusCategory.PNAccessDeniedCategory;
                        if (responseBodyPayload != null && Endpoint.this.mapper.hasField(responseBodyPayload, "channels")) {
                            it = Endpoint.this.mapper.getArrayIterator(responseBodyPayload, "channels");
                            while (it.hasNext()) {
                                objNode = it.next();
                                affectedChannels.add(Endpoint.this.mapper.elementToString(objNode));
                            }
                        }
                        if (responseBodyPayload != null && Endpoint.this.mapper.hasField(responseBodyPayload, "channel-groups")) {
                            it = Endpoint.this.mapper.getArrayIterator(responseBodyPayload, "channel-groups");
                            while (it.hasNext()) {
                                objNode = it.next();
                                String channelGroupName = Endpoint.this.mapper.elementToString(objNode).substring(0, 1).equals(":") ? Endpoint.this.mapper.elementToString(objNode).substring(1) : Endpoint.this.mapper.elementToString(objNode);
                                affectedChannelGroups.add(channelGroupName);
                            }
                        }
                    }
                    if (response.code() == 400) {
                        pnStatusCategory = PNStatusCategory.PNBadRequestCategory;
                    }
                    callback.onResponse(null, Endpoint.this.createStatusResponse(pnStatusCategory, response, ex, affectedChannels, affectedChannelGroups));
                    return;
                }
                Endpoint.this.storeRequestLatency(response, Endpoint.this.getOperationType());
                try {
                    callbackResponse = Endpoint.this.createResponse(response);
                }
                catch (PubNubException pubnubException) {
                    callback.onResponse(null, Endpoint.this.createStatusResponse(PNStatusCategory.PNMalformedResponseCategory, response, pubnubException, null, null));
                    return;
                }
                callback.onResponse(callbackResponse, Endpoint.this.createStatusResponse(PNStatusCategory.PNAcknowledgmentCategory, response, null, null, null));
            }

            public void onFailure(Call<Input> performedCall, Throwable throwable) {
                PNStatusCategory pnStatusCategory;
                if (Endpoint.this.silenceFailures) {
                    return;
                }
                PubNubException.PubNubExceptionBuilder pubnubException = PubNubException.builder().errormsg(throwable.getMessage()).cause(throwable);
                try {
                    throw throwable;
                }
                catch (UnknownHostException networkException) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_CONNECTION_NOT_SET);
                    pnStatusCategory = PNStatusCategory.PNUnexpectedDisconnectCategory;
                }
                catch (SocketException | SSLException exception) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_CONNECT_EXCEPTION);
                    pnStatusCategory = PNStatusCategory.PNUnexpectedDisconnectCategory;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_SOCKET_TIMEOUT);
                    pnStatusCategory = PNStatusCategory.PNTimeoutCategory;
                }
                catch (Throwable throwable1) {
                    pubnubException.pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR);
                    pnStatusCategory = performedCall.isCanceled() ? PNStatusCategory.PNCancelledCategory : PNStatusCategory.PNBadRequestCategory;
                }
                callback.onResponse(null, Endpoint.this.createStatusResponse(pnStatusCategory, null, pubnubException.build(), null, null));
            }
        });
    }

    private PubNubException createPubNubException(Response<Input> response, String responseBodyText, JsonElement responseBody) {
        if (response.code() == 413 || response.code() == 414) {
            return PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_PAYLOAD_TOO_LARGE).affectedCall(this.call).statusCode(response.code()).jso(responseBody).errormsg(PubNubErrorBuilder.PNERROBJ_PAYLOAD_TOO_LARGE.getMessage()).build();
        }
        return PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_HTTP_ERROR).errormsg(responseBodyText).jso(responseBody).statusCode(response.code()).affectedCall(this.call).build();
    }

    @Override
    public void retry() {
        this.silenceFailures = false;
        this.async(this.cachedCallback);
    }

    @Override
    public void silentCancel() {
        if (this.call != null && !this.call.isCanceled()) {
            this.silenceFailures = true;
            this.call.cancel();
        }
    }

    protected boolean isError(Response<Input> response) {
        return response.code() != 200;
    }

    private PNStatus createStatusResponse(PNStatusCategory category, Response<Input> response, Exception throwable, ArrayList<String> errorChannels, ArrayList<String> errorChannelGroups) {
        PNStatus.PNStatusBuilder pnStatus = PNStatus.builder();
        pnStatus.executedEndpoint(this);
        if (response == null || throwable != null) {
            pnStatus.error(true);
        }
        if (throwable != null) {
            PNErrorData pnErrorData = new PNErrorData(throwable.getMessage(), throwable);
            pnStatus.errorData(pnErrorData);
        }
        if (response != null) {
            pnStatus.statusCode(response.code());
            pnStatus.tlsEnabled(response.raw().request().url().isHttps());
            pnStatus.origin(response.raw().request().url().host());
            pnStatus.uuid(response.raw().request().url().queryParameter("uuid"));
            pnStatus.authKey(response.raw().request().url().queryParameter("auth"));
            pnStatus.clientRequest(response.raw().request());
        }
        pnStatus.operation(this.getOperationType());
        pnStatus.category(category);
        if (errorChannels != null && !errorChannels.isEmpty()) {
            pnStatus.affectedChannels(errorChannels);
        } else {
            pnStatus.affectedChannels(this.getAffectedChannels());
        }
        if (errorChannelGroups != null && !errorChannelGroups.isEmpty()) {
            pnStatus.affectedChannelGroups(errorChannelGroups);
        } else {
            pnStatus.affectedChannelGroups(this.getAffectedChannelGroups());
        }
        return pnStatus.build();
    }

    private void storeRequestLatency(Response response, PNOperationType type) {
        if (this.telemetryManager != null) {
            long latency = response.raw().receivedResponseAtMillis() - response.raw().sentRequestAtMillis();
            this.telemetryManager.storeLatency(latency, type);
        }
    }

    protected Map<String, String> createBaseParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.queryParam != null) {
            params.putAll(this.queryParam);
        }
        params.put("pnsdk", "PubNub-Java-Unified/".concat(this.pubnub.getVersion()));
        params.put("uuid", this.pubnub.getConfiguration().getUserId().getValue());
        if (this.pubnub.getConfiguration().isIncludeInstanceIdentifier()) {
            params.put("instanceid", this.pubnub.getInstanceId());
        }
        if (this.pubnub.getConfiguration().isIncludeRequestIdentifier()) {
            params.put("requestid", this.pubnub.getRequestId());
        }
        if (this.isAuthRequired()) {
            String token = this.tokenManager.getToken();
            if (token != null) {
                params.put("auth", token);
            } else if (this.pubnub.getConfiguration().getAuthKey() != null) {
                params.put("auth", this.pubnub.getConfiguration().getAuthKey());
            }
        }
        if (this.telemetryManager != null) {
            params.putAll(this.telemetryManager.operationsLatency());
        }
        return params;
    }

    protected Map<String, String> encodeParams(Map<String, String> params) {
        HashMap<String, String> encodedParams = new HashMap<String, String>(params);
        if (encodedParams.containsKey("auth")) {
            encodedParams.put("auth", PubNubUtil.urlEncode((String)encodedParams.get("auth")));
        }
        return encodedParams;
    }

    protected abstract List<String> getAffectedChannels();

    protected abstract List<String> getAffectedChannelGroups();

    protected abstract void validateParams() throws PubNubException;

    protected abstract Call<Input> doWork(Map<String, String> var1) throws PubNubException;

    protected abstract Output createResponse(Response<Input> var1) throws PubNubException;

    protected abstract PNOperationType getOperationType();

    protected abstract boolean isAuthRequired();

    protected PubNub getPubnub() {
        return this.pubnub;
    }

    protected RetrofitManager getRetrofit() {
        return this.retrofit;
    }

    public Endpoint<Input, Output> queryParam(Map<String, String> queryParam) {
        this.queryParam = queryParam;
        return this;
    }
}

