/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.v2.entities;

import com.pubnub.api.v2.callbacks.EventListener;
import com.pubnub.api.v2.endpoints.pubsub.PublishBuilder;
import com.pubnub.api.v2.endpoints.pubsub.SignalBuilder;
import com.pubnub.api.v2.entities.Channel;
import com.pubnub.api.v2.subscriptions.EmptyOptions;
import com.pubnub.api.v2.subscriptions.Subscription;
import com.pubnub.api.v2.subscriptions.SubscriptionOptions;
import com.pubnub.internal.PubNubImpl;
import com.pubnub.internal.v2.entities.BaseChannelImpl;
import com.pubnub.internal.v2.entities.ChannelGroupName;
import com.pubnub.internal.v2.entities.ChannelName;
import com.pubnub.internal.v2.subscription.SubscriptionImpl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/internal/v2/entities/ChannelImpl;", "Lcom/pubnub/internal/v2/entities/BaseChannelImpl;", "Lcom/pubnub/api/v2/callbacks/EventListener;", "Lcom/pubnub/api/v2/subscriptions/Subscription;", "Lcom/pubnub/api/v2/entities/Channel;", "pubnub", "Lcom/pubnub/internal/PubNubImpl;", "channelName", "", "(Lcom/pubnub/internal/PubNubImpl;Ljava/lang/String;)V", "pubNubImpl", "fire", "Lcom/pubnub/api/v2/endpoints/pubsub/PublishBuilder;", "message", "", "publish", "signal", "Lcom/pubnub/api/v2/endpoints/pubsub/SignalBuilder;", "subscription", "pubnub-gson-impl"})
public final class ChannelImpl
extends BaseChannelImpl<EventListener, Subscription>
implements Channel {
    @NotNull
    private final PubNubImpl pubNubImpl;

    public ChannelImpl(final @NotNull PubNubImpl pubnub, @NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)((Object)pubnub), (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        super(pubnub.getPubNubCore(), ChannelName.constructor-impl((String)channelName), (Function3)new Function3<Set<? extends ChannelName>, Set<? extends ChannelGroupName>, SubscriptionOptions, Subscription>(){

            @NotNull
            public final Subscription invoke(@NotNull Set<ChannelName> channels, @NotNull Set<ChannelGroupName> channelGroups, @NotNull SubscriptionOptions options) {
                Intrinsics.checkNotNullParameter(channels, (String)"channels");
                Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                return new SubscriptionImpl(pubnub, channels, channelGroups, options, null, null, 48, null);
            }
        }, null);
        this.pubNubImpl = pubnub;
    }

    @NotNull
    public Subscription subscription() {
        return (Subscription)this.subscription((SubscriptionOptions)EmptyOptions.INSTANCE);
    }

    @NotNull
    public PublishBuilder publish(@NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PublishBuilder publishBuilder = this.pubNubImpl.publish(message, this.getChannelName-P_C-G50());
        Intrinsics.checkNotNullExpressionValue((Object)publishBuilder, (String)"pubNubImpl.publish(message, channelName.id)");
        return publishBuilder;
    }

    @NotNull
    public SignalBuilder signal(@NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SignalBuilder signalBuilder = this.pubNubImpl.signal(message, this.getChannelName-P_C-G50());
        Intrinsics.checkNotNullExpressionValue((Object)signalBuilder, (String)"pubNubImpl.signal(message, channelName.id)");
        return signalBuilder;
    }

    @NotNull
    public PublishBuilder fire(@NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PublishBuilder publishBuilder = this.pubNubImpl.publish(message, this.getChannelName-P_C-G50()).replicate(false).shouldStore(Boolean.valueOf(false));
        Intrinsics.checkNotNullExpressionValue((Object)publishBuilder, (String)"pubNubImpl.publish(messa\u2026false).shouldStore(false)");
        return publishBuilder;
    }
}

