/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.push;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.push.RemoveAllPushChannelsForDevice;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushRemoveAllChannelsResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import org.jetbrains.annotations.NotNull;

public class RemoveAllPushChannelsForDeviceImpl
extends IdentityMappingEndpoint<PNPushRemoveAllChannelsResult>
implements RemoveAllPushChannelsForDevice {
    private PNPushType pushType;
    private String deviceId;
    private PNPushEnvironment environment = PNPushEnvironment.DEVELOPMENT;
    private String topic;

    public RemoveAllPushChannelsForDeviceImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNPushRemoveAllChannelsResult> createAction() {
        return this.pubnub.removeAllPushNotificationsFromDeviceWithPushToken(this.pushType, this.deviceId, this.topic, this.environment);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.pushType == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING);
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING);
        }
    }

    public RemoveAllPushChannelsForDeviceImpl pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public RemoveAllPushChannelsForDeviceImpl deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public RemoveAllPushChannelsForDeviceImpl environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public RemoveAllPushChannelsForDeviceImpl topic(String topic) {
        this.topic = topic;
        return this;
    }
}

