/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.memberships;

import com.pubnub.api.endpoints.objects_api.memberships.SetMemberships;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.membership.PNChannelMembership;
import com.pubnub.api.models.consumer.objects_api.membership.PNSetMembershipResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.models.consumer.objects.PNMembershipKey;
import com.pubnub.internal.models.consumer.objects.PNSortKey;
import com.pubnub.internal.models.consumer.objects.SortField;
import com.pubnub.internal.models.consumer.objects.membership.PNChannelDetailsLevel;
import com.pubnub.internal.models.consumer.objects.membership.PNChannelMembership;
import com.pubnub.internal.models.consumer.objects.membership.PNChannelMembershipArrayResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetMembershipsImpl
extends DelegatingEndpoint<PNChannelMembershipArrayResult, PNSetMembershipResult>
implements SetMemberships {
    private final Collection<PNChannelMembership> channels;
    private String uuid;
    private Integer limit;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private Include.PNChannelDetailsLevel includeChannel;

    public SetMembershipsImpl(@NotNull Collection<PNChannelMembership> channelMemberships, PubNubCore pubnubInstance) {
        super(pubnubInstance);
        this.channels = channelMemberships;
    }

    @Override
    @NotNull
    protected EndpointInterface<PNChannelMembershipArrayResult> createAction() {
        ArrayList<PNChannelMembership.Partial> channelList = new ArrayList<PNChannelMembership.Partial>(this.channels.size());
        for (PNChannelMembership channel : this.channels) {
            channelList.add(new PNChannelMembership.Partial(channel.getChannel().getId(), channel instanceof PNChannelMembership.ChannelWithCustom ? ((PNChannelMembership.ChannelWithCustom)channel).getCustom() : null, null));
        }
        return this.pubnub.setMemberships(channelList, this.uuid, this.limit, this.page, this.filter, SetMembershipsImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetMembershipsImpl.toInternal(this.includeChannel));
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNSetMembershipResult> mapResult(@NotNull ExtendedRemoteAction<PNChannelMembershipArrayResult> action) {
        return new MappingRemoteAction(action, PNSetMembershipResult::from);
    }

    @Nullable
    static PNChannelDetailsLevel toInternal(@Nullable Include.PNChannelDetailsLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        switch (detailLevel) {
            case CHANNEL: {
                return PNChannelDetailsLevel.CHANNEL;
            }
            case CHANNEL_WITH_CUSTOM: {
                return PNChannelDetailsLevel.CHANNEL_WITH_CUSTOM;
            }
        }
        throw new IllegalStateException("Unknown detail level: " + detailLevel);
    }

    static Collection<? extends com.pubnub.internal.models.consumer.objects.PNSortKey<PNMembershipKey>> toInternal(Collection<PNSortKey> sort) {
        ArrayList<Object> list = new ArrayList<Object>(sort.size());
        for (PNSortKey pnSortKey : sort) {
            PNMembershipKey key = null;
            switch (pnSortKey.getKey()) {
                case ID: {
                    key = PNMembershipKey.CHANNEL_ID;
                    break;
                }
                case NAME: {
                    key = PNMembershipKey.CHANNEL_NAME;
                    break;
                }
                case UPDATED: {
                    key = PNMembershipKey.CHANNEL_UPDATED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should never happen");
                }
            }
            if (pnSortKey.getDir().equals((Object)PNSortKey.Dir.ASC)) {
                list.add(new PNSortKey.PNAsc((SortField)key));
                continue;
            }
            list.add(new PNSortKey.PNDesc((SortField)key));
        }
        return list;
    }

    public SetMembershipsImpl uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public SetMembershipsImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public SetMembershipsImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public SetMembershipsImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public SetMembershipsImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public SetMembershipsImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public SetMembershipsImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public SetMembershipsImpl includeChannel(Include.PNChannelDetailsLevel includeChannel) {
        this.includeChannel = includeChannel;
        return this;
    }

    public static class Builder
    implements SetMemberships.Builder {
        private final PubNubCore pubnubInstance;

        public SetMemberships channelMemberships(@NotNull Collection<PNChannelMembership> channelMemberships) {
            return new SetMembershipsImpl(channelMemberships, this.pubnubInstance);
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

