/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.members;

import com.pubnub.api.endpoints.objects_api.members.RemoveChannelMembers;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.member.PNRemoveChannelMembersResult;
import com.pubnub.api.models.consumer.objects_api.member.PNUUID;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.endpoints.objects_api.members.SetChannelMembersImpl;
import com.pubnub.internal.models.consumer.objects.member.PNMemberArrayResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveChannelMembersImpl
extends DelegatingEndpoint<PNMemberArrayResult, PNRemoveChannelMembersResult>
implements RemoveChannelMembers {
    private Integer limit = null;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private final String channel;
    private final List<String> uuids;
    private Include.PNUUIDDetailsLevel includeUUID;

    public RemoveChannelMembersImpl(String channel, Collection<PNUUID> uuids, PubNubCore pubnubInstance) {
        super(pubnubInstance);
        this.channel = channel;
        this.uuids = new ArrayList<String>(uuids.size());
        for (PNUUID uuid : uuids) {
            this.uuids.add(uuid.getUuid().getId());
        }
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNRemoveChannelMembersResult> mapResult(@NotNull ExtendedRemoteAction<PNMemberArrayResult> action) {
        return new MappingRemoteAction(action, PNRemoveChannelMembersResult::from);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNMemberArrayResult> createAction() {
        return this.pubnub.removeChannelMembers(this.channel, this.uuids, this.limit, this.page, this.filter, SetChannelMembersImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetChannelMembersImpl.toInternal(this.includeUUID));
    }

    public RemoveChannelMembersImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public RemoveChannelMembersImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public RemoveChannelMembersImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public RemoveChannelMembersImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public RemoveChannelMembersImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public RemoveChannelMembersImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public RemoveChannelMembersImpl includeUUID(Include.PNUUIDDetailsLevel includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }

    public static class Builder
    implements RemoveChannelMembers.Builder {
        private final PubNubCore pubnubInstance;

        public ObjectsBuilderSteps.UUIDsStep<RemoveChannelMembers> channel(final String channel) {
            return new ObjectsBuilderSteps.UUIDsStep<RemoveChannelMembers>(){

                public RemoveChannelMembers uuids(@NotNull Collection<PNUUID> uuids) {
                    return new RemoveChannelMembersImpl(channel, uuids, pubnubInstance);
                }
            };
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

