/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.members;

import com.pubnub.api.endpoints.objects_api.members.GetChannelMembers;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.member.PNGetChannelMembersResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.endpoints.objects_api.members.SetChannelMembersImpl;
import com.pubnub.internal.models.consumer.objects.member.PNMemberArrayResult;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GetChannelMembersImpl
extends DelegatingEndpoint<PNMemberArrayResult, PNGetChannelMembersResult>
implements GetChannelMembers {
    private final String channel;
    private Integer limit = null;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private Include.PNUUIDDetailsLevel includeUUID;

    public GetChannelMembersImpl(String channel, PubNubCore pubnubInstance) {
        super(pubnubInstance);
        this.channel = channel;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNGetChannelMembersResult> mapResult(@NotNull ExtendedRemoteAction<PNMemberArrayResult> action) {
        return new MappingRemoteAction(action, PNGetChannelMembersResult::from);
    }

    @Override
    protected EndpointInterface<PNMemberArrayResult> createAction() {
        return this.pubnub.getChannelMembers(this.channel, this.limit, this.page, this.filter, SetChannelMembersImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetChannelMembersImpl.toInternal(this.includeUUID));
    }

    public GetChannelMembersImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public GetChannelMembersImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public GetChannelMembersImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public GetChannelMembersImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public GetChannelMembersImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public GetChannelMembersImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public GetChannelMembersImpl includeUUID(Include.PNUUIDDetailsLevel includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }

    public static class Builder
    implements GetChannelMembers.Builder {
        private final PubNubCore pubnubInstance;

        public GetChannelMembers channel(String channel) {
            return new GetChannelMembersImpl(channel, this.pubnubInstance);
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

