/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.files.GetFileUrl;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.models.consumer.files.PNFileUrlResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import com.pubnub.internal.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import org.jetbrains.annotations.NotNull;

public class GetFileUrlImpl
extends IdentityMappingEndpoint<PNFileUrlResult>
implements GetFileUrl {
    private final String channel;
    private final String fileId;
    private final String fileName;

    public GetFileUrlImpl(String channel, String fileId, String fileName, PubNubCore pubnub) {
        super(pubnub);
        this.channel = channel;
        this.fileId = fileId;
        this.fileName = fileName;
    }

    @Override
    @NotNull
    protected EndpointInterface<PNFileUrlResult> createAction() {
        return this.pubnub.getFileUrl(this.channel, this.fileName, this.fileId);
    }

    public static Builder builder(PubNubCore pubNub) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new GetFileUrlImpl((String)channel, (String)fileName, (String)fileId, pubNub)));
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<GetFileUrl>
    implements GetFileUrl.Builder {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<GetFileUrl>>> builder) {
            super(builder);
        }
    }
}

