/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.files.DownloadFile;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.models.consumer.files.PNDownloadFileResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import com.pubnub.internal.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import org.jetbrains.annotations.NotNull;

public class DownloadFileImpl
extends IdentityMappingEndpoint<PNDownloadFileResult>
implements DownloadFile {
    private final String channel;
    private final String fileId;
    private final String fileName;
    private String cipherKey;

    public DownloadFileImpl(String channel, String fileId, String fileName, PubNubCore pubnub) {
        super(pubnub);
        this.channel = channel;
        this.fileId = fileId;
        this.fileName = fileName;
    }

    @Override
    @NotNull
    protected EndpointInterface<PNDownloadFileResult> createAction() {
        return this.pubnub.downloadFile(this.channel, this.fileName, this.fileId, this.cipherKey);
    }

    public static Builder builder(PubNubCore pubnub) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new DownloadFileImpl((String)channel, (String)fileId, (String)fileName, pubnub)));
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public DownloadFileImpl cipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<DownloadFile>
    implements DownloadFile.Builder {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<DownloadFile>>> builder) {
            super(builder);
        }
    }
}

