/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.access;

import com.pubnub.api.PubNubException;
import com.pubnub.api.UserId;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.access.GrantToken;
import com.pubnub.api.endpoints.access.builder.GrantTokenBuilder;
import com.pubnub.api.endpoints.access.builder.GrantTokenEntitiesBuilder;
import com.pubnub.api.endpoints.access.builder.GrantTokenObjectsBuilder;
import com.pubnub.api.models.consumer.access_manager.sum.SpacePermissions;
import com.pubnub.api.models.consumer.access_manager.sum.UserPermissions;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNGrantTokenResult;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GrantTokenImpl
extends IdentityMappingEndpoint<PNGrantTokenResult>
implements GrantToken,
GrantTokenBuilder,
GrantTokenEntitiesBuilder,
GrantTokenObjectsBuilder {
    private Integer ttl;
    private Object meta;
    private String authorizedUUID;
    private List<ChannelGrant> channels = Collections.emptyList();
    private List<ChannelGroupGrant> channelGroups = Collections.emptyList();
    private List<UUIDGrant> uuids = Collections.emptyList();

    public GrantTokenImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.ttl == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_TTL_MISSING);
        }
    }

    @Override
    @NotNull
    protected EndpointInterface<PNGrantTokenResult> createAction() {
        return this.pubnub.grantToken(this.ttl.intValue(), this.meta, this.authorizedUUID, this.toInternalChannels(this.channels), this.toInternalChannelGroups(this.channelGroups), this.toInternalUuids(this.uuids));
    }

    public GrantTokenEntitiesBuilder spacesPermissions(List<SpacePermissions> spacesPermissions) {
        ArrayList<ChannelGrant> channelGrants = new ArrayList<ChannelGrant>();
        for (SpacePermissions spacePermission : spacesPermissions) {
            ChannelGrant channelGrant = spacePermission.isPatternResource() ? ChannelGrant.pattern((String)spacePermission.getId()) : ChannelGrant.name((String)spacePermission.getId());
            if (spacePermission.isRead()) {
                channelGrant.read();
            }
            if (spacePermission.isWrite()) {
                channelGrant.write();
            }
            if (spacePermission.isManage()) {
                channelGrant.manage();
            }
            if (spacePermission.isDelete()) {
                channelGrant.delete();
            }
            if (spacePermission.isUpdate()) {
                channelGrant.update();
            }
            if (spacePermission.isJoin()) {
                channelGrant.join();
            }
            if (spacePermission.isGet()) {
                channelGrant.get();
            }
            channelGrants.add(channelGrant);
        }
        this.channels(channelGrants);
        return this;
    }

    public GrantTokenEntitiesBuilder usersPermissions(List<UserPermissions> usersPermissions) {
        ArrayList<UUIDGrant> uuidsGrants = new ArrayList<UUIDGrant>();
        for (UserPermissions userPermissions : usersPermissions) {
            UUIDGrant channelGrant = userPermissions.isPatternResource() ? UUIDGrant.pattern((String)userPermissions.getId()) : UUIDGrant.id((String)userPermissions.getId());
            if (userPermissions.isDelete()) {
                channelGrant.delete();
            }
            if (userPermissions.isUpdate()) {
                channelGrant.update();
            }
            if (userPermissions.isGet()) {
                channelGrant.get();
            }
            uuidsGrants.add(channelGrant);
        }
        this.uuids(uuidsGrants);
        return this;
    }

    public GrantTokenEntitiesBuilder authorizedUserId(UserId userId) {
        this.authorizedUUID(userId.getValue());
        return this;
    }

    private List<? extends com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant> toInternalChannels(List<ChannelGrant> channels) {
        ArrayList<com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant> list = new ArrayList<com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant>(channels.size());
        for (ChannelGrant channel : channels) {
            list.add(GrantTokenImpl.toInternal(channel));
        }
        return list;
    }

    private List<? extends com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant> toInternalChannelGroups(List<ChannelGroupGrant> channels) {
        ArrayList<com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant> list = new ArrayList<com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant>(channels.size());
        for (ChannelGroupGrant channel : channels) {
            list.add(GrantTokenImpl.toInternal(channel));
        }
        return list;
    }

    private List<? extends com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant> toInternalUuids(List<UUIDGrant> uuids) {
        ArrayList<com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant> list = new ArrayList<com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant>(uuids.size());
        for (UUIDGrant uuid : uuids) {
            list.add(GrantTokenImpl.toInternal(uuid));
        }
        return list;
    }

    static com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant toInternal(ChannelGrant grant) {
        if (grant.isPatternResource()) {
            return com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant.Companion.pattern(grant.getId(), grant.isRead(), grant.isWrite(), grant.isManage(), grant.isDelete(), grant.isCreate(), grant.isGet(), grant.isJoin(), grant.isUpdate());
        }
        return com.pubnub.internal.models.consumer.access_manager.v3.ChannelGrant.Companion.name(grant.getId(), grant.isRead(), grant.isWrite(), grant.isManage(), grant.isDelete(), grant.isCreate(), grant.isGet(), grant.isJoin(), grant.isUpdate());
    }

    static com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant toInternal(ChannelGroupGrant grant) {
        if (grant.isPatternResource()) {
            return com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant.Companion.pattern(grant.getId(), grant.isRead(), grant.isManage());
        }
        return com.pubnub.internal.models.consumer.access_manager.v3.ChannelGroupGrant.Companion.id(grant.getId(), grant.isRead(), grant.isManage());
    }

    static com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant toInternal(UUIDGrant grant) {
        if (grant.isPatternResource()) {
            return com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant.Companion.pattern(grant.getId(), grant.isGet(), grant.isUpdate(), grant.isDelete());
        }
        return com.pubnub.internal.models.consumer.access_manager.v3.UUIDGrant.Companion.id(grant.getId(), grant.isGet(), grant.isUpdate(), grant.isDelete());
    }

    public GrantTokenImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public GrantTokenImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public GrantTokenImpl authorizedUUID(String authorizedUUID) {
        this.authorizedUUID = authorizedUUID;
        return this;
    }

    public GrantTokenImpl channels(List<ChannelGrant> channels) {
        this.channels = channels;
        return this;
    }

    public GrantTokenImpl channelGroups(List<ChannelGroupGrant> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public GrantTokenImpl uuids(List<UUIDGrant> uuids) {
        this.uuids = uuids;
        return this;
    }
}

