/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PresenceBuilder;
import com.pubnub.api.builder.SubscribeBuilder;
import com.pubnub.api.builder.UnsubscribeBuilder;
import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.endpoints.DeleteMessages;
import com.pubnub.api.endpoints.FetchMessages;
import com.pubnub.api.endpoints.History;
import com.pubnub.api.endpoints.MessageCounts;
import com.pubnub.api.endpoints.Time;
import com.pubnub.api.endpoints.access.Grant;
import com.pubnub.api.endpoints.access.RevokeToken;
import com.pubnub.api.endpoints.access.builder.GrantTokenBuilder;
import com.pubnub.api.endpoints.channel_groups.AddChannelChannelGroup;
import com.pubnub.api.endpoints.channel_groups.AllChannelsChannelGroup;
import com.pubnub.api.endpoints.channel_groups.DeleteChannelGroup;
import com.pubnub.api.endpoints.channel_groups.ListAllChannelGroup;
import com.pubnub.api.endpoints.channel_groups.RemoveChannelChannelGroup;
import com.pubnub.api.endpoints.files.DeleteFile;
import com.pubnub.api.endpoints.files.DownloadFile;
import com.pubnub.api.endpoints.files.GetFileUrl;
import com.pubnub.api.endpoints.files.ListFiles;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.files.SendFile;
import com.pubnub.api.endpoints.message_actions.AddMessageAction;
import com.pubnub.api.endpoints.message_actions.GetMessageActions;
import com.pubnub.api.endpoints.message_actions.RemoveMessageAction;
import com.pubnub.api.endpoints.objects_api.channel.GetAllChannelsMetadata;
import com.pubnub.api.endpoints.objects_api.channel.GetChannelMetadata;
import com.pubnub.api.endpoints.objects_api.channel.RemoveChannelMetadata;
import com.pubnub.api.endpoints.objects_api.channel.SetChannelMetadata;
import com.pubnub.api.endpoints.objects_api.members.GetChannelMembers;
import com.pubnub.api.endpoints.objects_api.members.ManageChannelMembers;
import com.pubnub.api.endpoints.objects_api.members.RemoveChannelMembers;
import com.pubnub.api.endpoints.objects_api.members.SetChannelMembers;
import com.pubnub.api.endpoints.objects_api.memberships.GetMemberships;
import com.pubnub.api.endpoints.objects_api.memberships.ManageMemberships;
import com.pubnub.api.endpoints.objects_api.memberships.RemoveMemberships;
import com.pubnub.api.endpoints.objects_api.memberships.SetMemberships;
import com.pubnub.api.endpoints.objects_api.uuid.GetAllUUIDMetadata;
import com.pubnub.api.endpoints.objects_api.uuid.GetUUIDMetadata;
import com.pubnub.api.endpoints.objects_api.uuid.RemoveUUIDMetadata;
import com.pubnub.api.endpoints.objects_api.uuid.SetUUIDMetadata;
import com.pubnub.api.endpoints.presence.GetState;
import com.pubnub.api.endpoints.presence.HereNow;
import com.pubnub.api.endpoints.presence.SetState;
import com.pubnub.api.endpoints.presence.WhereNow;
import com.pubnub.api.endpoints.pubsub.Publish;
import com.pubnub.api.endpoints.pubsub.Signal;
import com.pubnub.api.endpoints.push.AddChannelsToPush;
import com.pubnub.api.endpoints.push.ListPushProvisions;
import com.pubnub.api.endpoints.push.RemoveAllPushChannelsForDevice;
import com.pubnub.api.endpoints.push.RemoveChannelsFromPush;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.api.v2.callbacks.EventListener;
import com.pubnub.api.v2.callbacks.StatusListener;
import com.pubnub.api.v2.endpoints.pubsub.PublishBuilder;
import com.pubnub.api.v2.endpoints.pubsub.SignalBuilder;
import com.pubnub.api.v2.entities.Channel;
import com.pubnub.api.v2.entities.ChannelGroup;
import com.pubnub.api.v2.entities.ChannelMetadata;
import com.pubnub.api.v2.entities.UserMetadata;
import com.pubnub.api.v2.subscriptions.Subscription;
import com.pubnub.api.v2.subscriptions.SubscriptionSet;
import com.pubnub.internal.BasePubNubImpl;
import com.pubnub.internal.callbacks.DelegatingStatusListener;
import com.pubnub.internal.callbacks.DelegatingSubscribeCallback;
import com.pubnub.internal.callbacks.SubscribeCallback;
import com.pubnub.internal.endpoints.DeleteMessagesImpl;
import com.pubnub.internal.endpoints.FetchMessagesImpl;
import com.pubnub.internal.endpoints.HistoryImpl;
import com.pubnub.internal.endpoints.MessageCountsImpl;
import com.pubnub.internal.endpoints.TimeImpl;
import com.pubnub.internal.endpoints.access.GrantImpl;
import com.pubnub.internal.endpoints.access.GrantTokenImpl;
import com.pubnub.internal.endpoints.access.RevokeTokenImpl;
import com.pubnub.internal.endpoints.channel_groups.AddChannelChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.AllChannelsChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.DeleteChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.ListAllChannelGroupImpl;
import com.pubnub.internal.endpoints.channel_groups.RemoveChannelChannelGroupImpl;
import com.pubnub.internal.endpoints.files.DeleteFileImpl;
import com.pubnub.internal.endpoints.files.DownloadFileImpl;
import com.pubnub.internal.endpoints.files.GetFileUrlImpl;
import com.pubnub.internal.endpoints.files.ListFilesImpl;
import com.pubnub.internal.endpoints.files.PublishFileMessageImpl;
import com.pubnub.internal.endpoints.files.SendFileImpl;
import com.pubnub.internal.endpoints.message_actions.AddMessageActionImpl;
import com.pubnub.internal.endpoints.message_actions.GetMessageActionsImpl;
import com.pubnub.internal.endpoints.message_actions.RemoveMessageActionImpl;
import com.pubnub.internal.endpoints.objects_api.channel.GetAllChannelsMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.channel.GetChannelMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.channel.RemoveChannelMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.channel.SetChannelMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.members.GetChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.members.ManageChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.members.RemoveChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.members.SetChannelMembersImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.GetMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.ManageMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.RemoveMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.memberships.SetMembershipsImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.GetAllUUIDMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.GetUUIDMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.RemoveUUIDMetadataImpl;
import com.pubnub.internal.endpoints.objects_api.uuid.SetUUIDMetadataImpl;
import com.pubnub.internal.endpoints.presence.GetStateImpl;
import com.pubnub.internal.endpoints.presence.HereNowImpl;
import com.pubnub.internal.endpoints.presence.SetStateImpl;
import com.pubnub.internal.endpoints.presence.WhereNowImpl;
import com.pubnub.internal.endpoints.pubsub.PublishImpl;
import com.pubnub.internal.endpoints.pubsub.SignalImpl;
import com.pubnub.internal.endpoints.push.AddChannelsToPushImpl;
import com.pubnub.internal.endpoints.push.ListPushProvisionsImpl;
import com.pubnub.internal.endpoints.push.RemoveAllPushChannelsForDeviceImpl;
import com.pubnub.internal.endpoints.push.RemoveChannelsFromPushImpl;
import com.pubnub.internal.v2.callbacks.DelegatingEventListener;
import com.pubnub.internal.v2.callbacks.EventListenerCore;
import com.pubnub.internal.v2.callbacks.StatusListenerCore;
import com.pubnub.internal.v2.entities.ChannelGroupImpl;
import com.pubnub.internal.v2.entities.ChannelImpl;
import com.pubnub.internal.v2.entities.ChannelMetadataImpl;
import com.pubnub.internal.v2.entities.UserMetadataImpl;
import com.pubnub.internal.v2.subscription.SubscriptionSetImpl;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PubNubImpl
extends BasePubNubImpl<EventListener, Subscription, Channel, ChannelGroup, ChannelMetadata, UserMetadata, SubscriptionSet, StatusListener>
implements PubNub {
    private static final String PNSDK_PUBNUB_JAVA = "PubNub-Java";
    @NotNull
    private final BasePNConfiguration configuration;

    public PubNubImpl(@NotNull BasePNConfiguration configuration) {
        super(configuration, PNSDK_PUBNUB_JAVA);
        this.configuration = configuration;
    }

    @NotNull
    public BasePNConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public SubscribeBuilder subscribe() {
        return new SubscribeBuilder(this.getPubNubCore());
    }

    @NotNull
    public UnsubscribeBuilder unsubscribe() {
        return new UnsubscribeBuilder(this.getPubNubCore());
    }

    @NotNull
    public PresenceBuilder presence() {
        return new PresenceBuilder(this.getPubNubCore());
    }

    @NotNull
    public AddChannelsToPush addPushNotificationsOnChannels() {
        return new AddChannelsToPushImpl(this.getPubNubCore());
    }

    @NotNull
    public RemoveChannelsFromPush removePushNotificationsFromChannels() {
        return new RemoveChannelsFromPushImpl(this.getPubNubCore());
    }

    @NotNull
    public RemoveAllPushChannelsForDevice removeAllPushNotificationsFromDeviceWithPushToken() {
        return new RemoveAllPushChannelsForDeviceImpl(this.getPubNubCore());
    }

    @NotNull
    public ListPushProvisions auditPushChannelProvisions() {
        return new ListPushProvisionsImpl(this.getPubNubCore());
    }

    @NotNull
    public WhereNow whereNow() {
        return new WhereNowImpl(this.getPubNubCore());
    }

    @NotNull
    public HereNow hereNow() {
        return new HereNowImpl(this.getPubNubCore());
    }

    @NotNull
    public Time time() {
        return new TimeImpl(this.getPubNubCore());
    }

    @NotNull
    public History history() {
        return new HistoryImpl(this.getPubNubCore());
    }

    @NotNull
    public FetchMessages fetchMessages() {
        return new FetchMessagesImpl(this.getPubNubCore());
    }

    @NotNull
    public DeleteMessages deleteMessages() {
        return new DeleteMessagesImpl(this.getPubNubCore());
    }

    @NotNull
    public MessageCounts messageCounts() {
        return new MessageCountsImpl(this.getPubNubCore());
    }

    @NotNull
    public Grant grant() {
        return new GrantImpl(this.getPubNubCore());
    }

    @NotNull
    public GrantTokenBuilder grantToken() {
        return new GrantTokenImpl(this.getPubNubCore());
    }

    @NotNull
    public GrantTokenBuilder grantToken(int ttl) {
        return new GrantTokenImpl(this.getPubNubCore()).ttl(ttl);
    }

    @NotNull
    public RevokeToken revokeToken() {
        return new RevokeTokenImpl(this.getPubNubCore());
    }

    @NotNull
    public GetState getPresenceState() {
        return new GetStateImpl(this.getPubNubCore());
    }

    @NotNull
    public SetState setPresenceState() {
        return new SetStateImpl(this.getPubNubCore());
    }

    @NotNull
    public Publish publish() {
        return new PublishImpl(this.getPubNubCore());
    }

    @NotNull
    public PublishBuilder publish(@NotNull Object message, @NotNull String channel) {
        return new PublishImpl(this.getPubNubCore()).message(message).channel(channel);
    }

    @NotNull
    public Signal signal() {
        return new SignalImpl(this.getPubNubCore());
    }

    @NotNull
    public SignalBuilder signal(@NotNull Object message, @NotNull String channel) {
        return new SignalImpl(this.getPubNubCore()).message(message).channel(channel);
    }

    @NotNull
    public ListAllChannelGroup listAllChannelGroups() {
        return new ListAllChannelGroupImpl(this.getPubNubCore());
    }

    @NotNull
    public AllChannelsChannelGroup listChannelsForChannelGroup() {
        return new AllChannelsChannelGroupImpl(this.getPubNubCore());
    }

    @NotNull
    public AddChannelChannelGroup addChannelsToChannelGroup() {
        return new AddChannelChannelGroupImpl(this.getPubNubCore());
    }

    @NotNull
    public RemoveChannelChannelGroup removeChannelsFromChannelGroup() {
        return new RemoveChannelChannelGroupImpl(this.getPubNubCore());
    }

    @NotNull
    public DeleteChannelGroup deleteChannelGroup() {
        return new DeleteChannelGroupImpl(this.getPubNubCore());
    }

    public SetUUIDMetadata setUUIDMetadata() {
        return new SetUUIDMetadataImpl(this.getPubNubCore());
    }

    @NotNull
    public GetAllUUIDMetadata getAllUUIDMetadata() {
        return new GetAllUUIDMetadataImpl(this.getPubNubCore());
    }

    @NotNull
    public GetUUIDMetadata getUUIDMetadata() {
        return new GetUUIDMetadataImpl(this.getPubNubCore());
    }

    @NotNull
    public RemoveUUIDMetadata removeUUIDMetadata() {
        return new RemoveUUIDMetadataImpl(this.getPubNubCore());
    }

    public SetChannelMetadata.Builder setChannelMetadata() {
        return new SetChannelMetadataImpl.Builder(this.getPubNubCore());
    }

    @NotNull
    public GetAllChannelsMetadata getAllChannelsMetadata() {
        return new GetAllChannelsMetadataImpl(this.getPubNubCore());
    }

    @NotNull
    public GetChannelMetadata.Builder getChannelMetadata() {
        return new GetChannelMetadataImpl.Builder(this.getPubNubCore());
    }

    public RemoveChannelMetadata.Builder removeChannelMetadata() {
        return new RemoveChannelMetadataImpl.Builder(this.getPubNubCore());
    }

    @NotNull
    public GetMemberships getMemberships() {
        return new GetMembershipsImpl(this.getPubNubCore());
    }

    @NotNull
    public SetMemberships.Builder setMemberships() {
        return new SetMembershipsImpl.Builder(this.getPubNubCore());
    }

    public RemoveMemberships.Builder removeMemberships() {
        return new RemoveMembershipsImpl.Builder(this.getPubNubCore());
    }

    public ManageMemberships.Builder manageMemberships() {
        return new ManageMembershipsImpl.Builder(this.getPubNubCore());
    }

    public GetChannelMembers.Builder getChannelMembers() {
        return new GetChannelMembersImpl.Builder(this.getPubNubCore());
    }

    public SetChannelMembers.Builder setChannelMembers() {
        return new SetChannelMembersImpl.Builder(this.getPubNubCore());
    }

    public RemoveChannelMembers.Builder removeChannelMembers() {
        return new RemoveChannelMembersImpl.Builder(this.getPubNubCore());
    }

    public ManageChannelMembers.Builder manageChannelMembers() {
        return new ManageChannelMembersImpl.Builder(this.getPubNubCore());
    }

    @NotNull
    public AddMessageAction addMessageAction() {
        return new AddMessageActionImpl(this.getPubNubCore());
    }

    @NotNull
    public GetMessageActions getMessageActions() {
        return new GetMessageActionsImpl(this.getPubNubCore());
    }

    @NotNull
    public RemoveMessageAction removeMessageAction() {
        return new RemoveMessageActionImpl(this.getPubNubCore());
    }

    public SendFile.Builder sendFile() {
        return new SendFileImpl.Builder(this.getPubNubCore());
    }

    public ListFiles.Builder listFiles() {
        return new ListFilesImpl.Builder(this.getPubNubCore());
    }

    public GetFileUrl.Builder getFileUrl() {
        return GetFileUrlImpl.builder(this.getPubNubCore());
    }

    public DownloadFile.Builder downloadFile() {
        return DownloadFileImpl.builder(this.getPubNubCore());
    }

    public DeleteFile.Builder deleteFile() {
        return DeleteFileImpl.builder(this.getPubNubCore());
    }

    public PublishFileMessage.Builder publishFileMessage() {
        return PublishFileMessageImpl.builder(this.getPubNubCore());
    }

    public void reconnect() {
        this.reconnect(0L);
    }

    @NotNull
    private CryptoModule getCryptoModuleOrThrow(@Nullable String cipherKey) throws PubNubException {
        if (cipherKey != null) {
            if (this.configuration instanceof PNConfiguration) {
                return CryptoModule.createLegacyCryptoModule((String)cipherKey, (boolean)((PNConfiguration)this.configuration).getUseRandomInitializationVector());
            }
            return CryptoModule.createLegacyCryptoModule((String)cipherKey, (boolean)true);
        }
        if (this.configuration.getCryptoModule() != null) {
            return this.configuration.getCryptoModule();
        }
        throw new PubNubException(PubNubError.CRYPTO_ERROR, "Crypto module is not initialized");
    }

    @NotNull
    public String decrypt(@NotNull String inputString) throws PubNubException {
        return this.decrypt(inputString, null);
    }

    @NotNull
    public String decrypt(@NotNull String inputString, String cipherKey) throws PubNubException {
        if (inputString == null) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
        return this.getPubNubCore().decrypt(inputString, this.getCryptoModuleOrThrow(cipherKey));
    }

    @NotNull
    public InputStream decryptInputStream(@NotNull InputStream inputStream) throws PubNubException {
        return this.decryptInputStream(inputStream, null);
    }

    @NotNull
    public InputStream decryptInputStream(@NotNull InputStream inputStream, @Nullable String cipherKey) throws PubNubException {
        if (inputStream == null) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
        return this.getPubNubCore().decryptInputStream(inputStream, this.getCryptoModuleOrThrow(cipherKey));
    }

    @NotNull
    public String encrypt(@NotNull String inputString) throws PubNubException {
        return this.encrypt(inputString, null);
    }

    @NotNull
    public String encrypt(@NotNull String inputString, String cipherKey) throws PubNubException {
        if (inputString == null) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
        return this.getPubNubCore().encrypt(inputString, this.getCryptoModuleOrThrow(cipherKey));
    }

    @NotNull
    public InputStream encryptInputStream(@NotNull InputStream inputStream) throws PubNubException {
        return this.encryptInputStream(inputStream, null);
    }

    @NotNull
    public InputStream encryptInputStream(@NotNull InputStream inputStream, String cipherKey) throws PubNubException {
        return this.getPubNubCore().encryptInputStream(inputStream, this.getCryptoModuleOrThrow(cipherKey));
    }

    @NotNull
    public Publish fire() {
        return this.publish().shouldStore(Boolean.valueOf(false)).replicate(false);
    }

    @NotNull
    public PublishBuilder fire(Object message, String channel) {
        return this.publish(message, channel).shouldStore(Boolean.valueOf(false)).replicate(false);
    }

    @NotNull
    public List<String> getSubscribedChannels() {
        return this.getPubNubCore().getSubscribedChannels();
    }

    @NotNull
    public List<String> getSubscribedChannelGroups() {
        return this.getPubNubCore().getSubscribedChannelGroups();
    }

    @NotNull
    public Channel channel(@NotNull String name) {
        return new ChannelImpl(this, name);
    }

    @NotNull
    public ChannelGroup channelGroup(@NotNull String name) {
        return new ChannelGroupImpl(this, name);
    }

    @NotNull
    public ChannelMetadata channelMetadata(@NotNull String id) {
        return new ChannelMetadataImpl(this, id);
    }

    @NotNull
    public UserMetadata userMetadata(@NotNull String id) {
        return new UserMetadataImpl(this, id);
    }

    @NotNull
    public SubscriptionSet subscriptionSetOf(@NotNull Set<? extends Subscription> subscriptions) {
        return new SubscriptionSetImpl(this.getPubNubCore(), subscriptions);
    }

    public void addListener(@NotNull EventListener listener2) {
        this.getListenerManager().addListener((EventListenerCore)new DelegatingEventListener(listener2));
    }

    public void addListener(@NotNull StatusListener listener2) {
        this.getListenerManager().addListener((StatusListenerCore)new DelegatingStatusListener(listener2));
    }

    public void addListener(@NotNull com.pubnub.api.callbacks.SubscribeCallback listener2) {
        this.getListenerManager().addListener((SubscribeCallback)new DelegatingSubscribeCallback(listener2));
    }

    public void removeListener(@NotNull Listener listener2) {
        if (listener2 instanceof com.pubnub.api.callbacks.SubscribeCallback) {
            super.removeListener((Listener)new DelegatingSubscribeCallback((com.pubnub.api.callbacks.SubscribeCallback)listener2));
        } else if (listener2 instanceof EventListener) {
            super.removeListener((Listener)new DelegatingEventListener((EventListener)listener2));
        } else if (listener2 instanceof StatusListener) {
            super.removeListener((Listener)new DelegatingStatusListener((StatusListener)listener2));
        } else {
            super.removeListener(listener2);
        }
    }
}

