/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.push;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.push.ListPushProvisions;
import com.pubnub.api.models.consumer.push.PNPushListProvisionsResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;

public class ListPushProvisionsImpl
extends PassthroughEndpoint<PNPushListProvisionsResult>
implements ListPushProvisions {
    private PNPushType pushType;
    private String deviceId;
    private PNPushEnvironment environment = PNPushEnvironment.DEVELOPMENT;
    private String topic;

    public ListPushProvisionsImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNPushListProvisionsResult> createRemoteAction() {
        return this.pubnub.auditPushChannelProvisions(this.pushType, this.deviceId, this.topic, this.environment);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.pushType == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING);
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING);
        }
    }

    public ListPushProvisionsImpl pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public ListPushProvisionsImpl deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public ListPushProvisionsImpl environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public ListPushProvisionsImpl topic(String topic) {
        this.topic = topic;
        return this;
    }
}

