/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.pubsub;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.pubsub.Signal;
import com.pubnub.api.java.v2.endpoints.pubsub.SignalBuilder;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;

public class SignalImpl
extends PassthroughEndpoint<PNPublishResult>
implements Signal,
SignalBuilder {
    private Object message;
    private String channel;
    private String customMessageType;

    public SignalImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNPublishResult> createRemoteAction() {
        return this.pubnub.signal(this.channel, this.message, this.customMessageType);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.message == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_MESSAGE_MISSING);
        }
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public SignalImpl message(Object message) {
        this.message = message;
        return this;
    }

    public SignalImpl channel(String channel) {
        this.channel = channel;
        return this;
    }

    public SignalImpl customMessageType(String customMessageType) {
        this.customMessageType = customMessageType;
        return this;
    }
}

