/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.message_actions;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.message_actions.AddMessageAction;
import com.pubnub.api.models.consumer.message_actions.PNAddMessageActionResult;
import com.pubnub.api.models.consumer.message_actions.PNMessageAction;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;

public class AddMessageActionImpl
extends PassthroughEndpoint<PNAddMessageActionResult>
implements AddMessageAction {
    private String channel;
    private PNMessageAction messageAction;

    public AddMessageActionImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNAddMessageActionResult> createRemoteAction() {
        return this.pubnub.addMessageAction(this.channel, this.messageAction);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
        if (this.messageAction == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_MESSAGE_ACTION_MISSING);
        }
        if (this.messageAction.getMessageTimetoken() == null || this.messageAction.getMessageTimetoken() == 0L) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_MESSAGE_TIMETOKEN_MISSING);
        }
        if (this.messageAction.getValue().isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_MESSAGE_ACTION_VALUE_MISSING);
        }
    }

    public AddMessageActionImpl channel(String channel) {
        this.channel = channel;
        return this;
    }

    public AddMessageActionImpl messageAction(PNMessageAction messageAction) {
        this.messageAction = messageAction;
        return this;
    }
}

