/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.MessageCounts;
import com.pubnub.api.models.consumer.history.PNMessageCountResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MessageCountsImpl
extends PassthroughEndpoint<PNMessageCountResult>
implements MessageCounts {
    private List<String> channels;
    private List<Long> channelsTimetoken;

    public MessageCountsImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNMessageCountResult> createRemoteAction() {
        return this.pubnub.messageCounts(this.channels, this.channelsTimetoken);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channels == null || this.channels.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
        if (this.channelsTimetoken == null || this.channelsTimetoken.contains(null)) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_TIMETOKEN_MISSING);
        }
    }

    public MessageCountsImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public MessageCountsImpl channelsTimetoken(List<Long> channelsTimetoken) {
        this.channelsTimetoken = channelsTimetoken;
        return this;
    }
}

