/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.push;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.push.RemoveAllPushChannelsForDevice;
import com.pubnub.api.models.consumer.push.PNPushRemoveAllChannelsResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import org.jetbrains.annotations.NotNull;

public class RemoveAllPushChannelsForDeviceImpl
extends PassthroughEndpoint<PNPushRemoveAllChannelsResult>
implements RemoveAllPushChannelsForDevice {
    private PNPushType pushType;
    private String deviceId;
    private PNPushEnvironment environment = PNPushEnvironment.DEVELOPMENT;
    private String topic;

    public RemoveAllPushChannelsForDeviceImpl(PubNub pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected Endpoint<PNPushRemoveAllChannelsResult> createRemoteAction() {
        return this.pubnub.removeAllPushNotificationsFromDeviceWithPushToken(this.pushType, this.deviceId, this.topic, this.environment);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.pushType == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING);
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING);
        }
    }

    public RemoveAllPushChannelsForDeviceImpl pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    public RemoveAllPushChannelsForDeviceImpl deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public RemoveAllPushChannelsForDeviceImpl environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public RemoveAllPushChannelsForDeviceImpl topic(String topic) {
        this.topic = topic;
        return this;
    }
}

