/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.objects_api.memberships;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.java.endpoints.objects_api.memberships.SetMemberships;
import com.pubnub.api.java.endpoints.objects_api.memberships.SetMembershipsBuilder;
import com.pubnub.api.java.endpoints.objects_api.utils.Include;
import com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNChannelMembership;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNSetMembershipResult;
import com.pubnub.api.java.models.consumer.objects_api.membership.PNSetMembershipResultConverter;
import com.pubnub.api.models.consumer.objects.PNMembershipKey;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects.PNSortKey;
import com.pubnub.api.models.consumer.objects.SortField;
import com.pubnub.api.models.consumer.objects.membership.MembershipInclude;
import com.pubnub.api.models.consumer.objects.membership.PNChannelDetailsLevel;
import com.pubnub.api.models.consumer.objects.membership.PNChannelMembership;
import com.pubnub.api.models.consumer.objects.membership.PNChannelMembershipArrayResult;
import com.pubnub.internal.java.endpoints.DelegatingEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetMembershipsImpl
extends DelegatingEndpoint<PNChannelMembershipArrayResult, PNSetMembershipResult>
implements SetMemberships,
SetMembershipsBuilder {
    private final Collection<PNChannelMembership> channels;
    private String uuid;
    private String userId;
    private Integer limit;
    private PNPage page;
    private String filter;
    private Collection<com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private boolean includeType;
    private Include.PNChannelDetailsLevel includeChannel;
    private com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude include;

    public SetMembershipsImpl(@NotNull Collection<PNChannelMembership> channelMemberships, PubNub pubnubInstance) {
        super(pubnubInstance);
        this.channels = channelMemberships;
    }

    @Override
    @NotNull
    protected Endpoint<PNChannelMembershipArrayResult> createRemoteAction() {
        ArrayList<PNChannelMembership.Partial> channelList = new ArrayList<PNChannelMembership.Partial>(this.channels.size());
        for (PNChannelMembership channel : this.channels) {
            channelList.add(new PNChannelMembership.Partial(channel.getChannel().getId(), channel.getCustom(), channel.getStatus(), channel.getType()));
        }
        return this.pubnub.setMemberships(channelList, this.getUserId(), this.limit, this.page, this.filter, SetMembershipsImpl.toInternal(this.sort), (MembershipInclude)SetMembershipsImpl.getMembershipInclude(this.include, this.includeChannel, this.includeTotalCount, this.includeCustom, this.includeType));
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNSetMembershipResult> mapResult(@NotNull ExtendedRemoteAction<PNChannelMembershipArrayResult> action) {
        return new MappingRemoteAction(action, PNSetMembershipResultConverter::from);
    }

    @Nullable
    static PNChannelDetailsLevel toInternal(@Nullable Include.PNChannelDetailsLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        switch (detailLevel) {
            case CHANNEL: {
                return PNChannelDetailsLevel.CHANNEL;
            }
            case CHANNEL_WITH_CUSTOM: {
                return PNChannelDetailsLevel.CHANNEL_WITH_CUSTOM;
            }
        }
        throw new IllegalStateException("Unknown detail level: " + detailLevel);
    }

    static Collection<? extends PNSortKey<PNMembershipKey>> toInternal(Collection<com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey> sort) {
        ArrayList<Object> list = new ArrayList<Object>(sort.size());
        for (com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey pnSortKey : sort) {
            PNMembershipKey key = null;
            switch (pnSortKey.getKey()) {
                case ID: {
                    key = PNMembershipKey.CHANNEL_ID;
                    break;
                }
                case NAME: {
                    key = PNMembershipKey.CHANNEL_NAME;
                    break;
                }
                case UPDATED: {
                    key = PNMembershipKey.CHANNEL_UPDATED;
                    break;
                }
                case STATUS: {
                    key = PNMembershipKey.STATUS;
                    break;
                }
                case TYPE: {
                    key = PNMembershipKey.TYPE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should never happen");
                }
            }
            if (pnSortKey.getDir().equals((Object)PNSortKey.Dir.ASC)) {
                list.add(new PNSortKey.PNAsc((SortField)key));
                continue;
            }
            list.add(new PNSortKey.PNDesc((SortField)key));
        }
        return list;
    }

    private String getUserId() {
        return this.userId != null ? this.userId : this.uuid;
    }

    static com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude getMembershipInclude(com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude include, Include.PNChannelDetailsLevel includeChannel, boolean includeTotalCount, boolean includeCustom, boolean includeType) {
        if (include != null) {
            return include;
        }
        MembershipInclude.Builder builderWithCommonParams = com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude.builder().includeTotalCount(includeTotalCount).includeCustom(includeCustom).includeChannelType(includeType);
        if (includeChannel == Include.PNChannelDetailsLevel.CHANNEL) {
            return builderWithCommonParams.includeChannel(true).build();
        }
        if (includeChannel == Include.PNChannelDetailsLevel.CHANNEL_WITH_CUSTOM) {
            return builderWithCommonParams.includeChannel(true).includeChannelCustom(true).build();
        }
        return builderWithCommonParams.build();
    }

    public SetMembershipsImpl uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public SetMembershipsImpl userId(String userId) {
        this.userId = userId;
        return this;
    }

    public SetMembershipsImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public SetMembershipsImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    public SetMembershipsImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    public SetMembershipsImpl sort(Collection<com.pubnub.api.java.endpoints.objects_api.utils.PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    public SetMembershipsImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    public SetMembershipsImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    public SetMembershipsImpl includeType(boolean includeType) {
        this.includeType = includeType;
        return this;
    }

    public SetMembershipsImpl includeChannel(Include.PNChannelDetailsLevel includeChannel) {
        this.includeChannel = includeChannel;
        return this;
    }

    public SetMembershipsImpl include(com.pubnub.api.java.models.consumer.objects_api.membership.MembershipInclude include) {
        this.include = include;
        return this;
    }

    public static class BuilderDeprecated
    implements SetMemberships.Builder {
        private final PubNub pubnubInstance;

        public BuilderDeprecated(PubNub pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }

        public SetMemberships channelMemberships(@NotNull Collection<PNChannelMembership> channelMemberships) {
            return new SetMembershipsImpl(channelMemberships, this.pubnubInstance);
        }
    }
}

