/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.BuilderSteps;
import com.pubnub.api.java.endpoints.files.PublishFileMessage;
import com.pubnub.api.java.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import com.pubnub.internal.java.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import org.jetbrains.annotations.NotNull;

public class PublishFileMessageImpl
extends PassthroughEndpoint<PNPublishFileMessageResult>
implements PublishFileMessage {
    private Object message;
    private Object meta;
    private Integer ttl;
    private Boolean shouldStore;
    private String customMessageType;
    private final String channel;
    private final String fileName;
    private final String fileId;

    public PublishFileMessageImpl(String channel, String fileName, String fileId, PubNub pubnub) {
        super(pubnub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
    }

    @Override
    @NotNull
    protected Endpoint<PNPublishFileMessageResult> createRemoteAction() {
        return this.pubnub.publishFileMessage(this.channel, this.fileName, this.fileId, this.message, this.meta, this.ttl, this.shouldStore, this.customMessageType);
    }

    public static PublishFileMessage.Builder builder(PubNub pubNub) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new PublishFileMessageImpl((String)channel, (String)fileName, (String)fileId, pubNub)));
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public PublishFileMessageImpl message(Object message) {
        this.message = message;
        return this;
    }

    public PublishFileMessageImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    public PublishFileMessageImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public PublishFileMessageImpl shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    public PublishFileMessageImpl customMessageType(String customMessageType) {
        this.customMessageType = customMessageType;
        return this;
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<PublishFileMessage>
    implements PublishFileMessage.Builder {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<PublishFileMessage>>> builder) {
            super(builder);
        }
    }
}

