/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.java.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.java.builder.PubNubErrorBuilder;
import com.pubnub.api.java.endpoints.BuilderSteps;
import com.pubnub.api.java.endpoints.files.DownloadFile;
import com.pubnub.api.java.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.models.consumer.files.PNDownloadFileResult;
import com.pubnub.internal.java.endpoints.PassthroughEndpoint;
import com.pubnub.internal.java.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import org.jetbrains.annotations.NotNull;

public class DownloadFileImpl
extends PassthroughEndpoint<PNDownloadFileResult>
implements DownloadFile {
    private final String channel;
    private final String fileId;
    private final String fileName;
    private String cipherKey;

    public DownloadFileImpl(String channel, String fileId, String fileName, PubNub pubnub) {
        super(pubnub);
        this.channel = channel;
        this.fileId = fileId;
        this.fileName = fileName;
    }

    @Override
    @NotNull
    protected Endpoint<PNDownloadFileResult> createRemoteAction() {
        return this.pubnub.downloadFile(this.channel, this.fileName, this.fileId, this.cipherKey);
    }

    public static Builder builder(PubNub pubnub) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new DownloadFileImpl((String)channel, (String)fileId, (String)fileName, pubnub)));
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    public DownloadFileImpl cipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<DownloadFile>
    implements DownloadFile.Builder {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<DownloadFile>>> builder) {
            super(builder);
        }
    }
}

