/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.push;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushAddChannelResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.endpoints.push.AddChannelsToPushInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BC\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0014J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0#j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001bH\u0014R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/pubnub/internal/endpoints/push/AddChannelsToPushEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/push/PNPushAddChannelResult;", "Lcom/pubnub/internal/endpoints/push/AddChannelsToPushInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "pushType", "Lcom/pubnub/api/enums/PNPushType;", "channels", "", "", "deviceId", "topic", "environment", "Lcom/pubnub/api/enums/PNPushEnvironment;", "(Lcom/pubnub/internal/PubNubCore;Lcom/pubnub/api/enums/PNPushType;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/enums/PNPushEnvironment;)V", "getChannels", "()Ljava/util/List;", "getDeviceId", "()Ljava/lang/String;", "getEnvironment", "()Lcom/pubnub/api/enums/PNPushEnvironment;", "getPushType", "()Lcom/pubnub/api/enums/PNPushType;", "getTopic", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAddPushNotificationsOnChannelsOperation;", "validateParams", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nAddChannelsToPushEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddChannelsToPushEndpoint.kt\ncom/pubnub/internal/endpoints/push/AddChannelsToPushEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class AddChannelsToPushEndpoint
extends EndpointCore<Void, PNPushAddChannelResult>
implements AddChannelsToPushInterface {
    @NotNull
    private final PNPushType pushType;
    @NotNull
    private final List<String> channels;
    @NotNull
    private final String deviceId;
    @Nullable
    private final String topic;
    @NotNull
    private final PNPushEnvironment environment;

    public AddChannelsToPushEndpoint(@NotNull PubNubCore pubnub, @NotNull PNPushType pushType, @NotNull List<String> channels, @NotNull String deviceId, @Nullable String topic, @NotNull PNPushEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)pushType, (String)"pushType");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(pubnub);
        this.pushType = pushType;
        this.channels = channels;
        this.deviceId = deviceId;
        this.topic = topic;
        this.environment = environment;
    }

    public /* synthetic */ AddChannelsToPushEndpoint(PubNubCore pubNubCore, PNPushType pNPushType, List list, String string, String string2, PNPushEnvironment pNPushEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            pNPushEnvironment = PNPushEnvironment.DEVELOPMENT;
        }
        this(pubNubCore, pNPushType, list, string, string2, pNPushEnvironment);
    }

    @Override
    @NotNull
    public PNPushType getPushType() {
        return this.pushType;
    }

    @Override
    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public PNPushEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    protected void validateParams() {
        CharSequence charSequence;
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getDeviceId())) {
            throw new PubNubException(PubNubError.DEVICE_ID_MISSING);
        }
        if (this.getChannels().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.getPushType() == PNPushType.APNS2 && ((charSequence = (CharSequence)this.getTopic()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            throw new PubNubException(PubNubError.PUSH_TOPIC_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPushType() != PNPushType.APNS2 ? this.getRetrofitManager().getPushService$pubnub_core_impl().modifyChannelsForDevice(this.getConfiguration().getSubscribeKey(), this.getDeviceId(), (Map<String, String>)queryParams) : this.getRetrofitManager().getPushService$pubnub_core_impl().modifyChannelsForDeviceApns2(this.getConfiguration().getSubscribeKey(), this.getDeviceId(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPushAddChannelResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNPushAddChannelResult();
    }

    @NotNull
    public PNOperationType.PNAddPushNotificationsOnChannelsOperation operationType() {
        return PNOperationType.PNAddPushNotificationsOnChannelsOperation;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUSH_NOTIFICATION;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block1: {
            queryParams.put("add", PubNubUtilKt.toCsv(this.getChannels()));
            if (this.getPushType() != PNPushType.APNS2) {
                queryParams.put("type", this.getPushType().toParamString());
                return;
            }
            Map<String, String> map = queryParams;
            String string = "environment";
            String string2 = this.getEnvironment().name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            string2 = string3;
            map.put(string, string2);
            String string4 = this.getTopic();
            if (string4 == null) break block1;
            String $this$addQueryParams_u24lambda_u240 = string4;
            boolean bl = false;
            queryParams.put("topic", $this$addQueryParams_u24lambda_u240);
        }
    }
}

