/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.pubsub;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.crypto.CryptoModuleImplKt;
import com.pubnub.internal.endpoints.pubsub.PublishInterface;
import com.pubnub.internal.extension.BooleanKt;
import com.pubnub.internal.extension.StringKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005BW\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$H\u0002J\u001c\u0010%\u001a\u00020\u00042\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020'H\u0014J8\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020)2\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0*j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`+H\u0014J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u0002H\u0014J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002J\b\u0010.\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\b\u00101\u001a\u00020\rH\u0014J\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\b\u00105\u001a\u00020\"H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u000f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000e\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019\u00a8\u00066"}, d2={"Lcom/pubnub/internal/endpoints/pubsub/PublishEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "", "", "Lcom/pubnub/api/models/consumer/PNPublishResult;", "Lcom/pubnub/internal/endpoints/pubsub/PublishInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "message", "channel", "", "meta", "shouldStore", "", "usePost", "replicate", "ttl", "", "(Lcom/pubnub/internal/PubNubCore;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Boolean;ZZLjava/lang/Integer;)V", "getChannel", "()Ljava/lang/String;", "getMessage", "()Ljava/lang/Object;", "getMeta", "getReplicate", "()Z", "getShouldStore", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getTtl", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getUsePost", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "getBodyMessage", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "getParamMessage", "isPubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNPublishOperation;", "toJson", "validateParams", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nPublishEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishEndpoint.kt\ncom/pubnub/internal/endpoints/pubsub/PublishEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class PublishEndpoint
extends EndpointCore<List<? extends Object>, PNPublishResult>
implements PublishInterface {
    @NotNull
    private final Object message;
    @NotNull
    private final String channel;
    @Nullable
    private final Object meta;
    @Nullable
    private final Boolean shouldStore;
    private final boolean usePost;
    private final boolean replicate;
    @Nullable
    private final Integer ttl;

    public PublishEndpoint(@NotNull PubNubCore pubnub, @NotNull Object message, @NotNull String channel, @Nullable Object meta, @Nullable Boolean shouldStore, boolean usePost, boolean replicate, @Nullable Integer ttl) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.message = message;
        this.channel = channel;
        this.meta = meta;
        this.shouldStore = shouldStore;
        this.usePost = usePost;
        this.replicate = replicate;
        this.ttl = ttl;
    }

    public /* synthetic */ PublishEndpoint(PubNubCore pubNubCore, Object object, String string, Object object2, Boolean bl, boolean bl2, boolean bl3, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            object2 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x80) != 0) {
            n = null;
        }
        this(pubNubCore, object, string, object2, bl, bl2, bl3, n);
    }

    @Override
    @NotNull
    public Object getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public Object getMeta() {
        return this.meta;
    }

    @Override
    @Nullable
    public Boolean getShouldStore() {
        return this.shouldStore;
    }

    @Override
    public boolean getUsePost() {
        return this.usePost;
    }

    @Override
    public boolean getReplicate() {
        return this.replicate;
    }

    @Override
    @Nullable
    public Integer getTtl() {
        return this.ttl;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.getChannel());
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) {
        Call<List<Object>> call;
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        if (this.getUsePost()) {
            Object payload = this.getBodyMessage(this.getMessage());
            call = this.getRetrofitManager().getPublishService$pubnub_core_impl().publishWithPost(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.getChannel(), payload, (Map<String, String>)queryParams);
        } else {
            String stringifiedMessage = this.getParamMessage(this.getMessage());
            call = this.getRetrofitManager().getPublishService$pubnub_core_impl().publish(this.getConfiguration().getPublishKey(), this.getConfiguration().getSubscribeKey(), this.getChannel(), stringifiedMessage, (Map<String, String>)queryParams);
        }
        return call;
    }

    @Override
    @NotNull
    protected PNPublishResult createResponse(@NotNull Response<List<Object>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPublishResult(Long.parseLong(((List)object).get(2).toString()));
    }

    @NotNull
    public PNOperationType.PNPublishOperation operationType() {
        return PNOperationType.PNPublishOperation;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUBLISH;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        Object object = this.getMeta();
        if (object != null) {
            Object $this$addQueryParams_u24lambda_u240 = object;
            boolean bl = false;
            queryParams.put("meta", this.getPubnub().getMapper().toJson($this$addQueryParams_u24lambda_u240));
        }
        Boolean bl = this.getShouldStore();
        if (bl != null) {
            boolean $this$addQueryParams_u24lambda_u241 = bl;
            boolean bl2 = false;
            queryParams.put("store", BooleanKt.getNumericString($this$addQueryParams_u24lambda_u241));
        }
        Integer n = this.getTtl();
        if (n != null) {
            int $this$addQueryParams_u24lambda_u242 = ((Number)n).intValue();
            boolean bl3 = false;
            queryParams.put("ttl", String.valueOf($this$addQueryParams_u24lambda_u242));
        }
        if (!this.getReplicate()) {
            queryParams.put("norep", BooleanKt.getValueString(true));
        }
        queryParams.put("seqn", String.valueOf(this.getPubnub().getPublishSequenceManager$pubnub_core_impl().nextSequence$pubnub_core_impl()));
    }

    private final Object getBodyMessage(Object message) {
        Object object = this.getConfiguration().getCryptoModule();
        if (object == null || (object = CryptoModuleImplKt.encryptString(object, this.toJson(message))) == null) {
            object = message;
        }
        return object;
    }

    private final String getParamMessage(Object message) {
        Object object = this.getConfiguration().getCryptoModule();
        if (object == null || (object = CryptoModuleImplKt.encryptString(object, this.toJson(message))) == null || (object = StringKt.quoted((String)object)) == null) {
            object = this.toJson(message);
        }
        return object;
    }

    private final String toJson(Object message) {
        return this.getPubnub().getMapper().toJson(message);
    }
}

