/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNFile;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.models.server.files.FileUploadRequestDetails;
import com.pubnub.internal.models.server.files.FormField;
import com.pubnub.internal.models.server.files.GenerateUploadUrlPayload;
import com.pubnub.internal.models.server.files.GeneratedUploadUrlResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0014J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0010j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001bH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/files/GeneratedUploadUrlResponse;", "Lcom/pubnub/internal/models/server/files/FileUploadRequestDetails;", "channel", "", "fileName", "pubNub", "Lcom/pubnub/internal/PubNubCore;", "(Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/internal/PubNubCore;)V", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "getKeyFormField", "Lcom/pubnub/internal/models/server/files/FormField;", "response", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "Factory", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nGenerateUploadUrlEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateUploadUrlEndpoint.kt\ncom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class GenerateUploadUrlEndpoint
extends EndpointCore<GeneratedUploadUrlResponse, FileUploadRequestDetails> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;

    public GenerateUploadUrlEndpoint(@NotNull String channel, @NotNull String fileName, @NotNull PubNubCore pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected FileUploadRequestDetails createResponse(@NotNull Response<GeneratedUploadUrlResponse> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (input.body() == null) {
            throw PubNubException.copy$default((PubNubException)new PubNubException(PubNubError.INTERNAL_ERROR), (String)"Empty body, but GeneratedUploadUrlResponse expected", null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
        }
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        GeneratedUploadUrlResponse response = (GeneratedUploadUrlResponse)object;
        FormField keyFormField = this.getKeyFormField(response);
        return new FileUploadRequestDetails(response.getStatus(), (PNFile)response.getData(), response.getFileUploadRequest().getUrl(), response.getFileUploadRequest().getMethod(), response.getFileUploadRequest().getExpirationDate(), keyFormField, response.getFileUploadRequest().getFormFields());
    }

    private final FormField getKeyFormField(GeneratedUploadUrlResponse response) throws PubNubException {
        Object v0;
        block2: {
            List<FormField> formFields = response.getFileUploadRequest().getFormFields();
            Iterable iterable = formFields;
            for (Object t : iterable) {
                FormField it = (FormField)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"key")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        FormField formField = v0;
        if (formField == null) {
            throw PubNubException.copy$default((PubNubException)new PubNubException(PubNubError.INTERNAL_ERROR), (String)"Couldn't find `key` form field in GeneratedUploadUrlResponse", null, null, (int)0, null, null, null, null, null, null, null, (int)2046, null);
        }
        return formField;
    }

    @Override
    @NotNull
    protected Call<GeneratedUploadUrlResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getRetrofitManager().getFilesService$pubnub_core_impl().generateUploadUrl(this.getConfiguration().getSubscribeKey(), this.channel, new GenerateUploadUrlPayload(this.fileName), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public PNOperationType operationType() {
        return (PNOperationType)PNOperationType.FileOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.FILE_PERSISTENCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint$Factory;", "", "pubNub", "Lcom/pubnub/internal/PubNubCore;", "(Lcom/pubnub/internal/PubNubCore;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/internal/models/server/files/FileUploadRequestDetails;", "channel", "", "fileName", "pubnub-core-impl"})
    public static final class Factory {
        @NotNull
        private final PubNubCore pubNub;

        public Factory(@NotNull PubNubCore pubNub) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final ExtendedRemoteAction<FileUploadRequestDetails> create(@NotNull String channel, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new GenerateUploadUrlEndpoint(channel, fileName, this.pubNub);
        }
    }
}

