/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.v2.subscription;

import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.v2.callbacks.BaseEventListener;
import com.pubnub.api.v2.subscriptions.BaseSubscription;
import com.pubnub.api.v2.subscriptions.FilterImpl;
import com.pubnub.api.v2.subscriptions.SubscriptionCursor;
import com.pubnub.api.v2.subscriptions.SubscriptionOptions;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.managers.AnnouncementEnvelope;
import com.pubnub.internal.v2.callbacks.EventEmitterImpl;
import com.pubnub.internal.v2.callbacks.EventListenerCore;
import com.pubnub.internal.v2.entities.ChannelGroupName;
import com.pubnub.internal.v2.entities.ChannelName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BX\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000f0\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010$\u001a\u00020\u001b2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0004J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020'H\u0002J\b\u0010.\u001a\u00020)H\u0016J\u0015\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020)H\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020)H\u0016J\u0010\u00106\u001a\u00020)2\u0006\u0010*\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016J\b\u00109\u001a\u00020)H\u0016R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0080\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006:"}, d2={"Lcom/pubnub/internal/v2/subscription/BaseSubscriptionImpl;", "T", "Lcom/pubnub/api/v2/callbacks/BaseEventListener;", "Lcom/pubnub/api/v2/subscriptions/BaseSubscription;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channels", "", "Lcom/pubnub/internal/v2/entities/ChannelName;", "channelGroups", "Lcom/pubnub/internal/v2/entities/ChannelGroupName;", "options", "Lcom/pubnub/api/v2/subscriptions/SubscriptionOptions;", "eventEmitterFactory", "Lkotlin/Function1;", "Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "(Lcom/pubnub/internal/PubNubCore;Ljava/util/Set;Ljava/util/Set;Lcom/pubnub/api/v2/subscriptions/SubscriptionOptions;Lkotlin/jvm/functions/Function1;)V", "getChannelGroups$pubnub_core_impl", "()Ljava/util/Set;", "getChannels$pubnub_core_impl", "eventEmitter", "getEventEmitter", "()Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "filters", "", "Lcom/pubnub/api/v2/subscriptions/FilterImpl;", "newValue", "", "isActive", "()Z", "setActive", "(Z)V", "lastTimetoken", "", "getPubnub$pubnub_core_impl", "()Lcom/pubnub/internal/PubNubCore;", "accepts", "envelope", "Lcom/pubnub/internal/managers/AnnouncementEnvelope;", "Lcom/pubnub/api/models/consumer/pubsub/PNEvent;", "addListener", "", "listener", "Lcom/pubnub/internal/v2/callbacks/EventListenerCore;", "checkAndUpdateTimetoken", "result", "close", "onSubscriptionActive", "cursor", "Lcom/pubnub/api/v2/subscriptions/SubscriptionCursor;", "onSubscriptionActive$pubnub_core_impl", "onSubscriptionInactive", "onSubscriptionInactive$pubnub_core_impl", "removeAllListeners", "removeListener", "Lcom/pubnub/api/callbacks/Listener;", "subscribe", "unsubscribe", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nBaseSubscriptionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSubscriptionImpl.kt\ncom/pubnub/internal/v2/subscription/BaseSubscriptionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n800#2,11:111\n1726#2,3:122\n*S KotlinDebug\n*F\n+ 1 BaseSubscriptionImpl.kt\ncom/pubnub/internal/v2/subscription/BaseSubscriptionImpl\n*L\n42#1:111,11\n56#1:122,3\n*E\n"})
public abstract class BaseSubscriptionImpl<T extends BaseEventListener>
implements BaseSubscription<T> {
    @NotNull
    private final PubNubCore pubnub;
    private volatile boolean isActive;
    @NotNull
    private final Set<ChannelName> channels;
    @NotNull
    private final Set<ChannelGroupName> channelGroups;
    @NotNull
    private final List<FilterImpl> filters;
    private long lastTimetoken;
    @NotNull
    private final EventEmitterImpl eventEmitter;

    /*
     * WARNING - void declaration
     */
    public BaseSubscriptionImpl(@NotNull PubNubCore pubnub, @NotNull Set<ChannelName> channels, @NotNull Set<ChannelGroupName> channelGroups, @Nullable SubscriptionOptions options, @NotNull Function1<? super BaseSubscriptionImpl<T>, EventEmitterImpl> eventEmitterFactory) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter(eventEmitterFactory, (String)"eventEmitterFactory");
        this.pubnub = pubnub;
        this.channels = CollectionsKt.toSet((Iterable)channels);
        this.channelGroups = CollectionsKt.toSet((Iterable)channelGroups);
        BaseSubscriptionImpl baseSubscriptionImpl = this;
        Object object = options;
        if (object != null && (object = object.getAllOptions()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = (Iterable)object;
            BaseSubscriptionImpl baseSubscriptionImpl2 = baseSubscriptionImpl;
            boolean $i$f$filterIsInstance = false;
            void var8_9 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FilterImpl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            baseSubscriptionImpl = baseSubscriptionImpl2;
        } else {
            list = CollectionsKt.emptyList();
        }
        baseSubscriptionImpl.filters = list;
        this.eventEmitter = (EventEmitterImpl)eventEmitterFactory.invoke((Object)this);
    }

    public /* synthetic */ BaseSubscriptionImpl(PubNubCore pubNubCore, Set set, Set set2, SubscriptionOptions subscriptionOptions, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            subscriptionOptions = null;
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        this(pubNubCore, set, set2, subscriptionOptions, function1);
    }

    @NotNull
    public final PubNubCore getPubnub$pubnub_core_impl() {
        return this.pubnub;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final synchronized void setActive(boolean newValue) {
        if (!this.isActive && newValue) {
            this.pubnub.getListenerManager().addAnnouncementCallback$pubnub_core_impl(this.eventEmitter);
        } else if (this.isActive && !newValue) {
            this.pubnub.getListenerManager().removeAnnouncementCallback$pubnub_core_impl(this.eventEmitter);
        }
        this.isActive = newValue;
    }

    @NotNull
    public final Set<ChannelName> getChannels$pubnub_core_impl() {
        return this.channels;
    }

    @NotNull
    public final Set<ChannelGroupName> getChannelGroups$pubnub_core_impl() {
        return this.channelGroups;
    }

    @NotNull
    protected final EventEmitterImpl getEventEmitter() {
        return this.eventEmitter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean accepts(@NotNull AnnouncementEnvelope<? extends PNEvent> envelope) {
        boolean bl;
        Intrinsics.checkNotNullParameter(envelope, (String)"envelope");
        PNEvent event = envelope.getEvent();
        if (!this.isActive) return false;
        Iterable $this$all$iv = this.filters;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                FilterImpl filter = (FilterImpl)element$iv;
                boolean bl2 = false;
                if (((Boolean)filter.getPredicate().invoke((Object)event)).booleanValue()) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (!this.checkAndUpdateTimetoken(event)) return false;
        boolean bl3 = true;
        boolean accepted = bl3;
        if (!accepted) return accepted;
        ((Collection)envelope.getAcceptedBy()).add(this);
        return accepted;
    }

    private final boolean checkAndUpdateTimetoken(PNEvent result) {
        Long l = result.getTimetoken();
        if (l != null) {
            long resultTimetoken = ((Number)l).longValue();
            boolean bl = false;
            if (resultTimetoken <= this.lastTimetoken) {
                return false;
            }
            this.lastTimetoken = resultTimetoken;
            return true;
        }
        return false;
    }

    public void subscribe(@NotNull SubscriptionCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        this.onSubscriptionActive$pubnub_core_impl(cursor);
        BaseSubscriptionImpl[] baseSubscriptionImplArray = new BaseSubscriptionImpl[]{this};
        this.pubnub.subscribe$pubnub_core_impl(baseSubscriptionImplArray, cursor);
    }

    public final void onSubscriptionActive$pubnub_core_impl(@NotNull SubscriptionCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        this.lastTimetoken = cursor.getTimetoken();
        this.setActive(true);
    }

    public void unsubscribe() {
        this.onSubscriptionInactive$pubnub_core_impl();
        BaseSubscriptionImpl[] baseSubscriptionImplArray = new BaseSubscriptionImpl[]{this};
        this.pubnub.unsubscribe$pubnub_core_impl(baseSubscriptionImplArray);
    }

    public final void onSubscriptionInactive$pubnub_core_impl() {
        this.lastTimetoken = 0L;
        this.setActive(false);
    }

    public void close() {
        this.unsubscribe();
    }

    protected final void addListener(@NotNull EventListenerCore listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventEmitter.addListener(listener);
    }

    public void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventEmitter.removeListener(listener);
    }

    public void removeAllListeners() {
        this.eventEmitter.removeAllListeners();
    }
}

